<?php
/**
 * @version Id: view.php version 1.0 2007-09-01 
 * @package CMS Shopbuilder for joomla
 * @copyright Copyright (C) 2005 - 2008 wasan ongart. All rights reserved.
 */

// no direct access
defined( '_JEXEC' ) or die( 'Restricted access' );

jimport('joomla.application.component.view');


class CmsShopbuilderViewMs_cat extends JView
{
	var $_name = 'ms_cat';
	
	function display($tpl=null)
	{
		global $mainframe;
		$this->_layout = 'default';
		/*
		 * Set toolbar items for the page
		 */
		JToolBarHelper::title( JText::_( 'Category Manager' ), 'generic.png' );
		$bar =& JToolBar::getInstance('toolbar');
		$task = JRequest::getCmd('task');
		
		JToolBarHelper::publishList();
		JToolBarHelper::unpublishList();
		JToolBarHelper::deleteList();
		
		JToolBarHelper::editListX();
		JToolBarHelper::addNewX();
		JToolBarHelper::customX( 'close', 'cancel.png', 'cancel_f2.png', 'Close',false );



		$document = & JFactory::getDocument();
		$document->setTitle(JText::_('View Category Items'));

		$limitstart = JRequest::getVar('limitstart', '0', '', 'int');
		$items		= &$this->get('Items');
		
		$pagination	= &$this->get('Pagination');
		$lists		= &$this->_getViewLists();
		
		//Ordering allowed ?
		$ordering = ($lists['order'] == 'c.ordering');
		JHTML::_('behavior.tooltip');
		$this->assignRef('items', $items);
		$this->assignRef('pagination', $pagination);
		$this->assignRef('lists', $lists);
		$this->assignRef('ordering', $ordering);
		$this->assignRef('limitstart', $limitstart);
		parent::display($tpl);
	}

	

	function &_getViewLists()
	{
		global $mainframe;
		$db		=& JFactory::getDBO();
		
		//$context			= 'com_cmsshopbuilder.ms_cat.';
		$filter_order		= $mainframe->getUserStateFromRequest('filter_order',		'filter_order',		'c.ordering',	'cmd' );
		$filter_order_Dir	= $mainframe->getUserStateFromRequest( 'filter_order_Dir',	'filter_order_Dir',	'ASC',			'word' );
		$filter_state		= $mainframe->getUserStateFromRequest( 'filter_state',		'filter_state',		'',				'word' );
		$limitstart			= $mainframe->getUserStateFromRequest( 'limitstart',		'limitstart',		0,				'int' );
		$levellimit			= $mainframe->getUserStateFromRequest( 'levellimit',		'levellimit',		10,				'int' );
		$search				= $mainframe->getUserStateFromRequest( 'search',			'search',			'',				'string' );
		$search				= JString::strtolower( $search );

		// level limit filter
		$lists['levellist'] = JHTML::_('select.integerlist',    1, 10, 1, 'levellimit', 'size="1" onchange="document.adminForm.submit();"', $levellimit );

		// state filter
		$lists['state']	= JHTML::_('grid.state',  $filter_state );

		// table ordering
		$lists['order_Dir']	= $filter_order_Dir;
		$lists['order']		= $filter_order;

		// search filter
		$lists['search']= $search;

		return $lists;
	}
}