<?php
/**
 * @version Id: ms_content.php version 1.0 2007-09-01 
 * @package CMS Shop Builder for joomla
 * @copyright Copyright (C) 2005 - 2008 wasan ongart. All rights reserved.
 */


// no direct access
defined( '_JEXEC' ) or die( 'Restricted access' );


class Ms_contentsViewContent
{
	function setMs_contentsToolbar()
	{
		JToolBarHelper::title( JText::_( 'Content Manager' ), 'generic.png' );
		JToolBarHelper::customX( 'unpublish', 'unpublish.png', 'unpublish_f2.png', 'Move Selected to Import Manager',true );
		JToolBarHelper::customX( 'removeall', 'cancel.png', 'cancel_f2.png', 'Move All to Import Manager',false );
		//JToolBarHelper::customX( 'moveproduct', 'move.png', 'move_f2.png', 'Move',true );
		//JToolBarHelper::editListX();
		//JToolBarHelper::addNewX();
		JToolBarHelper::customX( 'close', 'cancel.png', 'cancel_f2.png', 'Close',false );

	}

	function ms_contents( &$rows, &$pageNav, &$lists ,$cat_id,$showimage)
	{
		Ms_contentsViewContent::setMs_contentsToolbar();
		
		JHTML::_('behavior.tooltip');
		?>

		
		<script language="javascript" type="text/javascript">
		function submitbutton(pressbutton) {
			var form = document.adminForm;
			if (pressbutton == 'removeall') {
			    if (confirm('Are you sure you want to remove all products from you Joomla content?'))
					 submitform( pressbutton );
			}else {
				submitform( pressbutton );
			}
		}
		
		</script>
		
		<form action="index.php?option=com_cmsshopbuilder&c=ms_content" method="post" name="adminForm">
		<table>
		<tr>
			<td align="left" width="100%">
				<?php echo JText::_( 'Filter' ); ?>:
				<input type="text" name="search" id="search" value="<?php echo $lists['search'];?>" class="text_area" onchange="document.adminForm.submit();" />
				<button onclick="this.form.submit();"><?php echo JText::_( 'Go' ); ?></button>
				<button onclick="document.getElementById('search').value='';this.form.submit();"><?php echo JText::_( 'Reset' ); ?></button>
			</td>
			
			<td nowrap="nowrap">
				<?php echo $lists['mcid']; 
				echo $lists['sectionid'];
				echo $lists['catid'];
				?>
			</td>
			
		</tr>
		</table>

			<table class="adminlist">
			<thead>
			
				<tr>
					<td colspan="8" width = 100%>
						<?php echo $pageNav->getListFooter(); ?>
					</td>
				</tr>
			
				<tr>
					<th width="5%">
						<?php echo JText::_( 'Num' ); ?>
					</th>
					<th width="5%">
						<input type="checkbox" name="toggle" value=""  onclick="checkAll(<?php echo count( $rows ); ?>);" />
					</th>
					
	
					<th width="8%" nowrap="nowrap" class="title">
						<?php echo JHTML::_('grid.sort',  'Sku', 'p.product_sku', @$lists['order_Dir'], @$lists['order'] ); ?>
					</th>
					<th  nowrap="nowrap">
						<?php echo JHTML::_('grid.sort',   'Content Title', 'p.product_name', @$lists['order_Dir'], @$lists['order'] ); ?>
					</th>
					<th class="title" width="10%" nowrap="nowrap">
						<?php echo JHTML::_('grid.sort',   'Section', 'section_name', @$lists['order_Dir'], @$lists['order'] ); ?>
					</th>
					<th  class="title" width="10%" nowrap="nowrap">
						<?php echo JHTML::_('grid.sort',   'Category', 'name', @$lists['order_Dir'], @$lists['order'] ); ?>
					</th>
					<th width="15%" nowrap="nowrap">
						<?php echo JHTML::_('grid.sort',   'Imported Date', 'p.importdate', @$lists['order_Dir'], @$lists['order'] ); ?>
					</th>
					
					 				
					
				</tr>
			</thead>
			
			<tbody>
			<?php
			$k = 0;
			for ($i=0, $n=count( $rows ); $i < $n; $i++) {
				$row = &$rows[$i];

				$row->id	= $row->product_id;
				$link		= JRoute::_( 'index.php?option=com_content&sectionid=-1&task=edit&cid[]='. $row->content_id );
				$row->published = $row->product_publish;
				$published		= $this->addcatalog( $row, $i );
				$checked		= JHTML::_('grid.checkedout',   $row, $i );

				?>
				<tr class="<?php echo "row$k"; ?>">
					<td align="center">
						<?php echo $pageNav->getRowOffset($i); ?>
					</td>
					<td align="center">
						<?php echo $checked; ?>
					</td>
					<?php if ($showimage) { ?>
					<td>
						<img src = "<?php echo $row->product_thumb_image; ?>"
					</td>
					<?php } ?>
					<td>
						<a href="<?php echo $link; ?>" title="<?php echo JText::_( 'Product SKU' ); ?>">
							<?php echo $row->product_sku; ?>
						</a>							
					</td>
					<td>
						<a href="<?php echo $link; ?>" title="<?php echo JText::_( 'Product name' ); ?>">
							<?php echo $row->product_name; ?>
						</a>							
					</td>
					<td>
 						<?php echo $row->section_name; ?>
					</td>
					<td>
							<?php echo $row->name; ?>
					</td>
					<td align = "center">
						<?php echo $row->importdate;?>
					</td>					
				
				</tr>
				<?php
				$k = 1 - $k;
			}
			?>
			</tbody>
			</table>

		<input type="hidden" name="c" value="ms_content" />
		<input type="hidden" name="option" value="com_cmsshopbuilder" />
		<input type="hidden" name="task" value="" />
		<input type="hidden" name="boxchecked" value="0" />		
		<input type="hidden" name="filter_order" value="<?php echo $lists['order']; ?>" />
		<input type="hidden" name="filter_order_Dir" value="" />

		</form>
		<?php
	}

	function setMs_contentToolbar()
	{
		$task = JRequest::getVar( 'task', '', 'method', 'string');

		JToolBarHelper::title( $task == 'add' ? JText::_( 'Item' ) . ': <small><small>[ '. JText::_( 'New' ) .' ]</small></small>' : JText::_( 'Item' ) . ': <small><small>[ '. JText::_( 'Edit' ) .' ]</small></small>', 'generic.png' );
		JToolBarHelper::save( 'save' );
		JToolBarHelper::apply('apply');
		JToolBarHelper::cancel( 'cancel' );
		
	}

	function ms_content( &$row, &$lists )
	{
		Ms_ContentsViewContent::setMs_contentToolbar();
		JRequest::setVar( 'hidemainmenu', 1 );
		jimport('joomla.filter.output');
		JFilterOutput::objectHTMLSafe( $row, ENT_QUOTES, 'product_desc' );
		?>
		<script language="javascript" type="text/javascript">
		
		
		function submitbutton(pressbutton) {
			var form = document.adminForm;
			if (pressbutton == 'cancel') {
				submitform( pressbutton );
				return;
			}
			// do field validation
			if (form.product_name.value == "") {
				alert( "<?php echo JText::_( 'You must provide a product name.', true ); ?>" );
			} else if (getSelectedValue('adminForm','mc_id') =='') {
				alert( "<?php echo JText::_( 'Please select a merchant.', true ); ?>" );
			} else if ( getSelectedValue('adminForm','cat_id') == '') {
				alert( "<?php echo JText::_( 'Please select a category.', true ); ?>" );
			} else {
				submitform( pressbutton );
				
			}
		}
		
		</script>
		<form action="index.php?option=com_cmsshopbuilder&c=ms_content" method="post" name="adminForm">

		<div class="col50">
			<fieldset class="adminform">
				<legend><?php echo JText::_( 'Product Details' ); ?></legend>

				<table class="admintable">
				<tbody>
					<tr>
						
						<td width="20%" class="key">
							<label for="name">
								<?php echo JText::_( 'Product SKU' ); ?>:
							</label>
						</td>
						<td width="80%">
							<input class="inputbox" type="text" name="product_sku" id="product_sku" size="60" value="<?php echo $row->product_sku;?>" />
						</td>
					</tr>   
					<tr>
						<td width="20%" class="key">
							<label for="name">
								<?php echo JText::_( 'Product Name' ); ?>:
							</label>
						</td>
						<td width="80%">
							<input class="inputbox" type="text" name="product_name" id="product_name" size="60" value="<?php echo $row->product_name;?>" />
						</td>
					</tr>
					 <tr>
						<td class="key">
							<label for="ordering">
								<?php echo JText::_( 'UPC' ); ?>:
							</label>
						</td>
						<td>
							<input class="inputbox" type="text" name="product_upc" id="product_upc" size="20" value="<?php echo $row->product_upc;?>" />
						</td>
					</tr>
					 <tr>
						<td class="key">
							<label for="ordering">
								<?php echo JText::_( 'ISBN' ); ?>:
							</label>
						</td>
						<td>
							<input class="inputbox" type="text" name="product_isbn" id="product_isbn" size="20" value="<?php echo $row->product_isbn;?>" />
						</td>
					</tr>
					<tr>
						<td width="20%" class="key">
							<label for="name">
								<?php echo JText::_( 'Alias' ); ?>:
							</label>
						</td>
						<td width="80%">
							<input class="inputbox" type="text" name="alias" id="alias" size="60" value="<?php echo $row->alias;?>" />
						</td>
					</tr>
					<tr>
						<td width="20%" class="key">
							<label for="name">
								<?php echo JText::_( 'Product Url' ); ?>:
							</label>
						</td>
						<td width="80%">
							<input class="inputbox" type="text" name="product_url" id="product_url" size="60" value="<?php echo $row->product_url;?>" />
						</td>
					</tr>
					<tr>
						<td class="key">
							<?php echo JText::_( 'Publish' ); ?>:
						</td>
						<td>
							<?php echo $lists['publish']; ?>
						</td>
					</tr>
					
				
					<tr>
						<td valign="top" align="right" class="key">
							<label for="catid">
								<?php echo JText::_( 'Category' ); ?>:
							</label>
						</td>
						<td>
							<select class="inputbox" id="cat_id" name="cat_id"  >
							<option value=""><?php echo 'Select Category'; ?></option>
							<?php   echo MsDatafeedController_ms_content::cat_tree($row->cat_id );   ?>
				            </select>
						</td>
					</tr>
					<tr>
						<td class="key">
							<?php echo JText::_( 'Merchant/Store' ); ?>:
						</td>
						<td>
							<?php echo $lists['mcid']; ?>
						</td>
					</tr>
					<tr>
						<td class="key">
							<label for="cid">
								<?php echo JText::_( 'Product Price' ); ?>:
							</label>
						</td>
						<td >
							
							<input class="inputbox" type="text" name="product_price" id="product_price" size="20" value="<?php echo $row->product_price;?>" />

						</td>
					</tr>
					<tr>
						<td class="key">
							<label for="cid">
								<?php echo JText::_( 'Price Currency' ); ?>:
							</label>
						</td>
						<td >
							<?php echo $lists['curid']; ?>
						</td>
					</tr>
					<tr >
						<td valign="top" align="right" class="key">
							<?php echo JText::_( 'Hits' ); ?>
						</td>
						<td colspan="2">
							<?php echo $row->hits;?>
							&nbsp;&nbsp;&nbsp;&nbsp;
							<input name="reset_hits" type="button" class="button" value="<?php echo JText::_( 'Reset hits' ); ?>" onclick="submitbutton('resethits');" />
						</td>
					</tr>
					<tr>
						<td valign="top" class="key">
							<label for="Description">
								<?php echo JText::_( 'Product Description' ); ?>:
							</label>
						</td>
						<td>
							<textarea class="inputbox" cols="43" rows="8" name="product_desc" id="product_desc"><?php echo $row->product_desc;?></textarea>
						</td>
					</tr>
					
					<tr>
						<td valign="top" class="key">
							<label for="tags">
								<?php echo JText::_( 'Tags' ); ?>:
							</label>
						</td>
						<td>
							<textarea class="inputbox" cols="43" rows="3" name="tags" id="tags"><?php echo $row->tags;?></textarea>
						</td>
					</tr>
				</tbody>
				</table>
			</fieldset>
		</div>		   
		
		<div class="col50">
			<fieldset class="adminform">
				<legend><?php echo JText::_( 'Product Images' ); ?></legend>
				<table class="admintable">
					 <tr>
						<td valign="top" class="key">
							<?php echo JText::_( 'Small Image url' ); ?>:
						</td>
						<td valign="top">
							<input class="inputbox" type="text" name="product_thumb_image" id="product_thumb_image" size="60" value="<?php echo $row->product_thumb_image;?>" /><br/><br/>
							<img src="<? echo $row->product_thumb_image ?> " name="Small Image">
						</td>
					</tr>
					<tr>
						<td valign="top" class="key">
							<?php echo JText::_( 'Full image url' ); ?>:
						</td>
						<td valign="top">
							<input class="inputbox" type="text" name="product_full_image" id="product_full_image" size="60" value="<?php echo $row->product_full_image;?>" /><br/><br/>
							<img src="<? echo $row->product_full_image ?> " name="Small Image">
						</td>
					</tr>
				</table>
			</fieldset>
		</div>		
		<div class="clr"></div>

		<input type="hidden" name="c" value="ms_content" />
		<input type="hidden" name="option" value="com_cmsshopbuilder" />
		<input type="hidden" name="product_id" value="<?php echo $row->product_id; ?>" />
		<input type="hidden" name="task" value="" />

		</form>
		<?php
	}
	//move product
	function setMs_contentmoveToolbar()
	{
		$task = JRequest::getVar( 'task', '', 'method', 'string');
		JToolBarHelper::title( JText::_( 'Move Product' ) , 'generic.png' );
		JToolBarHelper::save( 'savemoveproduct' );
		JToolBarHelper::cancel( 'cancel' );
		
	}

	function moveproduct( $rows )
	{
		Ms_contentsViewContent::setMs_contentmoveToolbar();
		JRequest::setVar( 'hidemainmenu', 1 );
		
		?>
		<script language="javascript" type="text/javascript">
		
		
		function submitbutton(pressbutton) {
			var form = document.adminForm;
			if (pressbutton == 'cancel') {
				submitform( pressbutton );
				return;
			}else {
				  submitform( pressbutton );
				
			}
		}
		
		</script>
		
		<form action="index.php?option=com_cmsshopbuilder&c=ms_content" method="post" name="adminForm">
		<div class="col50">
			<fieldset class="adminform">
				<legend><?php echo JText::_( 'Products  being moved' ); ?></legend>
				<table class="adminlist">
					<tr>
						<th width="20">
							<?php echo JText::_( 'Num' ); ?>
						</th>
						<th width="80%" nowrap="nowrap" class="title">
							<?php echo JText::_( 'Product Name' ); ?>
						</th>
						
					</tr>
					<tbody>
					<?php
					
					$k = 0;
					for ($i=0, $n=count( $rows ); $i < $n; $i++) {
					
						$row = $rows[$i];
						
						?>
						<tr class="<?php echo "row$k"; ?>">
							<td align="left">
								<?php echo $i+1; ?>
							</td>
							
							<td align="left">
								<?php echo $row->product_name; ?>
							</td>
						</tr>	
					
						<?php
						$k = 1 - $k;
						$id = $row->product_id ; 
						echo "\n <input type=\"hidden\" name=\"cid[]\" value=\"$id\" />";
						
					}
					?>
					</tbody>
				</table>
			</fieldset>
		</div>		
		<div class="col50">
			<fieldset class="adminform">
				<legend><?php echo JText::_( 'Move to category  ' ); ?></legend>

				<table class="admintable">
				<tbody>
					<tr>
						
						<td>
							<select class="inputbox" id="cat_id" name="cat_id"  >
							<option value=""><?php echo 'Select Category'; ?></option>
							<?php   echo MsDatafeedController_ms_content::cat_tree($row->cat_id );   ?>
				            </select>
						</td>
					</tr>
					
				</tbody>
				</table>
			</fieldset>
		</div>		 
		<div class="clr"></div>

		<input type="hidden" name="c" value="ms_content" />
		<input type="hidden" name="option" value="com_cmsshopbuilder" />
		<input type="hidden" name="task" value="" />
		
		</form>
		<?php
	}
}