<?php
/**
 * @version Id: ms_currency.php version 1.0 2007-09-01 
 * @package CMS Shop Builder for joomla
 * @copyright Copyright (C) 2005 - 2008 Wasan Ongart. All rights reserved.
 */



// no direct access
defined( '_JEXEC' ) or die( 'Restricted access' );

/**
* @package		Ms Datafeed manager for joomla
 * @subpackage	Currency
*/
class Ms_currencyViewMs_currency
{
	function setMs_currencysToolbar()
	{
		JToolBarHelper::title( JText::_( 'Currency Manager' ), 'generic.png' );
		JToolBarHelper::makeDefault( 'setdefault' );
		JToolBarHelper::deleteList();
		JToolBarHelper::editListX();
		JToolBarHelper::addNewX();
		JToolBarHelper::customX( 'close', 'cancel.png', 'cancel_f2.png', 'Close',false );

		//JToolBarHelper::preferences('com_cmsshopbuilder', '500');
	}

	function ms_currencys( &$rows, &$pageNav, &$lists )
	{
		Ms_currencyViewMs_currency::setMs_currencysToolbar();
		$user =& JFactory::getUser();
		JHTML::_('behavior.tooltip');
		?>
		<form action="index.php?option=com_cmsshopbuilder&c=ms_currency" method="post" name="adminForm">
		<table>
		<tr>
			<td align="left" width="100%">
				<?php echo JText::_( 'Filter' ); ?>:
				<input type="text" name="search" id="search" value="<?php echo $lists['search'];?>" class="text_area" onchange="document.adminForm.submit();" />
				<button onclick="this.form.submit();"><?php echo JText::_( 'Go' ); ?></button>
				<button onclick="document.getElementById('search').value='';this.form.submit();"><?php echo JText::_( 'Reset' ); ?></button>
			</td>
			
		</tr>
		</table>

			<table class="adminlist">
			<thead>
				 <tr>
					<td colspan="13">
						<?php echo $pageNav->getListFooter(); ?>
					</td>
				</tr>
				<tr>
					<th width="5%">
						<?php echo JText::_( 'Num' ); ?>
					</th>
					
					<th width="5%">
						<input type="checkbox" name="toggle" value=""  onclick="checkAll(<?php echo count( $rows ); ?>);" />
					</th>
					<th width="5%">
						<?php echo JText::_( 'Default' ); ?>
					</th>
					<th nowrap="nowrap" class="title">
						<?php echo JHTML::_('grid.sort',  'Currency Name', 'c.currency_name', @$lists['order_Dir'], @$lists['order'] ); ?>
					</th>
					
					<th width="10%" nowrap="nowrap">
						<?php echo JHTML::_('grid.sort',   'Sign', 'c.currency_code', @$lists['order_Dir'], @$lists['order'] ); ?>
					</th>
					
				</tr>
			</thead>
			<tfoot>
				<tr>
				</tr>
			</tfoot>
			<tbody>
			<?php
			$k = 0;
			for ($i=0, $n=count( $rows ); $i < $n; $i++) {
				$row = &$rows[$i];

				$row->id	= $row->currency_id;
				$link		= JRoute::_( 'index.php?option=com_cmsshopbuilder&c=ms_currency&task=edit&cid[]='. $row->currency_id );
				$checked		= JHTML::_('grid.checkedout',   $row, $i );

		
				?>
				<tr class="<?php echo "row$k"; ?>">
					<td align="center">
						<?php echo $pageNav->getRowOffset($i); ?>
					</td>
					<td align="center">
						<?php echo $checked; ?>
					</td>
					<td align="center">
						<?php if ( $row->homecur == 1 ) : ?>
						<img src="templates/khepri/images/menu/icon-16-default.png" alt="<?php echo JText::_( 'Default' ); ?>" />
						<?php else : ?>
						&nbsp;
						<?php endif; ?>
					</td>
					<td>
						<a href="<?php echo $link; ?>" title="<?php echo JText::_( 'Currency' ) . ': <small><small>[ '. JText::_( 'Edit' ) .' ]</small></small>'; ?>">
						<?php echo $row->currency_name; ?></a>
					
					</td>
					
					<td>
						<?php echo $row->currency_code;?>
					</td>
					
				
				</tr>
				<?php
				$k = 1 - $k;
			}
			?>
			</tbody>
			</table>

		<input type="hidden" name="c" value="ms_currency" />
		<input type="hidden" name="option" value="com_cmsshopbuilder" />
		<input type="hidden" name="task" value="" />
		<input type="hidden" name="boxchecked" value="0" />
		<input type="hidden" name="filter_order" value="<?php echo $lists['order']; ?>" />
		<input type="hidden" name="filter_order_Dir" value="" />
		</form>
		<?php
	}

	function setMs_currencyToolbar()
	{
		$task = JRequest::getVar( 'task', '', 'method', 'string');

		JToolBarHelper::title( $task == 'add' ? JText::_( 'Currency' ) . ': <small><small>[ '. JText::_( 'New' ) .' ]</small></small>' : JText::_( 'Currency' ) . ': <small><small>[ '. JText::_( 'Edit' ) .' ]</small></small>', 'generic.png' );
		JToolBarHelper::save( 'save' );
		JToolBarHelper::cancel( 'cancel' );
	}

	function ms_currency( &$row, &$lists )
	{
		Ms_currencyViewMs_currency::setMs_currencyToolbar();
		JRequest::setVar( 'hidemainmenu', 1 );
		jimport('joomla.filter.output');
		
		?>
		<script language="javascript" type="text/javascript">
		<!--
		function submitbutton(pressbutton) {
			var form = document.adminForm;
			if (pressbutton == 'cancel') {
				submitform( pressbutton );
				return;
			}
			// do field validation
			if (form.currency_name.value == "") {
				alert( "<?php echo JText::_( 'You must provide a Currency name.', true ); ?>" );
			} else if (form.currency_code.value == "" ) {
				alert( "<?php echo JText::_( 'Please Enter Currency Sign.', true ); ?>" );
			} else {
				submitform( pressbutton );
			}
		}
		//-->
		</script>
		<form action="index.php" method="post" name="adminForm">

		<div class="col100">
			<fieldset class="adminform">
				<legend><?php echo JText::_( 'Details' ); ?></legend>

				<table class="admintable">
				<tbody>
					<tr>
						<td width="20%" class="key">
							<label for="name">
								<?php echo JText::_( 'Currency Name' ); ?>:
							</label>
						</td>
						<td width="80%">
						    <?php if ($row->currency_id) { ?>
							  	<input class="inputbox" type="text" name="currency_name" id="currency_name" size="50" value="<?php echo $row->currency_name;?>"  READONLY />
							<?php }else{ ?>	
							<input class="inputbox" type="text" name="currency_name" id="currency_name" size="50" value="<?php echo $row->currency_name;?>" />
							<?php }?>
						</td>
					</tr>
					<tr>
						<td width="20%" class="key">
							<label for="name">
								<?php echo JText::_( 'Currency Sign' ); ?>:
							</label>
						</td>
						<td width="80%">
							<input class="inputbox" type="text" name="currency_code" id="currency_code" size="50" value="<?php echo $row->currency_code;?>" />
						</td>
					</tr>
					
				</tbody>
				</table>
			</fieldset>
		</div>
		<div class="clr"></div>

		<input type="hidden" name="c" value="ms_currency" />
		<input type="hidden" name="option" value="com_cmsshopbuilder" />
		<input type="hidden" name="currency_id" value="<?php echo $row->currency_id; ?>" />
		<input type="hidden" name="task" value="" />

		</form>
		<?php
	}
}