<?php

/**
*
* @package Gigabyte WebSolutions - Easy Installer
* @copyright: 2008 Aroms Emmanuel Aigbehi;
* email: Info@Joomlatag.com
* host: www.joomlatag.com
* development:  Andrey Kvasnevskiy-OrdaSoft; 
* Homepage: 
* @version: 1.0 $
*
**/

function print_vars1($obj) {
	$arr = get_object_vars($obj);
	while (list($prop, $val) = each($arr))
	if(class_exists($val)) print_vars($val);
	else echo "\t $prop = $val\n<br />";
}

function print_methods1($obj) {
	$arr = get_class_methods(get_class($obj));
	foreach ($arr as $method)	echo "\tfunction $method()\n <br />";
}

class mosEasyInstallerImportExport{

	/**
	 * Imports the lines given to this method into the database and writes a
	 * table containing the information of the imported application list.
	 * The imported application list will be set to [not published]
	 */

	function getXMLItemValue($item,$item_name) {
		$app_items = $item->getElementsByTagname($item_name);
		$app_item = $app_items->item(0);
		if(NULL != $app_item) return $app_item->nodeValue ;
		else return "";
	}

	//******************	begin add for import XML format	***********************

	function correct_relate_ids(& $new_relate_ids)
	{
		global $database;

		$selectstring = "SELECT a.id FROM #__easy_installer AS a ";
		$database->setQuery($selectstring);
		$bids = $database->loadObjectList();

		if ($database->getErrorNum()) {
			echo $database->stderr();
			return;
		}

		foreach($bids as $bid){
			$addon = new mosEasyInstaller($database);
			// load the row from the db table
			$addon->load(intval($bid->id));
			if($addon->app_relate_id != 0 )
			foreach( $new_relate_ids as $item ){
				if($addon->app_relate_id == $item->old_id ){
					$addon->app_relate_id = $item->new_id;
					break;
				}
			}
			$addon->store();
		}
	}

	function importXML($files_name_pars, $limit = 0)
	{
		global $database;
		$retVal= array();
		$new_relate_ids = array();
		$dom = new domDocument('1.0','utf-8');
		$dom->load($files_name_pars);
		$app_list = $dom->getElementsByTagname('app_data');

		if(!$limit || $limit >$app_list->length)
		$ch_limit = $app_list->length;
		else
		$ch_limit = $limit;
		for ($i = 0; $i < $ch_limit; $i++) {
			$easy_installer_class = new mosEasyInstaller($database);
			$app_item = $app_list->item($i);
			//get app_name
			$easy_installer_class->app_name = mosEasyInstallerImportExport::getXMLItemValue($app_item,'app_name');
			//get app_real_name
			$easy_installer_class->app_real_name = mosEasyInstallerImportExport::getXMLItemValue($app_item,'app_real_name');
			//get app_image_path
			$easy_installer_class->app_image_path =  mosEasyInstallerImportExport::getXMLItemValue($app_item,'app_image_path');
			//get app_descr
			$easy_installer_class->app_descr = preg_replace("/<img.*>/", "",
			mosEasyInstallerImportExport::getXMLItemValue($app_item,'app_descr') );
			//get app_descr_url
			$easy_installer_class->app_descr_url =  mosEasyInstallerImportExport::getXMLItemValue($app_item,'app_descr_url');
			//get app_url
			$easy_installer_class->app_url = mosEasyInstallerImportExport::getXMLItemValue($app_item,'app_url');
			//get app_version
			$easy_installer_class->app_version = mosEasyInstallerImportExport::getXMLItemValue($app_item,'app_version');
			//get app_version_installed
			$easy_installer_class->app_version_installed = mosEasyInstallerImportExport::getXMLItemValue($app_item,'app_version_installed');
			//get app_authors
			$easy_installer_class->app_authors = mosEasyInstallerImportExport::getXMLItemValue($app_item,'app_authors');
			//get app_authors_url
			$easy_installer_class->app_authors_url = mosEasyInstallerImportExport::getXMLItemValue($app_item,'app_authors_url');
			//get app_authors_email
			$easy_installer_class->app_authors_email = mosEasyInstallerImportExport::getXMLItemValue($app_item,'app_authors_email');
			//get app_type
			$easy_installer_class->app_type = mosEasyInstallerImportExport::getXMLItemValue($app_item,'app_type');
			//get app_real_type
			$easy_installer_class->app_real_type = mosEasyInstallerImportExport::getXMLItemValue($app_item,'app_real_type');
			//get app_release_date
			$easy_installer_class->app_release_date = mosEasyInstallerImportExport::getXMLItemValue($app_item,'app_release_date');
			//get app_recommended
			$easy_installer_class->app_recommended = mosEasyInstallerImportExport::getXMLItemValue($app_item,'app_recommended');
			//get app_not_commercial
			$easy_installer_class->app_not_commercial = mosEasyInstallerImportExport::getXMLItemValue($app_item,'app_not_commercial');
			//get app_relate_id
			$easy_installer_class->app_relate_id = mosEasyInstallerImportExport::getXMLItemValue($app_item,'app_relate_id');
			//get category
			$easy_installer_class->category = mosEasyInstallerImportExport::getXMLItemValue($app_item,'category');
			//for output rezult in table
			$tmp[0] = $i;
			$tmp[1] = $easy_installer_class -> app_name;
			$tmp[2] = $easy_installer_class -> app_type;
			$tmp[3] = $easy_installer_class -> category;
			$tmp[4] = $easy_installer_class -> app_version;
			$tmp[5] = $easy_installer_class -> app_authors_url;
			if (!$easy_installer_class->check() || !$easy_installer_class->store()) {
				$tmp[6] =  $easy_installer_class->getError();
			} else { $tmp[6] =  "OK"; }
			$new_relate = null;
			$new_relate->old_id = mosEasyInstallerImportExport::getXMLItemValue($app_item,'id');
			$new_relate->new_id = $easy_installer_class->id;
			$new_relate_ids[] = $new_relate ;
			$retVal[$i] = $tmp;
		}//end for(...) - app_list
		mosEasyInstallerImportExport::correct_relate_ids($new_relate_ids);
		return $retVal;
	}

	//**************	end add for import XML format	****************************

	function exportAppListToXML($app_list){
		global $mosConfig_live_site, $mosConfig_absolute_path;

		$xmlDoc =& new DOMIT_Document();
		$xmlDoc->appendChild($xmlDoc->createProcessingInstruction('xml', "version=\"1.0\" encoding=\"utf-8\""));

		//append doctype info; just pass in doctype name and text
		/*$doctypeText = "<!DOCTYPE sr:staterotation [\n\t" .
					"<!ELEMENT sr:staterotation	(sr:rotation+)>\n\t" .
					  "<!ELEMENT sr:rotation		  (sr:state, sr:banner)>\n\t" .
					  "<!ELEMENT sr:state			  (#PCDATA)>\n\t" .
					  "<!ELEMENT sr:banner			 (#PCDATA)>\n" .
					"]>)";
		$doctype =& new DOMIT_DocumentType('sr:staterotation', $doctypeText);
		$xmldoc->appendChild($doctype);*/

		//create and append list element
		$xmlDoc->appendChild($xmlDoc->createElement("app_list"));

		foreach ($app_list as $app_item) {
			$xmlDoc->documentElement->appendChild($app_item->toXML( $xmlDoc));
		}

		return $xmlDoc->toNormalizedString ();
	}

	function storeExportFile($data, $type){
		global $mosConfig_live_site, $mosConfig_absolute_path;
		$fileName = "easyinstaller_" . date("Ymd_His");
		$fileBase = "/administrator/components/com_easyinstaller/exports/";
		//echo 'PRINT : '.$mosConfig_absolute_path;exit;
		//write the xml file
		$fp = fopen($mosConfig_absolute_path . $fileBase . $fileName . ".xml" , "w", 0); #open for writing

		fwrite($fp, $data); #write all of $data to our opened file
		fclose($fp); #close the file

		$InformationArray = array();
		$InformationArray['xml_file'] = $fileName . '.xml';
		$InformationArray['fileBase'] = "file://" . getcwd (). "/components/com_easyinstaller/exports/";
		$InformationArray['urlBase'] = $mosConfig_live_site . $fileBase;
		$InformationArray['out_file'] = $InformationArray['xml_file'];

		return $InformationArray;
	}
}
?>