<?php
defined( '_JEXEC' ) or die( 'Restricted access' );

	JToolBarHelper::title( JText::_( 'Categories' ), 'ninjahdr' );
	JToolBarHelper::publishList();
	JToolBarHelper::unpublishList();
	JToolBarHelper::editList();
	JToolBarHelper::deleteList(JText::_('Are you sure you want to delete these categories?'));
	JToolBarHelper::addNew();
	
	//Include our stylesheet for our Ninja Component Styling
		$document = JFactory::getDocument();
		$document->addStyleSheet(JURI::root().'/media/com_ninjamonials/css/admin.css', 'text/css', null, array());
	
		//add ie6 css if needed
		$ua = $_SERVER['HTTP_USER_AGENT'];
		if (preg_match('/MSIE/',  $ua) && preg_match( '/6/',  $ua)) {		
			$document->addStyleSheet(JURI::root().'/media/com_ninjamonials/css/admin_ie6.css', 'text/css', null, array());		  
		}

//If categories aren't enabled ddisplay a message
	if(!$this->enable_categories){ ?>
    <center><h1><?php echo JText::_('Categories are currently disabled.'); ?></h1></center>
    <center><h2><?php echo JText::_('If you wish to enable them, please select the enable categories option in the settings screen.'); ?></h2></center>
    <?php
	} else {
  //Do the normal page display if categories are enabled
	?>

<form action="index.php" method="post" name="adminForm">
<table>
	<tr>
		<td align="left">
		<?php echo JText::_('Search'); ?>: 
		<input type="text" name="search" value="<?php echo $this->search ?>" id="search" />
		<button type="submit"><?php echo JText::_('Go'); ?></button>
		</td>
	</tr>
</table>
<table class="adminlist">
  <thead>
    <tr>
      <th width="20">
        <input type="checkbox" name="toggle" 
             value="" onclick="checkAll(<?php echo 
             count( $this->rows ); ?>);" />
      </th>
      <th width="15%" class="title"><?php echo JText::_('Category'); ?></th>
      <th><?php echo JText::_('Description'); ?></th>
      <th width="5%" nowrap="nowrap"><?php echo JText::_('Published'); ?></th>
    </tr>
  </thead>

  <?php
  jimport('joomla.filter.output');
  $k = 0;

  for ($i=0, $n=count( $this->rows ); $i < $n; $i++) 
  {
      $row = &$this->rows[$i];
      $checked = JHTML::_('grid.id', $i, $row->id );
      $published = JHTML::_('grid.published', $row, $i );
      
      $link = JFilterOutput::ampReplace( 'index.php?option=' . $option . '&controller=categories&task=edit&cid[]='. $row->id );
      
      //If we have some text in the testimonial field, clean up any newline characters 
      //that got escaped for security when we saved the data
        //get rid of pesky php notices.		

      	if (isset($row->testimonial)){			
      		$inBRs = array ('<br />','<br/>','<br>','\r', '\n');
      		$outBRs = array ('','','','',"\n");
      		$row->testimonial = str_replace ($inBRs,$outBRs, $row->testimonial);
      	}
      	
          ?>
          <tr class="<?php echo "row$k"; ?>">
            <td>
              <?php echo $checked; ?>
            </td>
            <td>
            	<?php if(JRequest::getVar('object')):?>
              <a style="cursor:pointer" onclick="window.parent.jSelectArticle('<?php echo $row->id?>', '<?php echo $row->name; ?>', '<?php echo JRequest::getCmd('object')?>');"><?php echo $row->name; ?></a>
              <?php else:?>
              <a href="<?php echo $link; ?>"><?php echo $row->name; ?></a>
              <?php endif;?>
            </td>
            <td>
              <?php echo $row->description; ?>
            </td>
            <td align="center">
              <?php echo $published;?>
            </td>
          </tr>
          <?php
          $k = 1 - $k;
  }
  ?>
 <tfoot>
	<tr>
		<td colspan="5"><?php echo $this->pagination->getListFooter(); ?></td>
	</tr>
</tfoot>
 
</table>
<?php echo JHTML::_( 'form.token' ); ?>
<input type="hidden" name="option" value="<?php echo $option;?>" />
<input type="hidden" name="controller" value="categories" />
<input type="hidden" name="task" value="" />
<input type="hidden" name="boxchecked" value="0" />
</form>

<?php
	}//end our categories enabled check
	
	//include our helper file to create the footer
	require_once(JPATH_COMPONENT_ADMINISTRATOR.DS.'helpers'.DS.'HTML_ninjahelper_admin.php');
	
	HTML_ninjahelper_admin::showfooter(JText::_('Component Real Name'),JText::_('Component Footer Buttons'));

?>
