<?php
defined( '_JEXEC' ) or die( 'Restricted access' );

jimport('joomla.application.component.controller');

class NJSiteStylerControllerFiles extends JController
{
		
	function display ()
	{
		
		$view = JRequest::getVar('view');
		
		JRequest::setVar('view', 'files');
		
		parent::display();
	}
	
	function remove ()
	{
		
		global $option;
		
		JRequest::checkToken() or jexit( 'Invalid Token' );
		
	//our sifr fonts directory
		$uploadsDirectory = JPATH_COMPONENT_ADMINISTRATOR.DS.'uploads';
		
	//get the names of the files to be deleted
		$cid = JRequest::getVar( 'cid', array(0), '', 'array' );
		
	//loop through our file list
		for ($i=0, $n=count($cid); $i < $n; $i++) 
		{
		
			if (!unlink($uploadsDirectory.DS.basename($cid[$i])))
				$this->setRedirect('index.php?option=' . $option .'&task=display&controller=files', JText::_('Error deleting file').': '.$cid[$i].'. '.JText::_('Operation aborted'));	
		
		}
		
		$this->setRedirect('index.php?option=' . $option .'&task=display&controller=files', JText::_('Files Deleted'));
	}
	
	function saveuploadedfiles() 
	{
		
	//check the form token
		JRequest::checkToken() or jexit( 'Invalid Token' );
		
		global $option;
		
	// first let's set some variables		
	// make a note of the directory that will recieve the uploaded file
		$uploadsDirectory = JPATH_COMPONENT_ADMINISTRATOR.DS.'uploads';
		
	// fieldname used within the file <input> of the HTML form
		$fieldname = 'file';
		
	// Now let's deal with the upload
		
	// check the upload form was actually submitted else print the form
		if (!isset($_POST['submit'])){
		    $this->setRedirect('index.php?option=' . $option .'&task=display&controller=files', JText::_('Please Submit Form'));
		    $this->redirect();
		}
	// possible PHP upload errors
		$errors = array(1 => JText::_('php ini max file size exceeded'),
		                2 => JText::_('html form max file size exceeded'),
		                3 => JText::_('File upload was only partial'),
		                4 => JText::_('No file was attached')); 
		
	// check for PHP's built-in uploading errors
		if (!($_FILES[$fieldname]['error'] == 0)){
		    $this->setRedirect('index.php?option=' . $option .'&task=display&controller=files', $errors[$_FILES[$fieldname]['error']]);
		    $this->redirect();
		}
		
	// check that the file we are working on really was the subject of an HTTP upload
		$tmp_file_path = $_FILES[$fieldname]['tmp_name'];
		if (!(@is_uploaded_file($tmp_file_path))){
		    $this->setRedirect('index.php?option=' . $option .'&task=display&controller=files', JText::_('Not an HTTP upload'));
		    $this->redirect();
		}
		
	// Do some filename cleaning.
	//first get our helper file with some functions in it
		require_once(JPATH_COMPONENT_ADMINISTRATOR.DS.'helpers'.DS.'file_helpers.php');
        $tmp_file_name = cleanFileName( $_FILES[$fieldname]['name'] );
            
	// validation... since we only need sifr font files, flir font files, JavaScript, PHP or CSS files
	// we should run a check to prevent other files being uploaded
		$extArray = array ('.swf', '.js', '.css', '.php', '.ttf');
				  
		$file_ext      = substr($tmp_file_name, strripos($tmp_file_name, '.'));	
	
	//compare our file's extension with our array of allowed extensions
		if (!in_array($file_ext, $extArray )){
			$this->setRedirect('index.php?option=' . $option .'&task=display&controller=files', JText::_('Only swf js css php and ttf files are allowed'));
		    $this->redirect();
		}
		
	//check that we don't already have a file with the same name
		if (file_exists($uploadsDirectory.DS.$tmp_file_name)){
			$this->setRedirect('index.php?option=' . $option .'&task=display&controller=files', JText::_('File').' '.$tmp_file_name.' '.JText::_('already exists'));
		    $this->redirect();
		}
		
	//is the dir writable??
		if ( !is_writable( $uploadsDirectory ) ) {
			$this->setRedirect('index.php?option=' . $option .'&task=display&controller=files', JText::_('Upload permission error Please check the permissions on the uploads directory'));
		    $this->redirect();
		}
        		
	// now let's move the file to its final location and allocate the new filename to it
		$target_path = $uploadsDirectory.DS.basename($tmp_file_name); 

		if(move_uploaded_file($_FILES[$fieldname]['tmp_name'], $target_path)) {
		    $this->setRedirect('index.php?option=' . $option .'&task=display&controller=files', JText::_('File').' '.$tmp_file_name.' '.JText::_('has been uploaded successfully'));
		} else{
		    $this->setRedirect('index.php?option=' . $option .'&&task=display&controller=files', JText::_('There was an error uploading the file').' '.$tmp_file_name.JText::_('please try again'));
		}		
		    
	}	
}


?>
