<?php
/**
 * RokCandy Macros RokCandy Macro Table
 *
 * @package		Joomla
 * @subpackage	RokCandy Macros
 * @copyright Copyright (C) 2009 RocketTheme. All rights reserved.
 * @license http://www.gnu.org/copyleft/gpl.html GNU/GPL, see LICENSE.php
 * @author RocketTheme, LLC
 */
// no direct access
defined('_JEXEC') or die('Restricted access');
jimport('joomla.filesystem.folder');
jimport('joomla.filesystem.file');
jimport('joomla.filesystem.path');

if (!class_exists("Thumbnail")){
	require_once(JPath::clean(JPATH_ADMINISTRATOR.'/components/com_rokquickcart/libs/thumbnail.inc.php'));
}

/**
* Weblink Table class
*
* @package		Joomla
* @subpackage	Weblinks
* @since 1.0
*/
class TableCartItem extends JTable
{
	/**
	 * Primary Key
	 *
	 * @var int
	 */
	var $id = 0;
	
	/**
	 * @var text
	 */
	var $name = null;

    /**
	 * @var text
	 */
	var $description = null;
	
	var $image = null;

	/**
   	 * @var float
   	 */
   	var $price = 0;
   	
   	var $shipping = 0;

	/**
	 * @var int
	 */
	var $published = 0;

	/**
	 * @var boolean
	 */
	var $checked_out = 0;

	/**
	 * @var time
	 */
	var $checked_out_time = 0;

	/**
	 * @var int
	 */
	var $ordering = 0;
	
	var $params = null;

	var $_component_params = null;
	/**
	 * Constructor
	 *
	 * @param object Database connector object
	 * @since 1.0
	 */
	function __construct(& $db) {
		global $option;
		parent::__construct('#__rokquickcart', 'id', $db);
		$this->_component_params = &JComponentHelper::getParams($option);
	}


	function _setComponentParams(&$component_params){
		$this->_component_params = $component_params;
	}
	
	/**
	* Overloaded bind function
	*
	* @acces public
	* @param array $hash named array
	* @return null|string	null is operation was satisfactory, otherwise returns an error
	* @see JTable:bind
	* @since 1.5
	*/
	function bind($array, $ignore = '')
	{
		if (key_exists( 'params', $array ) && is_array( $array['params'] ))
		{
			$registry = new JRegistry();
			$registry->loadArray($array['params']);
			$array['params'] = $registry->toString();
		}
		
		return parent::bind($array, $ignore);
	}

	/**
	 * Overloaded check method to ensure data integrity
	 *
	 * @access public
	 * @return boolean True on success
	 * @since 1.0
	 */
	function check()
	{
		/** check for valid name */
		if (trim($this->name) == '') {
			$this->setError(JText::_('ROKQUICKCART.ERR.NAME_MISSING'));
			return false;
		}
		
		/** check for valid name */
		if (trim($this->price) == '' || !is_float((float)trim($this->price))) {
			$this->setError(JText::_('ROKQUICKCART.ERR.VALID_PRICE'));
			return false;
		}

		return true;
	}
	
	function getShelfImage(){
		if (empty($this->image)) {
			return '';
		}
		$config =& JFactory::getConfig();
		$full_image_file = JPath::clean(JPATH_ROOT.'/'.$this->image);
		$image_file = JPath::clean(JPATH_CACHE.'/rokquickcart/shelf/'.$this->image);
		$image_url = JURI::root(false).'cache/rokquickcart/shelf/'.$this->image;
		$image_width = (int)$this->_component_params->get('shelf_image_width');
		if (!$this->_createThumbImage($full_image_file, $image_file, $image_width)) {
			return '';
		} 
		return $image_url;
	}
	
	function getCartImage(){
		if (empty($this->image)) {
			return '';
		}
		$config =& JFactory::getConfig();
		$full_image_file = JPath::clean(JPATH_ROOT.'/'.$this->image);
		$image_file = JPath::clean(JPATH_CACHE.'/rokquickcart/cart/'.$this->image);
		$image_url = JURI::root(false).'cache/rokquickcart/cart/'.$this->image;
		$image_width = (int)$this->_component_params->get('cart_image_width');
		if (!$this->_createThumbImage($full_image_file, $image_file, $image_width)) {
			return '';
		} 
		return $image_url;
	}
	
	function getFullImage() {
		return $this->image;
	}
	
	function _createThumbImage($full_image_path, $thumb_image_path, $image_width) {
		
		if (!JFile::exists($full_image_path)){
			return false;
		}
		if (!JFolder::exists(dirname($thumb_image_path))){
			JFolder::create(dirname($thumb_image_path));
		}
		$current_size = 0;
		
		if (file_exists($thumb_image_path)) {
		    $existing_thumb = new Thumbnail($thumb_image_path);
		    $current_size = $existing_thumb->getCurrentWidth();
		    $existing_thumb->destruct();
		}
				
		// create a new shelf image if the it doesnt exists, is older the full image, of if the image size has changed
		if (!JFile::exists($thumb_image_path) || (filemtime($full_image_path) > filemtime($thumb_image_path)) || $current_size != $image_width){
			$thumb = new Thumbnail($full_image_path);
		
			if ($thumb->error) { 
				echo "ERROR: " . $thumb->errmsg . ": " . $full_image_path; 
				return false;
			}
			$thumb->resize($image_width);
			if (!is_writable(dirname($thumb_image_path))) {
				$thumb->destruct();
				return false;
			}
			$thumb->save($thumb_image_path);
			$thumb->destruct();
		}
		return true;
	}
}
