<?php
/**
 * @version		2.0.9 alpharegistration $
 * @package		alpharegistration
 * @copyright	Copyright  2009 - Bernard Gilly - All rights reserved.
 * @license		GNU/GPL
 * @author		Bernard Gilly
 * @author mail	contact@alphaplug.com
 * @website		www.alphaplug.com
 */

// Check to ensure this file is included in Joomla!
defined( '_JEXEC' ) or die( 'Restricted access' );

jimport( 'joomla.application.component.view');

/**
 * HTML View class for the AlphaRegistration component
 *
 */
class AlpharegistrationViewRegister extends JView
{
	function display($tpl = null)
	{
		global $mainframe;

		$pathway  = &$mainframe->getPathway();		
		$document = &JFactory::getDocument();				
		$lang     = $document->getLanguage();	
		$params	  = &$mainframe->getParams();		
		$user     = &JFactory::getUser();

	 	// Page Title
		$menus	= &JSite::getMenu();
		$menu	= $menus->getActive();

		// because the application sets a default page title, we need to get it
		// right from the menu item itself
		if (is_object( $menu )) {
			$menu_params = new JParameter( $menu->params );
			if (!$menu_params->get( 'page_title')) {
				$params->set('page_title',	JText::_( 'Registration' ));
			}
		} else {
			$params->set('page_title',	JText::_( 'Registration' ));
		}
		$document->setTitle( $params->get( 'page_title' ) );

		$pathway->addItem( JText::_( 'New' ));		
		
		$arg_params = &JComponentHelper::getParams( 'com_alpharegistration' );
		
		$document->addStyleSheet(JURI::base(true).'/components/com_alpharegistration/assets/css/registration_css.css');
		
		// Prevent loading Mootools Library after AlphaRegistration jQuery (conflict)
		JHTML::_('behavior.mootools');
		
		if  ($arg_params->def('load_jQueryValidation', 1) ) {
			$document->addScript(JURI::base(true).'/components/com_alpharegistration/assets/scripts/jquery-1.3.2.min.js');			
			$document->addScript(JURI::base(true).'/components/com_alpharegistration/assets/scripts/ajax-check.js');			
			/*
			// use this line below only if you have some problem with JQuery and Mootools
			$document->addCustomTag( '<script type="text/javascript">jQuery.noConflict();</script>' );
			*/
			if ($arg_params->def('show_passworstrength', 1) ) {			
				$folderscriptpwd = 'components/com_alpharegistration/assets/scripts';
				$filenamescriptpwd = 'jquery.pstrength-min.1.2.js';
				// import if file exists
				$filescriptpwdroute =(JPATH_COMPONENT.DS.'assets'.DS.'scripts'.DS.''.$lang.''.DS.''.$filenamescriptpwd.'');
				if (file_exists($filescriptpwdroute)) {
					$document->addScript(JURI::base(true).'/'.$folderscriptpwd.'/'.$lang.'/'.$filenamescriptpwd);
				} else {
					$document->addScript(JURI::base(true).'/'.$folderscriptpwd.'/en-gb/'.$filenamescriptpwd);					
				}
			}
			
			$setFocus = "$(window).load(function(){
					document.josFormARG.name.select();
					document.josFormARG.name.focus();
			});";
				
			$document->addScriptDeclaration($setFocus);	
			
			if ($arg_params->def('show_passwordstrength', 1) ) {
				$initpstrength = "$(function() {
									$('#password').pstrength();
								});";
				$document->addScriptDeclaration($initpstrength);	
			}
		}
		
		// reCaptcha script
		/*
		if ( $arg_params->def( 'userecaptcha', 1 ) ) {		
			$paramsReCaptcha = "var RecaptchaOptions = {
			   theme : '".$arg_params->get( 'themerecaptcha' )."',
			   lang  : '". substr($lang, 0, 2)."'
			};";
			$document->addScriptDeclaration($paramsReCaptcha, '');		
		}
		*/
		
		/*
		if ( $arg_params->def( 'userecaptcha', 1 ) ) {		
			$document->addScript( "http://api.recaptcha.net/js/recaptcha_ajax.js" );			
			$paramsReCaptcha = "
				window.onload = function () {
				Recaptcha.create('". $arg_params->get( 'pubkey' )."',
				'recaptcha_div', {
				 theme: '". $arg_params->get( 'themerecaptcha', 'red' )."',
				 lang  : '". substr($lang, 0, 2)."',
				 callback: Recaptcha.focus_response_field
				});
				}"
			;
			$document->addScriptDeclaration($paramsReCaptcha, '');
		}
		*/
		
		if ( $arg_params->def( 'userecaptcha', 1 ) ) {
			$document->addScript( "http://api.recaptcha.net/js/recaptcha_ajax.js" );
			$paramsReCaptcha = "
				$(window).load(function(){
				Recaptcha.create('". $arg_params->get( 'pubkey' )."',
				'recaptcha_div', {
				theme: '". $arg_params->get( 'themerecaptcha', 'red' )."',
				lang : '". substr($lang, 0, 2)."',
				callback: Recaptcha.focus_response_field
				});
				})"
			;
			$document->addScriptDeclaration($paramsReCaptcha, '');
		} 		
		
		$post 		= JRequest::getVar ( 'post', '', 'default' );
		$referreid 	= JRequest::getVar ( 'referrerid', '', 'default' );
		
		$itemid = ( $arg_params->get('itemid') ) ? '&Itemid='. $arg_params->get('itemid') : '' ;
		
		$this->assignRef('user',             $user);
		$this->assignRef('params',		   $params);
		$this->assignRef('arg_params', $arg_params);
		$this->assignRef('lang',		     $lang);
		$this->assignRef('itemid',		   $itemid);		
		$this->assignRef('post',             $post);
		$this->assignRef('referreid',   $referreid);
		
		parent::display($tpl);
	}
}
