<?php
/*
 * @component AlphaUserPoints
 * @copyright Copyright (C) 2008-2009 Bernard Gilly
 * @license : GNU/GPL
 * @Website : http://www.alphaplug.com
 */

// no direct access
defined('_JEXEC') or die('Restricted access');

jimport('joomla.application.component.controller');

/**
 * @package AlphaUserPoints
 */
class alphauserpointsControllerAccount extends alphauserpointsController
{
	/**
	 * Custom Constructor
	 */
 	function __construct()	{
		parent::__construct( );
	}
	
	//function user2userpoints()
	function display () 
	{
		global $mainframe;
		
		require_once (JPATH_SITE.DS.'components'.DS.'com_alphauserpoints'.DS.'helper.php');
		
		$com_params = &JComponentHelper::getParams( 'com_alphauserpoints' );
		
	
		$model      = &$this->getModel ( 'alphauserpoints' );
		$view       = $this->getView  ( 'account','html' );
		
		// current user
		$user = & JFactory::getUser();
		
		// profil request 
		$userid      = JRequest::getVar( 'userid', '', 'get', 'string' );		
		
		// check referre ID
		if ( ! $userid ) {
			$referrerid = $model->_checkUser();
		} else  {
			if ( !$user->id ) {		
				$msg = JText::_('ALERTNOTAUTH' );
				$mainframe->redirect('index.php', $msg);
			} else {
				$referrerid = $userid;
			}
		}
		
		// Get the parameters of the active menu item
		$params = $model->_getParamsAUP();
		
		$num_item_activities = $params->get( 'num_item_activities', 10 );
	
		$_get_last_points   	= $model->_get_last_points ( $referrerid, $num_item_activities );
		$_listing_last_points	= $_get_last_points[0];
		$_listing_total			= $_get_last_points[1];
		$_listing_limit			= $_get_last_points[2];
		$_listing_limitstart	= $_get_last_points[3];		
		
		$rowsreferrees			= $model->_get_referrees ( $referrerid );
		
		$pointsearned 			= $model->_pointsearned(); // users points earned TOP 10
		$totalpoints			= $model->_totalpoints(); // entire community
		$mypointsearned 		= $model->_mypointsearned($referrerid);
		$mypointsspent 			= $model->_mypointsspent($referrerid);		
		$mypointsearnedthismonth= $model->_mypointsearnedthismonth($referrerid);
		$mypointsspentthismonth	= $model->_mypointsspentthismonth($referrerid);
		$mypointsearnedthisday	= $model->_mypointsearnedthisday($referrerid);
		$mypointsspentthisday	= $model->_mypointsspentthisday($referrerid);
		$_average_age			= _get_average_age_community();
	
		$_user_info = AlphaUserPointsHelper::getUserInfo ( $referrerid );
		
		$currenttotalpoints    	= $_user_info->points;
		$lastupdate 			= $_user_info->last_update;
		$referraluser 			= $_user_info->referraluser;
		
		$myname = $_user_info->name;		
		$myusername = $_user_info->username;
		$mybirthday	= $_user_info->birthdate;
		
		$referralname = "";
		if ( $referraluser ) {
			$referralinfo = AlphaUserPointsHelper::getUserInfo ( $referraluser );
			$referralname = $referralinfo->username;
		}
		
		// get level/rank if exist
		$userrankinfo = AlphaUserPointsHelper::getUserRank ( $referrerid );
		// get medals if exist
		$medalslistuser = AlphaUserPointsHelper::getUserMedals ( $referrerid );
		
		// check if rules for change user level is enabled
		// show only on owner profil
		$messageChangeLevel = "";
		$currentrequests = "";
		if ( $userid == @$_SESSION['referrerid'] || !$userid ) {
			if ( ($user->usertype=='Registered' || $user->usertype=='Author' || $user->usertype=='Editor') && !AlphaUserPointsHelper::checkExcludeUsers($referrerid) ) {
			
				$model2 = &$this->getModel ( 'currentrequests' );
				
				$changelevel1='';
				$changelevel2='';
				$changelevel3='';
				
				switch ( strtolower($user->usertype) ) {
				
					case 'registered':
						$changelevel1 = AlphaUserPointsHelper::checkRuleEnabled( 'sysplgaup_becomeauthor' );
						if ( $changelevel1 ) {					
							if ( $currenttotalpoints>=$changelevel1[0]->points ) {
								// Ready for change level: show message and current requests
								$messageChangeLevel = sprintf(JText::_( 'AUP_YOUHAVESUFFICIENTPOINTSBECOME'), JText::_( 'AUP_AUTHOR' ));							
							}
						}
						break;
						
					case 'author':
						$changelevel2 = AlphaUserPointsHelper::checkRuleEnabled( 'sysplgaup_becomeeditor' );
						if ( $changelevel1 ) {
							if ( $currenttotalpoints>=$changelevel2[0]->points ) {
								// Ready for change level
								$messageChangeLevel = sprintf(JText::_( 'AUP_YOUHAVESUFFICIENTPOINTSBECOME'), JText::_( 'AUP_EDITOR' ));
							}
						}
						break;
		
					case 'editor':
						$changelevel3 = AlphaUserPointsHelper::checkRuleEnabled( 'sysplgaup_becomepublisher' );
						if ( $changelevel1 ) {
							if ( $currenttotalpoints>=$changelevel3[0]->points ) {
								// Ready for change level
								$messageChangeLevel = sprintf(JText::_( 'AUP_YOUHAVESUFFICIENTPOINTSBECOME'), JText::_( 'AUP_PUBLISHER' ));
							}
						}
						break;
					
				}
				
				$currentrequests = $model2->_getCurrentRequests( $user->id, $user->gid );
				
			}
		
		}

		// load avatar
		$useAvatarFrom = $com_params->get('useAvatarFrom');
		$height = '';
		if ( $useAvatarFrom=='alphauserpoints' && $_user_info->avatar!='' ) {
			$useravatarpath = JPATH_SITE . DS . 'components' . DS .  'com_alphauserpoints'. DS . 'assets'. DS . 'images'. DS . 'avatars' . DS . $_user_info->avatar;
			if ( file_exists($useravatarpath)) {
				$size = @getimagesize($useravatarpath);
				$originalheight = $size[1];
				$height = intval($params->get('heightAvatar', 120));
				if ( $originalheight <= $height ) {
					$height = '';
				}
			}
		}
		
		if ( $useAvatarFrom=='alphauserpoints' ) JPlugin::loadLanguage( 'com_media', JPATH_ADMINISTRATOR );	
		
		$avatar = getAvatar( $useAvatarFrom, $_user_info, $height );		
		
		// Get coupons code
		$resultCoupons = $model->_getMyCouponCode( $referrerid );		
						
		$view->assign('params', $params );
		$view->assign('referreid', $referrerid );
		$view->assign('currenttotalpoints', $currenttotalpoints );
		
		$view->assign('rowslastpoints', $_listing_last_points );
		$view->assign('total', $_listing_total );
		$view->assign('limit', $_listing_limit );
		$view->assign('limitstart', $_listing_limitstart );
			
		$view->assign('lastupdate', $lastupdate );		
		$view->assign('referraluser', $referraluser );
		$view->assign('referralname', $referralname );
		$view->assign('rowsreferrees', $rowsreferrees );	
		$view->assign('messageChangeLevel', $messageChangeLevel );
		$view->assign('currentrequests', $currentrequests );
		$view->assign('userid', $user->id);
		$view->assign('gid', $user->gid);
		$view->assign('userrankinfo', $userrankinfo);
		$view->assign('medalslistuser', $medalslistuser);
		$view->assign('pointsearned', $pointsearned);
		$view->assign('totalpoints', $totalpoints);
		$view->assign('mypointsearned', $mypointsearned);
		$view->assign('mypointsspent', $mypointsspent);	
		$view->assign('mypointsearnedthismonth', $mypointsearnedthismonth);
		$view->assign('mypointsspentthismonth', $mypointsspentthismonth);
		$view->assign('mypointsearnedthisday', $mypointsearnedthisday);
		$view->assign('mypointsspentthisday', $mypointsspentthisday);
		$view->assign('myname', $myname);
		$view->assign('myusername', $myusername);
		$view->assign('avatar', $avatar);
		$view->assign('birthday', $mybirthday);
		$view->assign('user_info', $_user_info);
		$view->assign('useAvatarFrom', $useAvatarFrom);
		$view->assign('mycouponscode', $resultCoupons);
		$view->assign('userinfo', $_user_info);
		$view->assign('average_age', $_average_age);		
		
		// Display
		$view->_display();
	}
	
	function saveprofile() {
	
		// Check for request forgeries
		JRequest::checkToken() or jexit( 'Invalid Token' );
	
		$referreid 		= JRequest::getVar('referreid', '', 'post', 'string');
		$newbirthdate	= JRequest::getVar('birthdate', '0000-00-00', 'post', 'string');
		$curdate = date( "Y-m-d" );
		
		if ( $newbirthdate >= $curdate ) {			
			return $this->display();
		}
	
		$model      = &$this->getModel ( 'alphauserpoints' );
		$model->_save_profile();
		
		return $this->display();
	
	}
	
	function downloadactivity() {
			global $mainframe;
	
			$referrerid      = JRequest::getVar( 'userid', '', 'get', 'string' );		
			
			if ( !$referrerid || $referrerid!=@$_SESSION['referrerid'] ) return;			
			
			$db =& JFactory::getDBO();
			$nullDate = $db->getNullDate();
			
			$model      = &$this->getModel ( 'alphauserpoints' );
			$lastpoints   = $model->_get_last_points ( $referrerid, 'nolimit' );			

			$fileName     = "completeactivity_" . uniqid(rand(), true) . ".csv";	
			$filepath     = JPATH_SITE . DS . 'tmp' . DS . $fileName;
			
			$handler = fopen($filepath,"a");
			$header = JText::_('AUP_DATE') . ";" . JText::_('AUP_ACTION') . ";" . JText::_('AUP_POINTS') . ";" . JText::_('AUP_EXPIRE') . ";" .JText::_('AUP_DETAIL') . ";" . JText::_('AUP_APPROVED');
			fwrite($handler, $header ."\n");

			$total = count( $lastpoints );
			for ($i=0;$i< $total;$i++) {
			
				$date_insert = JHTML::_('date',  $lastpoints[$i]->insert_date,  JText::_('DATE_FORMAT_LC2') );
			
				if ( $lastpoints[$i]->expire_date == $nullDate ) {
					$date_expire =  '';
				} else {
					$date_expire = JHTML::_('date',  $lastpoints[$i]->expire_date,  JText::_('DATE_FORMAT_LC') );
				}	
				
				$approved = ( $lastpoints[$i]->approved )?  JText::_('AUP_APPROVED') :  JText::_('AUP_PENDINGAPPROVAL') ;	 					 

				fwrite( $handler, $date_insert . ";" . JText::_($lastpoints[$i]->rule_name) . ";" . $lastpoints[$i]->points . ";" . $date_expire . ";" . $lastpoints[$i]->datareference . ";" . $approved . "\n" );
			}
	
			header("Expires: Mon, 26 Nov 1962 00:00:00 GMT");
			header("Last-Modified: " . gmdate('D,d M Y H:i:s') . ' GMT');
			header("Cache-Control: no-cache, must-revalidate");
			header("Pragma: no-cache");
			header("Content-Type: text/x-comma-separated-values");
			header("Content-Disposition: attachment; filename=$fileName");
			
			readfile($filepath);
			
			exit;
	}
	
	
	function requesttochangelevel() 
	{
		global $mainframe;
		
		$model      = &$this->getModel ( 'alphauserpoints' );
		$model2      = &$this->getModel ( 'currentrequests' );
		
		// check referre ID
		$referrerid = $model->_checkUser();
		
		$model2->_setNewRequest();		
		
		return $this->display();
	}
	
	/* *
	 * upload avatar
	 */
	function uploadavatar()
	{
		global $mainframe;
		
		$db =& JFactory::getDBO();
		$user = & JFactory::getUser();		

		// load language fo component media
		JPlugin::loadLanguage( 'com_media' );
		$params =& JComponentHelper::getParams('com_media');
		
		require_once( JPATH_SITE.DS.'components'.DS.'com_media'.DS.'helpers'.DS.'media.php' );
		
		define('COM_AUP_MEDIA_BASE_IMAGE', JPATH_ROOT.DS.'components'.DS.'com_alphauserpoints'.DS.'assets'.DS.'images');		

		// Check for request forgeries
		JRequest::checkToken( 'request' ) or jexit( 'Invalid Token' );

		$file 		= JRequest::getVar( 'Filedata', '', 'files', 'array' );
		$folder		= JRequest::getVar( 'folder', 'avatars', '', 'path' );
		$format		= JRequest::getVar( 'format', 'html', '', 'cmd');
		$return		= JRequest::getVar( 'return-url', null, 'post', 'base64' );
		$referrerid = JRequest::getVar( 'referrerid', '', 'post', 'string' );
		$err		= null;

		// Set FTP credentials, if given
		jimport('joomla.client.helper');
		JClientHelper::setCredentialsFromRequest('ftp');

		// Make the filename safe
		jimport('joomla.filesystem.file');
		$file['name'] = JFile::makeSafe($file['name']);

		if (isset($file['name']) && $referrerid!='') {
			$extention = JFile::getExt($file['name']);
			$newnameavatar = strtolower($referrerid.'.'.$extention);
			
			//chmod (COM_AUP_MEDIA_BASE_IMAGE.DS.$folder, 0755) ;
			$filepath = JPath::clean(COM_AUP_MEDIA_BASE_IMAGE.DS.$folder.DS.$newnameavatar);
			// erase old avatar
			if ( file_exists($filepath) ) @unlink( $filepath );
			 			
			if (!MediaHelper::canUpload( $file, $err )) {
				if ($format == 'json') {
					jimport('joomla.error.log');
					$log = &JLog::getInstance('upload.error.php');
					$log->addEntry(array('comment' => 'Invalid: '.$filepath.': '.$err));
					header('HTTP/1.0 415 Unsupported Media Type');
					jexit('Error. Unsupported Media Type!');
				} else {
					JError::raiseNotice(100, JText::_($err));
					// REDIRECT
					if ($return) {
						$mainframe->redirect(base64_decode($return));
					}
					return;
				}
			}

			if (JFile::exists($filepath)) {
				if ($format == 'json') {
					jimport('joomla.error.log');
					$log = &JLog::getInstance('upload.error.php');
					$log->addEntry(array('comment' => 'File already exists: '.$filepath));
					header('HTTP/1.0 409 Conflict');
					jexit('Error. File already exists');
				} else {
					JError::raiseNotice(100, JText::_('UPLOAD FAILED. FILE ALREADY EXISTS'));
					// REDIRECT
					if ($return) {
						$mainframe->redirect(base64_decode($return));
					}
					return;
				}
			}

			if (!JFile::upload($file['tmp_name'], $filepath)) {
				if ($format == 'json') {
					jimport('joomla.error.log');
					$log = &JLog::getInstance('upload.error.php');
					$log->addEntry(array('comment' => 'Cannot upload: '.$filepath));
					header('HTTP/1.0 400 Bad Request');
					jexit('ERROR. UNABLE TO UPLOAD FILE');
				} else {
					JError::raiseWarning(100, JText::_('ERROR. UNABLE TO UPLOAD FILE'));
					// REDIRECT
					if ($return) {
						$mainframe->redirect(base64_decode($return));
					}
					return;
				}
			} else {
				// SAVE IN PROFIL USER ALPHAUSERPOINTS
				$query = "UPDATE #__alpha_userpoints" .
				"\n SET avatar='".$newnameavatar."'" .
				"\n WHERE referreid='".$referrerid."' AND userid='" . $user->id . "'"
				;
				$db->setQuery( $query );			
				if (!$db->query()) 
				{
					JError::raiseError( 500, $db->getErrorMsg() );			
					return false;
				}
				
				require_once (JPATH_SITE.DS.'components'.DS.'com_alphauserpoints'.DS.'helper.php');

				if ($format == 'json') {
					jimport('joomla.error.log');
					$log = &JLog::getInstance();
					$log->addEntry(array('comment' => $folder));
					jexit('Upload complete');
					// apply rule for upload avatar
					AlphaUserPointsHelper::userpoints( 'sysplgaup_uploadavatar', '', 0, $referrerid );
					
				} else {
					$mainframe->enqueueMessage(JText::_('UPLOAD COMPLETE'));
					
					// apply rule for upload avatar
					AlphaUserPointsHelper::userpoints( 'sysplgaup_uploadavatar', '', 0, $referrerid );
					
					// REDIRECT
					if ($return) {
						$mainframe->redirect(base64_decode($return));
					}
					return;
				}
			}
		} else {
			$mainframe->redirect('index.php', 'Invalid Request', 'error');
		}
	}
	
}
?>