<?php
/*
 * @component AlphaUserPoints
 * @copyright Copyright (C) 2008-2009 Bernard Gilly
 * @license : GNU/GPL
 * @Website : http://www.alphaplug.com
 */

// no direct access
defined('_JEXEC') or die('Restricted access');

jimport('joomla.application.component.controller');

/**
 * @package AlphaUserPoints
 */
class alphauserpointsControllerBuypoints extends alphauserpointsController
{
	/**
	 * Custom Constructor
	 */
 	function __construct()	{
		parent::__construct( );
	}
	
	function display($params=null) 
	{
		global $mainframe;
		
		$msg = "";
		
		require_once (JPATH_SITE.DS.'components'.DS.'com_alphauserpoints'.DS.'helper.php');		
		
		// rule is enabled ?		
		$plugin_rule = AlphaUserPointsHelper::checkRuleEnabled( 'sysplgaup_buypointswithpaypal' );
		
		if ( !AlphaUserPointsHelper::checkRuleEnabled( 'sysplgaup_buypointswithpaypal' ) ) 
		{
			$msg = JText::_('AUP_THISRULEDISABLED' );
		}
		
		jimport( 'joomla.mail.helper' );
		
		$user = & JFactory::getUser();
		
		if ( !$user->id ) 
		{
			$msg = JText::_('AUP_YOUMUSTBELOGGED' );		
		}
		
		$model      = &$this->getModel ( 'alphauserpoints' );
		$view       = $this->getView  ( 'buypoints','html' );
		
		// Get the parameters of the active menu item			
		$menus	    = &JSite::getMenu();
		$menu       = $menus->getActive();
		$menuid     = $menu->id;
		$menuname   = $menu->name;
		
		if ( !$params )
		{
			$params = $model->_getParamsAUP();
		} 
		
		// Paypal account
		if ( $params->get( 'usepaypaltestaccount' ) )
		{
			// use test mode
			$business = $params->get('testaccountmail', '');
		}
		else
		{
			// use real account
			$business = $params->get('businessmail', '');
		}
		
		// Check for a valid from address account Paypal
		if ( !JMailHelper::isEmailAddress($business) )
		{
			$msg = JText::_('AUP_PAYPAL_ACCOUNT_EMAIL_INVALID');			
		}

		if ( $msg ) $mainframe->redirect('index.php', $msg, 'error');
		
		// active user		
		$referrerid = $model->_checkUser();

		// get current total points
		$currenttotalpoints = AlphaUserPointsHelper::getCurrentTotalPoints( $referrerid );
		
		// get article for description if exist
		$article = $model->_getArticleDescription( $params->get('id_content_to_show') );
		$title = "";
		$description = "";
		
		if ( $article ) 
		{		
			$title = $article[0]->title;
			$description = $article[0]->introtext;
		}				
		
		$view->assign('params', $params );
		$view->assign('referreid', $referrerid );
		$view->assign('userid', $user->id );
		$view->assign('currenttotalpoints', $currenttotalpoints );
		$view->assign('menuid', $menuid );
		$view->assign('menuname', $menuname );
		$view->assign('title', $title );
		$view->assign('description', $description );
		$view->assign('success', 0 );
	
		// Display
		$view->_display();
	}	
	
	function success() 
	{
		global $mainframe;	
		
		require_once (JPATH_SITE.DS.'components'.DS.'com_alphauserpoints'.DS.'helper.php');			
		
		$referrerid      = JRequest::getString('refID', '', 'get');		
		$Itemid          = JRequest::getString('Itemid', '', 'get');
		$tx_token        = JRequest::getString('tx', '', 'get' );
		
		$model      = &$this->getModel ( 'alphauserpoints' );
		$modelVal   = &$this->getModel ( 'validate_payment' );
		$view       = $this->getView  ( 'buypoints','html' );
		
		// Get the parameters of the active menu item
		$menus	    = &JSite::getMenu();
		$menu       = $menus->getActive();
		$menuid     = $menu->id;
		$menuname   = $menu->name;
		
		//$params     = $menus->getParams($Itemid);
		$params = $model->_getParamsAUP();

		// Check validation
		$val = $modelVal->validatePDT( $params, $tx_token, $referrerid );
		
		$response = $val[0];
		$transaction = $val[1];
		$currenttotalpoints = AlphaUserPointsHelper::getCurrentTotalPoints( $referrerid );

		$view->assign('params', $params );
		$view->assign('menuname', $menuname );
		$view->assign('success', $response->success );
		$view->assign('msg', $response->msg );
		$view->assign('currenttotalpoints', $currenttotalpoints );
		$view->assign('transaction', $transaction );
		
		// Display
		$view->_display();
	}
	
	
	function cancel() 
	{
		global $mainframe;
		
		$Itemid = JRequest::getString('Itemid', '', 'get');
		
		$menus	    = &JSite::getMenu();
		$params     = $menus->getParams($Itemid);
		
		$error = JText::_('AUP_PURCHASE_CANCELED');
		JError::raiseWarning( 0, $error );
		return $this->display($params);
	}	
	
}
?>