<?php
/*
 * @component AlphaUserPoints
 * @copyright Copyright (C) 2008-2009 Bernard Gilly
 * @license : GNU/GPL
 * @Website : http://www.alphaplug.com
 */

// Check to ensure this file is included in Joomla!
defined('_JEXEC') or die();

jimport( 'joomla.application.component.model' );

class alphauserpointsModelalphauserpoints extends Jmodel {

	function __construct(){
		parent::__construct();
		
	}
	
	function _getParamsAUP() {
	
		// Get the parameters of the active menu item
		$menus	    = &JSite::getMenu();
		$menu       = $menus->getActive();
		$menuid     = @$menu->id;
		$params     = $menus->getParams($menuid);
		
		return $params;
	
	}
	
	function _sendXpoints2friend () {
		global $mainframe;
	
		$user = & JFactory::getUser();
		$db	   =& JFactory::getDBO();
		
		$referreid 			= JRequest::getVar('referreid','');
		$numpoints 			= abs(JRequest::getVar('numpoints', 0));
		$username2points 	= JRequest::getVar('username2points', '');
		$userid 			= JRequest::getVar('userid', 0);
		$currenttotalpoints	= JRequest::getVar('currenttotalpoints', 0);
		$menuid				= JRequest::getVar('menuid', 0);		
		
		$curday = date( "Y-m-d H:i:s" );

		if ( $referreid && $numpoints && $username2points && ($user->id==$userid) ) {
		
			$redirect = "index.php?option=com_alphauserpoints&view=user2userpoints&Itemid=$menuid";
			
			if ( $numpoints > $currenttotalpoints ) {					
				$msg = JText::_( 'AUP_NUMBEROFPOINTSSENTEXCEDYOURTOTAL');				
				$mainframe->redirect( $redirect, $msg, 'error' );
			} else {			
				// search the user/friend
				$query = "SELECT * FROM #__users WHERE username LIKE '$username2points' AND `block`='0'";
				$db->setQuery( $query );
				$rowsusers = $db->loadObjectList();
				if ( count($rowsusers)>1 ) {
					$msg = JText::_( 'AUP_SEVERALUSERSWITHSAMEUSERNAME');
					$mainframe->redirect( $redirect, $msg, 'error' );
				} elseif ( count($rowsusers)==0 ) {
					$msg = JText::_( 'AUP_NOBODYWITHTHISUSERNAME');
					$mainframe->redirect( $redirect, $msg, 'error' );				
				} elseif ( count($rowsusers)==1 ) {					
					require_once (JPATH_SITE.DS.'components'.DS.'com_alphauserpoints'.DS.'helper.php');		
					$friend_referreid = AlphaUserPointsHelper::getAnyUserReferreID($rowsusers[0]->id);
					if ( $friend_referreid ) {
						$result = AlphaUserPointsHelper::checkRuleEnabled( 'sysplgaup_user2userpoints' );
						// send new points to user friend			
						if ( AlphaUserPointsHelper::userpoints( 'sysplgaup_user2userpoints', $friend_referreid, 0, '', JText::_( 'AUP_THESEPOINTSWEREDONATEDBY')." ".$referreid." (".$user->username.")", $numpoints, true) ){
							// remove points to active user
							AlphaUserPointsHelper::insertUserPoints( $referreid, ($numpoints*(-1)), $result[0]->rule_expire, $result[0]->id, 0, '', JText::_( 'AUP_POINTSGIVENTO')." ".$friend_referreid ." (".$username2points.")");
							$msg = JText::_( 'AUP_YOUHAVESENDYOURPOINTSWITHSUCCESS');
						} else {
							$msg = JText::_( 'AUP_YOU_HAVE_ALREADY_DONATE_TODAY');
						}
						$mainframe->redirect( $redirect, $msg );
					} else {					
						$msg = JText::_( 'AUP_ERROR');
						$mainframe->redirect( $redirect, $msg, 'error' );
					}
				}
			}
		}		
		return true;
	}

	function _get_last_points( $referrerid, $limit=10 ) {
		global $mainframe;
		
		$db	   =& JFactory::getDBO();
		
		if ( $limit=='all') {
			// Get the pagination request variables
			$limit = $mainframe->getUserStateFromRequest('com_alphauserpoints.limit', 'limit', $mainframe->getCfg('list_limit'), 'int');
			$limitstart = JRequest::getVar('limitstart', 0, '', 'int');
			// In case limit has been changed, adjust limitstart accordingly
			$limitstart = ( $limit != 0 ? (floor( $limitstart / $limit ) * $limit) : 0);		
			$query = "SELECT a.*, r.rule_name, r.plugin_function FROM #__alpha_userpoints_details AS a, #__alpha_userpoints_rules as r "
					."\nWHERE a.referreid='$referrerid' AND a.rule=r.id"
					."\nORDER BY a.insert_date DESC";
			$total = @$this->_getListCount($query);
			$result = $this->_getList($query, $limitstart, $limit);
			return array($result, $total, $limit, $limitstart);
			
		} elseif ( $limit=='nolimit' ) {		// used for export CSV
			$query = "SELECT a.*, r.rule_name, r.plugin_function FROM #__alpha_userpoints_details AS a, #__alpha_userpoints_rules as r "
					."\nWHERE a.referreid='$referrerid' AND a.rule=r.id"
					."\nORDER BY a.insert_date DESC";
			$db->setQuery( $query );
			$rowslastpoints = $db->loadObjectList();
			return $rowslastpoints;				
		} else {		
			$limit = "LIMIT " . $limit ;
			$query = "SELECT a.*, r.rule_name, r.plugin_function FROM #__alpha_userpoints_details AS a, #__alpha_userpoints_rules as r "
					."\nWHERE a.referreid='$referrerid' AND a.rule=r.id"
					."\nORDER BY a.insert_date DESC $limit";
			$db->setQuery( $query );
			$rowslastpoints = $db->loadObjectList();
			return array($rowslastpoints, null, null, null);
		}	
	
	}
	
	function _get_referrees ( $referrerid ) {
		
		$db	   =& JFactory::getDBO();
		$query = "SELECT * FROM #__alpha_userpoints WHERE referraluser='$referrerid'";
		$db->setQuery( $query );
		$rowsreferrees = $db->loadObjectList();
		
		if ( $rowsreferrees ) {
			require_once (JPATH_SITE.DS.'components'.DS.'com_alphauserpoints'.DS.'helper.php');		
			for ($i=0, $n=count( $rowsreferrees ); $i < $n; $i++) {				
				$UserInfo = AlphaUserPointsHelper::getUserInfo ( $rowsreferrees[$i]->referreid );
				$username = $UserInfo->username;
				$name = $UserInfo->name;
				$rowsreferrees[$i]->username = $username;	
				$rowsreferrees[$i]->name = $name;		
			}		
		}

		return $rowsreferrees;
	}
	
	function _checkCurrentMaxPerDay( $ruleid, $userid, $referrerid, $ip ) {	
	
		$db	=& JFactory::getDBO();
		
		$curdate = date( "Y-m-d" );
		
		if ( $userid ) {			
			// count invite sent this day
			$query = "SELECT count(*) FROM #__alpha_userpoints_details WHERE rule='$ruleid' AND referreid='$referrerid' AND `insert_date` LIKE '$curdate%'";
		} else {
			// count guest invite sent this day
			$query = "SELECT count(*) FROM #__alpha_userpoints_details WHERE rule='$ruleid' AND referreid='GUEST' AND `insert_date` LIKE '$curdate%' AND keyreference='$ip'";
		}	
		$db->setQuery( $query );
		$result = $db->loadResult();
		
		return $result;
	
	}
	
	function _checkLastInviteForDelay( $ruleid, $userid=0, $referrerid, $ip, $delay ) {	
	
		$db	=& JFactory::getDBO();
		
		$jnow		=& JFactory::getDate();
		$now		= $jnow->toMySQL();
		$ts 		= strtotime( $now );		
				
		$checkdelay = 1;
		
		if ( $userid ) {			
			$query = "SELECT `insert_date` FROM #__alpha_userpoints_details WHERE rule='$ruleid' AND referreid='$referrerid' ORDER BY `insert_date` DESC LIMIT 1";
		} else {
			$query = "SELECT `insert_date` FROM #__alpha_userpoints_details WHERE rule='$ruleid' AND referreid='GUEST' AND keyreference='$ip' ORDER BY `insert_date` DESC LIMIT 1";
		}	
		$db->setQuery( $query );
		$result = $db->loadResult();
		
		// if exist -> compare
		if ( $result ) {				
			$lasttime = strtotime($result) + $delay;						
			if ( $lasttime > $ts ){
				$checkdelay = 0;
			}	
		}
		
		return $checkdelay;
	
	}
	
	function _extractEmailsFromString($sChaine) {	 
		if(false !== preg_match_all('`\w(?:[-_.]?\w)*@\w(?:[-_.]?\w)*\.(?:[a-z]{2,4})`', $sChaine, $aEmails)) {
			if(is_array($aEmails[0]) && sizeof($aEmails[0])>0) {
				return array_unique($aEmails[0]);
			}
		}		 
		return null;
	}	
	
	function _checkUser()  {
		global $mainframe;
		
		// active user
		$user = & JFactory::getUser();	
		
		// check referre ID
		$referrerid = @$_SESSION['referrerid'];		
		
		if ( !$user->id || !$referrerid ) {		
			$msg = JText::_('ALERTNOTAUTH' );
			$mainframe->redirect('index.php', $msg);
		} else return $referrerid;
		
	}

	function _getReferreid()  {
		global $mainframe;
		
		// check referre ID
		$referrerid = @$_SESSION['referrerid'];		
		
		return $referrerid;
		
	}
	
	function _getRuleID ( $plugin_function ) {
	
		$db	=& JFactory::getDBO();
		 
		$query = "SELECT id FROM #__alpha_userpoints_rules WHERE plugin_function='$plugin_function'";
		$db->setQuery( $query );
		$result = $db->loadResult();
		
		return $result;	
	}
	
	
	function _getUsersList(){
		global $mainframe;
		
		$db			        =& JFactory::getDBO();		
				
		// exclude specific users of this list
		$excludeuser = array();		
		$excludeusers = "";
		$query = "SELECT exclude_items FROM #__alpha_userpoints_rules WHERE `plugin_function`='sysplgaup_excludeusers' AND `published`='1'";
		$db->setQuery( $query );
		$result  = $db->loadResult();		
		if ( $result ) {		
			$excludeuser = explode( ",", $result);
			for ($i=0, $n=count($excludeuser); $i < $n; $i++) {		
				$excludeusers .= " AND aup.referreid!='" . trim($excludeuser[$i]) . "'";
			}			
		}

		$filter_order		= $mainframe->getUserStateFromRequest( "com_alphauserpoints.filter_order",		'filter_order',		'aup.points',	'cmd' );
		$filter_order_Dir	= $mainframe->getUserStateFromRequest( "com_alphauserpoints.filter_order_Dir",	'filter_order_Dir',	'DESC',			'word' );

		// Get the pagination request variables
		$limit = $mainframe->getUserStateFromRequest('com_alphauserpoints.limit', 'limit', $mainframe->getCfg('list_limit'), 'int');
		$limitstart = JRequest::getVar('limitstart', 0, '', 'int');
		// In case limit has been changed, adjust limitstart accordingly
		$limitstart = ( $limit != 0 ? (floor( $limitstart / $limit ) * $limit) : 0);
		
		$orderby = " ORDER BY " . $filter_order . " " . $filter_order_Dir;
			
		$query = "SELECT aup.id AS rid, aup.points, aup.referreid, aup.last_update, aup.referraluser, u.name AS usr_name, u.username AS usr_username, aup.levelrank"
		. "\n FROM #__alpha_userpoints AS aup, #__users AS u"
		. "\n WHERE aup.userid = u.id"
		. $excludeusers	
		. $orderby
		;				
		$total  = @$this->_getListCount($query);

		$rows = $this->_getList( $query, $limitstart , $limit );			
		
		// table ordering
		$lists['order_Dir']	= $filter_order_Dir;
		$lists['order']		= $filter_order;
		
		return array ( $rows, $total, $limit, $limitstart, $lists );
	
	}
	
	function _getArticleDescription ( $idArticle ){
	
		$db	=& JFactory::getDBO();
		
		$query = "SELECT id, title, introtext FROM #__content WHERE id='$idArticle'";
		$db->setQuery( $query );
		$result = $db->loadObjectList();
		
		return $result;	
	
	}	
	
	function _pointsearned() { // function for TOP 10 in statistics tab
	
		$db =& JFactory::getDBO();
		
		// exclude specific users of this list
		$excludeuser = array();		
		$excludeusers = "";
		$query = "SELECT exclude_items FROM #__alpha_userpoints_rules WHERE `plugin_function`='sysplgaup_excludeusers' AND `published`='1'";
		$db->setQuery( $query );
		$result  = $db->loadResult();		
		if ( $result ) {		
			$excludeuser = explode( ",", $result);
			for ($i=0, $n=count($excludeuser); $i < $n; $i++) {		
				$excludeusers .= " AND aup.referreid!='" . trim($excludeuser[$i]) . "'";
			}
		}		
		
		$query = "SELECT a.referreid, SUM(a.points) AS sumpoints, u.username AS username, u.name AS name"
			   . " FROM #__alpha_userpoints_details AS a, #__alpha_userpoints AS aup, #__users AS u"
			   //. " WHERE aup.referreid=a.referreid AND aup.userid=u.id AND a.approved='1' AND a.status='1' AND a.points>=1"
			   . " WHERE aup.referreid=a.referreid AND aup.userid=u.id AND a.approved='1' AND a.status='1'"
			   . $excludeusers			   
			   . " GROUP BY a.referreid"
			   . " ORDER BY sumpoints DESC"
			   . " LIMIT 10"
			   ;

		$db->setQuery( $query );
		$result = $db->loadObjectList();

		return $result;
	}
	
	function _totalpoints() {
	
		$db =& JFactory::getDBO();
		
		$query = "SELECT SUM(a.points)"
			   . " FROM #__alpha_userpoints_details AS a"
			   . " WHERE a.approved='1' AND a.status='1'"
			   ;

		$db->setQuery( $query );
		$result = $db->loadResult();

		return $result;
	
	}	
	
	function _mypointsearned($referreid) {	
		
		$db =& JFactory::getDBO();
		
		$query = "SELECT SUM(a.points)"
			   . " FROM #__alpha_userpoints_details AS a"
			   . " WHERE a.approved='1' AND a.status='1' AND a.points>=1 AND a.referreid='" . $referreid . "'";
			   ;

		$db->setQuery( $query );
		$result = $db->loadResult();

		return $result;
	
	}

	function _mypointsspent($referreid) {	
		
		$db =& JFactory::getDBO();
		
		$query = "SELECT SUM(a.points)"
			   . " FROM #__alpha_userpoints_details AS a"
			   . " WHERE a.approved='1' AND a.status='1' AND a.points<0 AND a.referreid='" . $referreid . "'";
			   ;

		$db->setQuery( $query );
		$result = $db->loadResult();

		return $result;
	
	}
	
	function _mypointsearnedthismonth($referreid) {	
		
		$db =& JFactory::getDBO();
		
		$curmonth = date( "Y-m-" );
		
		$query = "SELECT SUM(a.points)"
			   . " FROM #__alpha_userpoints_details AS a"
			   . " WHERE a.approved='1' AND a.status='1' AND a.points>=1 AND a.referreid='" . $referreid . "' AND insert_date LIKE '".$curmonth."%'";
			   ;

		$db->setQuery( $query );
		$result = $db->loadResult();

		return $result;
	
	}

	function _mypointsspentthismonth($referreid) {	
		
		$db =& JFactory::getDBO();
		
		$curmonth = date( "Y-m-" );
		
		$query = "SELECT SUM(a.points)"
			   . " FROM #__alpha_userpoints_details AS a"
			   . " WHERE a.approved='1' AND a.status='1' AND a.points<0 AND a.referreid='" . $referreid . "' AND insert_date LIKE '".$curmonth."%'";
			   ;

		$db->setQuery( $query );
		$result = $db->loadResult();

		return $result;
	
	}

	function _mypointsearnedthisday($referreid) {	
		
		$db =& JFactory::getDBO();
		
		$curday = date( "Y-m-d" );
		
		$query = "SELECT SUM(a.points)"
			   . " FROM #__alpha_userpoints_details AS a"
			   . " WHERE a.approved='1' AND a.status='1' AND a.points>=1 AND a.referreid='" . $referreid . "' AND insert_date LIKE '".$curday."%'";
			   ;

		$db->setQuery( $query );
		$result = $db->loadResult();

		return $result;
	
	}

	function _mypointsspentthisday($referreid) {	
		
		$db =& JFactory::getDBO();
		
		$curday = date( "Y-m-d" );
		
		$query = "SELECT SUM(a.points)"
			   . " FROM #__alpha_userpoints_details AS a"
			   . " WHERE a.approved='1' AND a.status='1' AND a.points<0 AND a.referreid='" . $referreid . "' AND insert_date LIKE '".$curday."%'";
			   ;

		$db->setQuery( $query );
		$result = $db->loadResult();

		return $result;
	
	}
	
	function _save_profile() {
		global $mainframe;
		
		// initialize variables
		$db =& JFactory::getDBO();
		$post	= JRequest::get( 'post' );
		
		$profilecomplete = 0;
		
		if ( $post['referreid']=='' ) {
			echo "<script>window.history.go(-1);</script>\n";
			exit();
		} 
		
		JTable::addIncludePath(JPATH_ADMINISTRATOR.DS.'components'.DS.'com_alphauserpoints'.DS.'tables');
		$row =& JTable::getInstance('userspoints');

		if ( $post['birthdate']=='' ) {
			$post['birthdate'] = '0000-00-00';
		}
		
		if (!$row->bind( $post )) {
			echo "<script> alert('".$row->getError()."'); window.history.go(-1); </script>\n";
			exit();
		}
		
		if (!$row->store()) {
			echo "<script> alert('".$row->getError()."'); window.history.go(-1); </script>\n";
			exit();
		}
		
		$mainframe->enqueueMessage( JText::_('AUP_CHANGE_SAVED') );
		
		// check if all field are complete for the profile complete rule
		if ( $post['gender'] > 0 && $post['birthdate']!='' && $post['birthdate']!='0000-00-00' && $post['aboutme']!='' && $post['city']!='' && $post['avatar']!='' && $post['job']!='' && $post['education']!='' && $post['graduationyear']!='' ) {
			$profilecomplete = 1;
		}
				
		// rules for Profile
		require_once (JPATH_SITE.DS.'components'.DS.'com_alphauserpoints'.DS.'helper.php');
		if ( $profilecomplete ) {
			// assigns points when the user upload his avatar: this rule can be assigned only once per user
			AlphaUserPointsHelper::userpoints( 'sysplgaup_profilecomplete', '', 0, $post['referreid'] );
		} else {
			// remove points if profile has been complete and now remove required fields for profile complete -> state incomplete
			$rule = AlphaUserPointsHelper::checkRuleEnabled ( 'sysplgaup_profilecomplete' ) ;
			if ( $rule ) { // rule published			
				// get ID of rule named 'sysplgaup_profilecomplete'
				$idrule = $rule[0]->id;
				$query = "DELETE FROM #__alpha_userpoints_details WHERE rule='".$idrule."' AND referreid='".$post['referreid']."' AND keyreference='".$post['referreid']."'";
				$db->setQuery( $query );
				$db->query();
				// recount for this user
				$this->checkNewTotal( $post['referreid'] );
			}
		}
	}
	
	function checkNewTotal( $referreid )
	{
		$db			=& JFactory::getDBO();
		$jnow		=& JFactory::getDate();		
		$now		= $jnow->toMySQL();
		
		require_once (JPATH_SITE.DS.'components'.DS.'com_alphauserpoints'.DS.'helper.php');		
		
		// recalculate for this user 
		$query = "SELECT SUM(points) FROM #__alpha_userpoints_details WHERE `referreid`='" . $referreid . "' AND `approved`='1' AND (`expire_date`>'$now' OR `expire_date`='0000-00-00 00:00:00')";
		$db->setQuery($query);
		$newtotal = $db->loadResult();

		$query = "UPDATE #__alpha_userpoints SET `points`='" . intval($newtotal) . "', `last_update`='$now' WHERE `referreid`='" . $referreid . "'";
		$db->setQuery( $query );
		$db->query();
		
		// update Ranks / Medals if necessary		
		AlphaUserPointsHelper::checkRankMedal ( $referreid );
	
	}	
	
	function _getMyCouponCode( $referreid ) {
		global $mainframe;
	
		$db =& JFactory::getDBO();		
		
		$query = "SELECT d.* FROM #__alpha_userpoints_details AS d, #__alpha_userpoints_rules AS r WHERE d.referreid='$referreid' AND r.id=d.rule AND r.plugin_function='sysplgaup_couponpointscodes'";
		$db->setQuery( $query );
		$resultCoupons = $db->loadObjectList();

		return $resultCoupons;		
	
	}	
	
}
?>