<?php
/**
 * @version		view.php 
* Created on: 01/03/2008 
 * @package		CMS Shop builder for Joomla 1.5
 * @subpackage	frontend Catalog manager
 * @copyright	Copyright (C) 2007 - 2008 wasan ongart. All rights reserved.
 */
// Check to ensure this file is included in Joomla!
defined('_JEXEC') or die();
jimport( 'joomla.application.component.view');

class CmsshopbuilderViewSearch extends JView
{
	function display($tpl = null)
	{
		global $mainframe;
		require_once(JPATH_COMPONENT.DS.'helpers'.DS.'search.php' );
		$document	= & JFactory::getDocument();

		$pathway  =& $mainframe->getPathway();
		$uri      =& JFactory::getURI();
		$error	= '';
			
		// Get some data from the model
		$state 		= &$this->get('state');		
		$searchword = $state->get('keyword');
		$ordering	 = $state->get('ordering');
		
		
		
		// Get the parameters of the active menu item
		$params	= &$mainframe->getParams();
		// built select lists
		$orders = array();
		$orders[] = JHTML::_('select.option',  'pname', JText::_( 'productname' ) );		
		$orders[] = JHTML::_('select.option',  'price', JText::_( 'productprice' ) );
		$orders[] = JHTML::_('select.option',  'sku', JText::_( 'productsku' ) );
		$orders[] = JHTML::_('select.option',  'pdesc', JText::_( 'productdesc' ) );
		$orders[] = JHTML::_('select.option',  'category', JText::_( 'category' ) );
		$orders[] = JHTML::_('select.option',  'upc', JText::_( 'productupc' ) );
		$orders[] = JHTML::_('select.option',  'isbn', JText::_( 'productisbn' ) );

		$lists = array();
		$lists['ordering'] = JHTML::_('select.genericlist',   $orders, 'ordering', 'class="inputbox"', 'value', 'text', $state->get('ordering')	 );
		
		
		// log the search
		CmsShopbuilderSearchHelper::logSearch( $searchword);
		if (!$searchword || $searchword == '' )  {
			$error = JText::_( 'Please Enter a search keyword' );
		}

		if(!$error)
		{
		$results	= &$this->get('data' );
		$total		= &$this->get('total');
		$pagination	= &$this->get('pagination');
		}
		//

		$this->assignRef('pagination',  $pagination);
		$this->assignRef('results',		$results);
		$this->assignRef('lists',		$lists);
		$this->assignRef('params',		$params);	
		$this->assign('error',			$error);
		
		
		$this->assign('ordering',		$state->get('ordering'));
		$this->assign('searchword',		$searchword);
		$this->assign('total',		$total);		
		$this->assign('action', 	    $uri->toString());
		
		parent::display($tpl);

	}
}
?>