<?php defined('_JEXEC') or die('Restricted access');

jimport('joomla.application.component.controller');

/**
 * Custom Gallery Component Controller
 *
 * @package        CustomGallery
 */
class CustomGalleryController extends JController
{
    function galleries() {

        require_once JPATH_COMPONENT_ADMINISTRATOR.DS.'configuration.php';

        $database = &JFactory::getDBO();
        $cgConfig = new cgConfig();

        $database->setQuery("
            SELECT g.*, e.media_id, e.media_type, e.filename AS image_filename, COUNT(ee.id) AS entry_count
            FROM #__customgallery_galleries AS g
                LEFT JOIN #__customgallery_entries AS e ON e.id = g.entry_id
                LEFT JOIN #__customgallery_entries AS ee ON ee.gallery_id = g.id
            WHERE g.published = 1 GROUP BY g.id
        ");
        $rows  = $database->loadObjectList();
        $lists = array();
        
        if ($cgConfig->show_gallery_menu)
            CustomGalleryFrontView::showGalleryMenu( $rows );

        CustomGalleryFrontView::showGalleries($rows, $lists);
    }
    
    function gallery() {

        require_once JPATH_COMPONENT_ADMINISTRATOR.DS.'configuration.php';

        $mainframe =& JFactory::getApplication();
        $database  =& JFactory::getDBO();
        $user      =& JFactory::getUser();

        JTable::addIncludePath(JPATH_COMPONENT_ADMINISTRATOR.DS.'tables');

        $gallery   =& JTable::getInstance('customGallery','Table');
        $field     =& JTable::getInstance('customGalleryField','Table');
        
        $context    = 'customgallery.galleries';
      //$limit      = $mainframe->getUserStateFromRequest('customgallery', 'limit', 18, 'int');
        $limit      = 20;
      //$limitstart = $mainframe->getUserStateFromRequest($context.'limitstart', 'limitstart', 0, 'int');
        $limitstart = JRequest::getVar('limitstart', 0, '', 'int');
        $mymodel    = $this->getModel();

        $mainframe->setUserState('limitstart', $limitstart);

        $limitstart = ($limit != 0 ? (floor($limitstart / $limit) * $limit) : 0);
        
        $cgConfig       = new cgConfig();
        $gallery_id     = JRequest::getInt('id');
        $filter_type    = JRequest::getInt('filter');
        $custom_filters = JRequest::getVar('customfilter',null,'request','array');
        $option         = JRequest::getCmd('option');
        $Itemid         = JRequest::getInt('Itemid');
        $custom_in      = array();

        #print_r($custom_filters);

        $gallery->load( $gallery_id );

        foreach ( (array)$custom_filters as $cf_id => $cf_value ) {
            $cf_id = (int) $cf_id;
            $cf_value = $database->quote($database->getEscaped($cf_value));
            $database->setQuery("
                SELECT type FROM #__customgallery_customfields
                WHERE id = $cf_id
                LIMIT 1
            ");
            $field_type = $database->loadResult();
            #print_r($field_type);

            if ($field_type == 3) {
                $database->setQuery("
                    SELECT entry_id, value FROM #__customgallery_customdata WHERE field_id = $cf_id
                ");
                $multi_choices = $database->loadObjectList();
                $entry_ids = array();
                foreach( $multi_choices as $m_choice ) {
                    if( in_array($value,explode(',',$m_choice->value)) ) $entry_ids[] = $m_choice->entry_id;
                }
                $database->setQuery("
                    SELECT entry_id FROM #__customgallery_customdata
                    WHERE field_id = $cf_id 
                    AND entry_id IN (".implode(',',$entry_ids).")
                ");
            } else {
                #print " id: $cf_id, value: $cf_value ";
                $database->setQuery("
                    SELECT entry_id FROM #__customgallery_customdata
                    WHERE field_id = $cf_id
                    AND value = $cf_value
                ");
            }
            $custom_in = array_merge( $custom_in, $database->loadResultArray() );
            #print_r($custom_in);
        }
        
        $cf_count = count($custom_filters);
        $lists = array();
        $lists['order_filter_type'] = $filter_type;
        switch ($filter_type) {
            case 1:
                // Oldest first
                $query = "SELECT e.*, AVG(r.rating) AS rating FROM #__customgallery_entries AS e"
                . " LEFT JOIN #__customgallery_ratings as r ON r.entry_id = e.id"
                . " WHERE e.gallery_id = ".$gallery->id." AND e.published = '1'";
                if ($cf_count) $query .= " AND e.id IN (".implode(',',$custom_in).")";
                $query .= " GROUP BY e.id ORDER BY e.create_date ASC";
            break;
            case 2:
                // Highest rating
                $query = "SELECT e.*, AVG(r.rating) AS rating FROM #__customgallery_entries AS e"
                . " LEFT JOIN #__customgallery_ratings as r ON r.entry_id = e.id"
                . " WHERE e.gallery_id = ".$gallery->id." AND e.published = '1'";
                if ($cf_count) $query .= " AND e.id IN (".implode(',',$custom_in).")";
                $query .= " GROUP BY e.id ORDER BY rating DESC";
            break;
            case 3:
                // Lowest rating
                $query = "SELECT e.*, AVG(r.rating) AS rating FROM #__customgallery_entries AS e"
                . " LEFT JOIN #__customgallery_ratings as r ON r.entry_id = e.id"
                . " WHERE e.gallery_id = ".$gallery->id." AND e.published = '1'";
                if ($cf_count) $query .= " AND e.id IN (".implode(',',$custom_in).")";
                $query .= " GROUP BY e.id ORDER BY rating ASC";
            break;
            case 4:
                // Most comments
                $query = "SELECT e.*, COUNT(c.id) AS comment_count FROM #__customgallery_entries AS e"
                . " LEFT JOIN #__customgallery_comments as c ON c.entry_id = e.id"
                . " WHERE e.gallery_id = ".$gallery->id." AND e.published = '1'";
                if ($cf_count) $query .= " AND e.id IN (".implode(',',$custom_in).")";
                $query .= " GROUP BY e.id ORDER BY comment_count DESC";
            break;
            case 5:
                // Least comments
                $query = "SELECT e.*, COUNT(c.id) AS comment_count FROM #__customgallery_entries AS e"
                . " LEFT JOIN #__customgallery_comments as c ON c.entry_id = e.id"
                . " WHERE e.gallery_id = ".$gallery->id." AND e.published = '1'";
                if ($cf_count) $query .= " AND e.id IN (".implode(',',$custom_in).")";
                $query .= " GROUP BY e.id ORDER BY comment_count ASC";
            break;
            case 0:
            default:
                // Most recent
                $query = "SELECT e.*, AVG(r.rating) AS rating FROM #__customgallery_entries AS e"
                . " LEFT JOIN #__customgallery_ratings as r ON r.entry_id = e.id"
                . " WHERE e.gallery_id = ".$gallery->id." AND e.published = '1'";
                if ($cf_count) $query .= " AND e.id IN (".implode(',',$custom_in).")";
                $query .= " GROUP BY e.id ORDER BY e.create_date DESC";
        }
        
        
        
        $database->setQuery( $query );
        $lists['entries'] = $database->loadObjectList();
        $total = count($lists['entries']);
        
        $database->setQuery( $query, $limitstart, $limit);
        $lists['entries'] = $database->loadObjectList();
        
        jimport('joomla.html.pagination');
        $pagination = new JPagination($total, $limitstart, $limit);
        
        $filter_link = JRoute::_("index.php?option={$option}&task=gallery&id={$gallery->id}&Itemid={$Itemid}");
        $filter_link_plain = "index.php?option={$option}&task=gallery&id={$gallery->id}&Itemid={$Itemid}";
        
        $filter_options = array();
        $filter_options[] = JHTML::_('select.option','0',JText::_('Most recent'),'value','text');
        $filter_options[] = JHTML::_('select.option','1',JText::_('Oldest first'),'value','text');
        $filter_options[] = JHTML::_('select.option','2',JText::_('Highest rating'),'value','text');
        $filter_options[] = JHTML::_('select.option','3',JText::_('Lowest rating'),'value','text');
        $filter_options[] = JHTML::_('select.option','4',JText::_('Most comments'),'value','text');
        $filter_options[] = JHTML::_('select.option','5',JText::_('Least comments'),'value','text');

        $lists['ordering'] = '<form id="filter_form" name="filter_form" action="'.$filter_link.'" method="post">';
        //$lists['ordering'] .= JHTML::_('select.genericlist', $filter_options, 'filter','class="cg_filter" onchange="document.location=\''.$filter_link.'&filter=\'+this.options[this.selectedIndex].value"','value','text', $filter_type);
        $lists['ordering'] .= JHTML::_('select.genericlist', $filter_options, 'filter','class="cg_filter" onchange="this.form.submit();"','value','text', $filter_type);
        $lists['ordering'] .= '</form>';
        
        // Load custom fields and options.
        $query = "SELECT * FROM #__customgallery_customfields ORDER by ordering";
        $database->setQuery( $query );
        $custom_fields = $database->loadObjectList();
        //var_dump($custom_fields);
        $query = "SELECT * FROM #__customgallery_customfieldoptions";
        $database->setQuery( $query );
        $custom_field_options = $database->loadObjectList();
        //var_dump($custom_field_options);
        $lists['custom_filter_link'] = $filter_link;
        $lists['custom_filters'] = array();
        foreach( $custom_fields as $custom_field ) {
            if(!in_array($gallery->category_id, explode(',',$custom_field->categories)) || $custom_field->type == 1) continue;
            $filter_options = array();
            $filter_options[] = JHTML::_('select.option','',$custom_field->name,'value','text');
            foreach( $custom_field_options as $custom_field_option ) {
                if( $custom_field_option->field_id == $custom_field->id )
                    $filter_options[] = JHTML::_('select.option',$custom_field_option->value,$custom_field_option->text,'value','text');
            }
            //$new_link = $filter_link.'&customfilter['.$custom_field->id.']=';
            /*$lists['custom_filters'][] = JHTML::_(
                'select.genericlist', $filter_options, 'custom_filter'.$custom_field->id,'class="cg_customfilter" onchange="document.location=\''.$filter_link.
                '&amp;customfilter['.$custom_field->id.']=\'+this.options[this.selectedIndex].value;"','value','text', 
                isset($custom_filters[$custom_field->id]) ? $custom_filters[$custom_field->id] : ''
            );*/
            $lists['custom_filters'][] = JHTML::_('select.genericlist', $filter_options, 'customfilter['.$custom_field->id.']','class="cg_customfilter" onchange="this.form.submit();"','value','text', (isset($custom_filters[$custom_field->id])?$custom_filters[$custom_field->id]:'') );
            //$lists['custom_filters'][$custom_field->id]['label'] = $custom_field->name;
            
        }
        
        // Data for Gallery menu
        $query = "SELECT * FROM #__customgallery_galleries WHERE published = '1'";
        $database->setQuery( $query );
        $rows = $database->loadObjectList();
        if($cgConfig->show_gallery_menu) CustomGalleryFrontView::showGalleryMenu( $rows );
        
        CustomGalleryFrontView::showGallery( $gallery, $lists, $pagination );
    }
    
    function entry() {
        require_once ( JPATH_COMPONENT_ADMINISTRATOR.DS.'configuration.php' );

        $cgConfig = new cgConfig();
        $database = &JFactory::getDBO();
        $user     = &JFactory::getUser();
        $option   = JRequest::getCmd('option');
        $Itemid   = JRequest::getInt('Itemid');
        $entry_id = JRequest::getInt('id');

        JTable::addIncludePath(JPATH_COMPONENT_ADMINISTRATOR.DS.'tables');

        $entry = &JTable::getInstance('customGalleryEntry','Table');
        $entry->load($entry_id);

        $gallery = &JTable::getInstance('customGallery','Table');
        $gallery->load( $entry->gallery_id );

        $entry->gallery_name = $gallery->name;
        $database->setQuery("
            SELECT * FROM #__customgallery_customfields ORDER BY ordering
        ");
        $lists['fields'] = $database->loadObjectList();
        //var_dump($lists['fields']);
        $database->setQuery("
            SELECT * FROM #__customgallery_customfieldoptions
        ");
        $all_options = $database->loadObjectList();
        //var_dump($all_options);
        $database->setQuery("
            SELECT * FROM #__customgallery_customdata WHERE entry_id = ".$entry->id
        );
        $lists['data'] = $database->loadObjectList('field_id');
        //var_dump($lists['data']);
        $old_err = error_reporting(E_ALL ^ E_NOTICE);
        foreach( $lists['fields'] as $field ) {
            if(!in_array($entry->category_id, explode(',',$field->categories))) continue;
            switch( $field->type ) {
                case 1:
                    $query = 'SELECT value FROM #__customgallery_customdata WHERE field_id = '.$field->id.' AND entry_id = '.$entry->id.' LIMIT 1';
                break;
                case 2:
                    $query =
                        'SELECT text FROM #__customgallery_customfieldoptions WHERE field_id = '.$field->id.
                        ' AND value = '.$database->quote($lists['data'][$field->id]->value);
                break;
                case 3:
                    /*$query = "SELECT value FROM #__customgallery_customdata WHERE field_id = '{$field->id}' AND entry_id = '{$entry->id}' LIMIT 1";
                    $database->setQuery( $query );
                    $rs = $database->loadResult();*/
                    //var_dump($lists['data']);
                    $search_vals = "'".str_replace(',',"','",$lists['data'][$field->id]->value)."'";
                    
                    //$query = "SELECT text FROM #__customgallery_customfieldoptions WHERE field_id = '{$field->id}' AND value IN ({$lists['data'][$field->id]->value})";
                    //$query = "SELECT text FROM #__customgallery_customfieldoptions WHERE field_id = '{$field->id}' AND value IN (".explode(',',$rs).")";
                    //$query = "SELECT text FROM #__customgallery_customfieldoptions WHERE field_id = '{$field->id}' AND value = '{$lists['data'][$field->id]->value}'";
                    $query = 'SELECT text FROM #__customgallery_customfieldoptions WHERE field_id = '.$field->id.' AND value IN ('.$search_vals.')';
                break;
            }
            $database->setQuery( $query );
            if($field->type == 3) $lists['options'][$field->id] = $database->loadResultArray();
            else $lists['options'][$field->id] = $database->loadResult();
        }
        error_reporting($old_err);
        $link = 'index.php?option='.$option.'&task=entry&Itemid='.$Itemid.'&id=';
        $prev_id = $entry->getPrevId();
        $next_id = $entry->getNextId();
        $entry->previous_link = $prev_id?'<a href="'.JRoute::_($link.$entry->getPrevId()).'" >['.JText::_('Previous').']</a>':'['.JText::_('Previous').']';
        $entry->next_link = $next_id?'<a href="'.JRoute::_($link.$entry->getNextId()).'" >['.JText::_('Next').']</a>':'['.JText::_('Next').']';
        
        // Get rating info.
        if( $cgConfig->show_rating ) {
            if($cgConfig->show_vote) {
            
          /*  
            
    <li><a href="javascript:void(null)" onclick="javascript:cgAjaxVote(<?php echo $id ?>,1,<?php echo $rating_sum ?>,<?php echo $rating_count ?>);" title="1 <?php echo _JWAJAXVOTE_STAR; ?> 5" class="one-star">1</a></li>
    <li><a href="javascript:void(null)" onclick="javascript:cgAjaxVote(<?php echo $id ?>,2,<?php echo $rating_sum ?>,<?php echo $rating_count ?>);" title="2 <?php echo _JWAJAXVOTE_STARS; ?> 5" class="two-stars">2</a></li>
    <li><a href="javascript:void(null)" onclick="javascript:cgAjaxVote(<?php echo $id ?>,3,<?php echo $rating_sum ?>,<?php echo $rating_count ?>);" title="3 <?php echo _JWAJAXVOTE_STARS; ?> 5" class="three-stars">3</a></li>
    <li><a href="javascript:void(null)" onclick="javascript:cgAjaxVote(<?php echo $id ?>,4,<?php echo $rating_sum ?>,<?php echo $rating_count ?>);" title="4 <?php echo _JWAJAXVOTE_STARS; ?> 5" class="four-stars">4</a></li>
    <li><a href="javascript:void(null)" onclick="javascript:cgAjaxVote(<?php echo $id ?>,5,<?php echo $rating_sum ?>,<?php echo $rating_count ?>);" title="5 <?php echo _JWAJAXVOTE_STARS; ?> 5" class="five-stars">5</a></li>
  </ul>
  <div id="jwajaxvote<?php echo $id ?>" class="jwajaxvote-box">
    <?php 
        if($rating_count!=1) {
            echo "(".$rating_count." "._JWAJAXVOTE_VOTES.")";
        } else { 
            echo "(".$rating_count." "._JWAJAXVOTE_VOTE.")";
        }
    ?>
  </div>
</div>
<div class="jwajaxvote-clr"></div>*/
            
                $database->setQuery(
                    'SELECT rating FROM #__customgallery_ratings WHERE entry_id = '.$entry->id
                );
                $votes = $database->loadResultArray();
                if(count($votes)) {
                    //$rating = @number_format(array_sum($votes)/count($votes),2) * 5;
                    $rating_sum = array_sum($votes);
                    $rating_count = count($votes);
                                        
                    $rating = $rating_sum / $rating_count * 20;
                    
                    $lists['rating'] = '<div class="cg-inline-rating">';
                    $lists['rating'] .= '<ul class="cg-star-rating">';
                    $lists['rating'] .= '<li id="cg-rating-bg" class="current-rating" style="width:'.$rating.'%;"></li>';
                    
                    $mainURLText = 'index.php?option=com_customgallery&task=vote&id=';
                    
                    $lists['rating'] .= '<li><a href=" href="'.JRoute::_($mainURLText.$entry_id.'&v=1&Itemid='.$Itemid).'" title="'.JText::sprintf('STARS_OUT_OF', 1 ,5).'" class="one-star">1</a></li>';
                    $lists['rating'] .= '<li><a href="'.JRoute::_($mainURLText.$entry_id.'&v=1&Itemid='.$Itemid).'" title="'.JText::sprintf('STARS_OUT_OF', 2, 5).'" class="two-stars">2</a></li>';
                    $lists['rating'] .= '<li><a href="'.JRoute::_($mainURLText.$entry_id.'&v=1&Itemid='.$Itemid).'" title="'.JText::sprintf('STARS_OUT_OF', 3, 5).'" class="three-stars">3</a></li>';
                    $lists['rating'] .= '<li><a href="'.JRoute::_($mainURLText.$entry_id.'&v=1&Itemid='.$Itemid).'" title="'.JText::sprintf('STARS_OUT_OF', 4, 5).'" class="four-stars">4</a></li>';
                    $lists['rating'] .= '<li><a href="'.JRoute::_($mainURLText.$entry_id.'&v=1&Itemid='.$Itemid).'" title="'.JText::sprintf('STARS_OUT_OF', 5, 5).'" class="five-stars">5</a></li></ul>';
                    
                      $lists['rating'] .= '<div id="cgajaxvote" class="cg-box">('.$rating_count.'&nbsp;'.JText::_('Votes').')</div></div>';
                    
                 /*  $img_url = JURI::root() . 'components/com_customgallery/assets/star.gif';
                    $img_gray_url = JURI::root() . 'components/com_customgallery/assets/star.gif';
                    
                    for($i=0;$i<$rating;$i++) {
                        //$lists['rating'] .= '<img src="'.$img_url.'" width="25" height="25" style="background-position:0 0;">';
                        $lists['rating'] .= '<span class="rating_star"></span>';
                    }
                    for($i=$rating;$i<=4;$i++) {
                        $lists['rating'] .= '<span class="rating_star" style="background-position:0 0"></span>';
                    }
                    $lists['rating'] .= '( '.count($votes).' votes )';
                    $lists['rating'] .= '</div>';*/
                } else {
                    $lists['rating'] = '<div class="cg-no-rating">';
                    $lists['rating'] .= JText::_('Not yet rated');
                    $lists['rating'] .= '</div>';
                }
            }
        } else {
            $lists['rating'] = '';
        }
        $lists['comments'] = '';
        if($cgConfig->show_comments_form) {
            if( ($cgConfig->comment_allow && $user->id) || $cgConfig->comment_allow == 0 ) {
                // Get comments and create comment form.
                $disabled = $user->id?'disabled':'';
                $lists['comments'] = '<form action="'.JRoute::_('index.php').'" method="post" class="cg_commentform"><fieldset><legend>'.JText::_('Add comment').'</legend>';
                $lists['comments'] .= JText::_('Name').':<br /><input type="text" name="name" '.$disabled.' value="'.$user->username.'" /><br />';
                $lists['comments'] .= JText::_('Title').':<br /><input type="text" name="title" /><br />';
                $lists['comments'] .= JText::_('Comment').':<br /><textarea name="details" rows="2" cols="30" wrap="virtual"></textarea><br />';
                $lists['comments'] .= '<input type="submit" name="Submit" value="'.JText::_('Submit').'">';
                $lists['comments'] .= '<input type="hidden" name="id" value="'.$entry->id.'" />';
                $lists['comments'] .= '<input type="hidden" name="Itemid" value="'.$Itemid.'" />';
                $lists['comments'] .= '<input type="hidden" name="task" value="add_comment" />';
                $lists['comments'] .= '<input type="hidden" name="option" value="com_customgallery" />';
                $lists['comments'] .= '</fieldset></form><br />';
            }
        } else {
            $lists['comments'] = JText::_("REGISTER_COMMENT");
        }
        if($cgConfig->show_comments) {
            $database->setQuery(
                'SELECT * FROM #__customgallery_comments WHERE entry_id = '.$entry->id." AND published = '1'"
            );
            $comments = $database->loadObjectList();
            foreach( (array)$comments as $comment ) {
                //$lists['comments'] .= '<hr>';
                $lists['comments'] .= '<div class="cg_comment">';
                $lists['comments'] .= '<span class="comment_user">' . $comment->username . '</span>';
                $lists['comments'] .= '<span class="comment_title">' . $comment->title . '</span>';
                $lists['comments'] .= '<span class="comment_desc">' . $comment->details . '</span>';
                $lists['comments'] .= '</div>';
            }
        }
        
        // Get vote HTML.
        if( $cgConfig->show_vote ) {
            if( ($cgConfig->vote_allow && $user->id) || $cgConfig->vote_allow == 0 ) {
                /*$lists['vote'] = CustomGalleryFrontView::getVoteForm($entry->id, $Itemid);*/
            } else {
                $lists['vote'] = JText::_('REGISTER_VOTE');
            }
        } else {
            $lists['vote'] = '';
        }
        
        $lists['email_form'] = '
            <form id="email_form" name="email_form" action="index.php" method="post">
                <table>
                <tr><td>'.JText::_('Your Name').':</td><td><input name="from" value="" /></td></tr>
                <tr><td>'.JText::_('To').':</td><td><input name="to" value="" /></td></tr>
                <tr><td colspan="2">'.JText::_('Description').':</td></tr>
                <tr><td colspan="2"><textarea name="desc" rows="5" cols="40">'.$entry->name."\n".$entry->description."\n".'</textarea></td></tr>
                <tr><td align="left"><input type="submit" name="send" value="'.JText::_('Send').'" /></td>
                    <td align="right"><input type="button" name="close" value="'.JText::_('Cancel').'" onclick="javascript:toggleMailForm();"></td>
                </tr>
                </table>
                <input type="hidden" name="option" value="'.$option.'" />
                <input type="hidden" name="task" value="sendemail" />
                <input type="hidden" name="Itemid" value="'.$Itemid.'" />
                <input type="hidden" name="id" value="'.$entry->id.'" />
                '.JHTML::_('form.token').'
            </form>
        ';
        
        // Video link HTML
        include_once(JPATH_COMPONENT_ADMINISTRATOR . DS . 'helpers' . DS . 'videothumb.php');
        $v_thumb = new videothumb($entry);
        $lists['media'] = $v_thumb->getVideoHTML();
        /*if(!empty($entry->media_id)) {
            if($entry->media_type == 1) $lists['media'] = '<object width="425" height="344"><param name="movie" value="http://www.youtube.com/v/'.$entry->media_id.'&hl=en"></param><embed src="http://www.youtube.com/v/'.$entry->media_id.'&hl=en" type="application/x-shockwave-flash" width="425" height="344"></embed></object>';
            if($entry->media_type == 2) $lists['media'] = '<embed style="width:400px; height:326px;" id="VideoPlayback" type="application/x-shockwave-flash" src="http://video.google.com/googleplayer.swf?docId='.$entry->media_id.'&hl=en"></embed>';
        } else {
            $lists['media'] = '';
        }*/
        
        $database->setQuery(
            "SELECT * FROM #__customgallery_galleries WHERE published = '1'"
        );
        $rows = $database->loadObjectList();

        
        if($cgConfig->show_gallery_menu) CustomGalleryFrontView::showGalleryMenu( $rows );
        CustomGalleryFrontView::showEntry( $entry, $lists );
    }
    
    function addentry() {
        require_once JPATH_COMPONENT_ADMINISTRATOR.DS.'configuration.php';

        $mainframe   =& JFactory::getApplication();
        $cgConfig    =  new cgConfig();
        $user        =& JFactory::getUser();
        $gallery_id  =  JRequest::getInt('id');
        $category_id =  JRequest::getInt('cat');
        $option      =  JRequest::getCmd('option');
        $Itemid      =  JRequest::getInt('Itemid');
        $mainframe->set('joomlaJavascript', 1);
        
        if(!$gallery_id) $mainframe->redirect(JRoute::_("index.php?option=$option&Itemid=$Itemid"));
        if( $user->gid < 0 ) $mainframe->redirect(JRoute::_("index.php?option=$option&task=gallery&id=$gallery_id&Itemid=$Itemid"),"You do not have permission to add entries");
        $database = &JFactory::getDBO();
        JTable::addIncludePath(JPATH_COMPONENT_ADMINISTRATOR.DS.'tables');
        $entry = &JTable::getInstance('customGalleryEntry','Table');
        $entry_id = 0;
        
        // Load custom fields, values and options.
        $database->setQuery(
            'SELECT * FROM #__customgallery_customfields ORDER BY ordering'
        );
        $custom_fields = $database->loadObjectList();
        
        $database->setQuery(
            'SELECT * FROM #__customgallery_customfieldoptions'
        );
        $custom_field_options = $database->loadObjectList();
        
        $database->setQuery(
            'SELECT * FROM #__customgallery_customdata WHERE entry_id = '.$entry_id
        );
        $custom_data = $database->loadObjectList('field_id');
        $err_setting = error_reporting(E_ALL ^ E_NOTICE);
        $lists = array();
        $lists['custom_fields'] = array();
        foreach( $custom_fields as $custom_field ) {
            if(!in_array($category_id, explode(',',$custom_field->categories))) continue;
            switch($custom_field->type) {
                // Text input.
                case 1:
                    $data_id = str_pad($custom_data[$custom_field->id]->id,1,'0',STR_PAD_LEFT);
                    $lists['custom_fields'][$custom_field->id]['label'] = $custom_field->name;
                    $lists['custom_fields'][$custom_field->id]['html']  = 
                        '<input type="text" name="field_'.$custom_field->id.'_'.$data_id.'" value="'.$custom_data[$custom_field->id]->value.'" />';
                break;
                // Pull-down
                case 2:
                    $field_options = array();
                    $field_options[] = JHTML::_('select.option', '-1',JText::_('SELECT_OPTION'), 'value','text');
                    $option_array = array();
                    foreach( $custom_field_options as $cf ) {
                        if( $cf->field_id == $custom_field->id ) $option_array[] = $cf;
                    }
                    $field_options = array_merge( $field_options, $option_array );
                    $lists['custom_fields'][$custom_field->id]['label'] = $custom_field->name;
                    $lists['custom_fields'][$custom_field->id]['html'] = JHTML::_('select.genericlist', $field_options, 'field_'.$custom_field->id.'_'.str_pad($custom_data[$custom_field->id]->id,1,'0',STR_PAD_LEFT),'class="inputbox" size="1"','value','text',$custom_data[$custom_field->id]->value);
                break;
                
                case 3:
                    $field_options = array();
                    $field_options[] = JHTML::_('select.option', '-1',JText::_('SELECT_NONE'), 'value','text');
                    $option_array = array();
                    foreach( $custom_field_options as $cf ) {
                        if( $cf->field_id == $custom_field->id ) $option_array[] = $cf;
                    }
                    $field_options = array_merge( $field_options, $option_array );
                    $lists['custom_fields'][$custom_field->id]['label'] = $custom_field->name;
                    $lists['custom_fields'][$custom_field->id]['html'] = JHTML::_('select.genericlist', $field_options, 'field_'.$custom_field->id.'_'.str_pad($custom_data[$custom_field->id]->id,1,'0',STR_PAD_LEFT).'[]','class="inputbox" size="8" multiple="multiple"','value','text',explode(',',$custom_data[$custom_field->id]->value));
            }
        
        }
        
        error_reporting($err_setting);
        
        $lists['media'] = '<input type="text" name="media_id" size="64" value="" />';
        $media_options = array();
        $media_options[] = JHTML::_('select.option','0',JText::_('Image File'),'value','text');
        $media_options[] = JHTML::_('select.option','1',JText::_('YouTube'),'value','text');
        $media_options[] = JHTML::_('select.option','2',JText::_('Google Video'),'value','text');
        $lists['media'] .= '</td></tr><tr><td> '.JText::_('Media Type').':</td><td>'.JHTML::_('select.genericlist',  $media_options, 'media_type', 'class="inputbox" size="1"', 'value', 'text', 0);
        
        // Load categories.
        $categories = array();
        $categories[] = JHTML::_('select.option','-1',JText::_('SELECT_CATEGORY'),'value','text');
        $query = "SELECT id AS value, name AS text FROM #__customgallery_categories";
        $database->setQuery( $query );
        $cat_options = $database->loadObjectList();
        $categories = array_merge($categories, $cat_options);
        $lists['category'] = JHTML::_('select.genericlist',  $categories, 'category_id', 'class="inputbox" size="1"', 'value', 'text', $category_id );
        
        // Load galleries.
        $galleries = array();
        $galleries[] = JHTML::_('select.option','-1',JText::_('SELECT_GALLERY'),'value','text');
        $query = "SELECT id AS value, name AS text FROM #__customgallery_galleries";
        $database->setQuery( $query );
        $gal_options = $database->loadObjectList();
        $galleries = array_merge($galleries, $gal_options);
        //$lists['gallery'] = JHTML::_('select.genericlist',  $galleries, 'gallery_id', 'class="inputbox" size="1" readonly', 'value', 'text', $gallery_id);
        foreach( $galleries as $g ) if ($g->value == $gallery_id) $lists['gallery'] = $g->text . '<input type="hidden" name="gallery_id" value="'.$gallery_id.'" />';
        
        CustomGalleryFrontView::showEntryForm( $entry, $lists );
    }
    
    function save_entry() {

        // SpoofCheck
        JRequest::checkToken() or jexit( 'Invalid Token.');

        require_once JPATH_COMPONENT_ADMINISTRATOR.DS.'configuration.php';

        $cgConfig  =  new cgConfig();
        $mainframe =& JFactory::getApplication();
        $database  =& JFactory::getDBO();
        $user      =& JFactory::getUser();
        JTable::addIncludePath(JPATH_ADMINISTRATOR.DS.'components'.DS.'com_customgallery'.DS.'tables');
        $row       =& JTable::getInstance('customGalleryEntry','Table');
        $gallery   =& JTable::getInstance('customGallery','Table');
        $option    =  JRequest::getCmd('option');
        $Itemid    =  JRequest::getInt('Itemid');
        $entry_id  = 0;
        //var_dump($_POST);exit();
        // Uncomment this to make all custom fields required.
        /*foreach($_POST as $key => $value) {
            if(substr($key,0,5) == 'field') {
                if(empty($value)) {
                    list($t,$field_id,$data_id) = explode('_',$key,3);
                    $field_id = intval($field_id);
                    $query = "SELECT name FROM #__customgallery_customfields WHERE id = $field_id LIMIT 1";
                    $database->setQuery( $query );
                    $field_name = $database->loadResult();
                    $mainframe->redirect(JRoute::_('index.php?option='.$option.'&Itemid='.$Itemid), JText::sprintf('Entry NOT saved', $field_name));
                }
            }
        }*/
        
        $gallery_id = JRequest::getInt('gallery_id',0);
        $gallery->load( $gallery_id );
        //var_dump($gallery);exit();
        if(!$gallery->published) $mainframe->redirect(JRoute::_('index.php?option='.$option.'&Itemid='.$Itemid), 'That gallery is not available');
        if(!$cgConfig->frontend_upload) $mainframe->redirect(JRoute::_('index.php?option='.$option.'&Itemid='.$Itemid), 'Uploading has been disabled.');
        if(!in_array($user->gid, explode(',', $cgConfig->fe_upload_allow))) $mainframe->redirect(JRoute::_('index.php?option='.$option.'&Itemid='.$Itemid), JText::_('NO_PERMISSION'));
        // TODO: Check user permissions, gallery published/permissions, etc.
        
        $file = JRequest::getVar( 'filename', '', 'files', 'array' );
        jimport('joomla.filesystem.file');
        $file['name']    = str_replace(' ','_',JFile::makeSafe($file['name']));
        
        if (!empty($file['name'])) {
            $dest_dir = JPATH_ROOT.DS.'media'.DS.'customgallery'.DS.$gallery_id;
            if(!is_dir($dest_dir)) {
                if(!mkdir($dest_dir,0755,true)) {
                    $mainframe->redirect(JRoute::_('index.php?option=com_customgallery&task=gallery&id='.$gallery_id), JText::_('FILE_NOT_SAVED_IMAGE_FOLDER'));
                }
            }
            $filepath = JPath::clean($dest_dir.DS.strtolower($file['name']));
            $thumb_filepath = JPath::clean($dest_dir.DS.strtolower('thumb_'.$file['name']));
            if (JFile::exists($filepath)) {
                // TODO: Make file overwrite a config option.
                $file['name'] = time().$file['name'];
                $filepath = JPath::clean($dest_dir.DS.strtolower($file['name']));
                $thumb_filepath = JPath::clean($dest_dir.DS.strtolower('thumb_'.$file['name']));
                /*if(true) {
                    @unlink($filepath);
                    @unlink($thumb_filepath);
                } else {
                    JError::raiseNotice(100, JText::_('Error. File already exists'));
                    $mainframe->redirect(JRoute::_('index.php?option=com_customgallery&task=gallery&id='.$gallery_id), JText::_('FILE_NOT_SAVED_IMAGE_EXISTS'));
                }*/
            }
            if (!JFile::upload($file['tmp_name'], $filepath)) {
                JError::raiseWarning(100, JText::_('Error. Unable to upload file'));
                $mainframe->redirect(JRoute::_('index.php?option=com_customgallery&task=gallery&id='.$gallery_id), JText::_('FILE_NOT_SAVED_UPLOAD'));
            } else {
                $row->filename = strtolower($file['name']);
                // Create thumbnail.
                include_once(JPATH_COMPONENT_ADMINISTRATOR . DS . 'helpers' . DS . 'resize.php');
                $thumb = new thumbnail($filepath);
                $thumb->size_width(160);
                //if(file_exists($thumb_filepath)) @unlink($thumb_filepath);
                $thumb->save($thumb_filepath);
            }
        }
        
        if (!$row->bind(JRequest::get('post'))) {
            JError::raiseError( 500, $db->stderr() );
            return false;
        }
        
        
        
        $row->published = $cgConfig->approve_entries?0:1;
        $row->category_id = $gallery->category_id;
        $row->create_date = isset($row->create_date)?$row->create_date:date("Y-m-d H:i:s");
        
        if (!$row->check()) {
            JError::raiseError( 500, $db->stderr() );
            return false;
        }
        if (!$row->store()) {
            JError::raiseError( 500, $db->stderr() );
            return false;
        }
        $custom_data_query = array();
        foreach($_POST as $key => $value) {
            if(substr($key,0,5) == 'field') {
                list($t,$field_id,$data_id) = explode('_',$key,3);
                $field_id = intval($field_id);
                $data_id = intval($data_id);
                if(is_array($value)) $value = implode(',', $value);
                
                $value = $database->quote( $value );
                
                $custom_data_query[] = "($data_id,$row->id,$field_id,$value)";
            }
        }
        $query = "INSERT INTO #__customgallery_customdata (id,entry_id,field_id,value) VALUES ";
        $query .= implode(',', $custom_data_query);
        $database->setQuery( $query );
        $database->query();
        
        $mainframe->redirect(JRoute::_('index.php?option='.$option.'&task=gallery&id='.$gallery_id.'&Itemid='.$Itemid), JText::_('Picture saved'));
    }
    
    function cancel_entry() {
        $mainframe  =& JFactory::getApplication();
        $gallery_id =  JRequest::getInt('gallery_id');
        $option     =  JRequest::getCmd('option');
        $Itemid     =  JRequest::getInt('Itemid');
        $mainframe->redirect(JRoute::_('index.php?option='.$option.'&task=gallery&id='.$gallery_id.'&Itemid='.$Itemid), JText::_('Cancelled'));
    }
    
    function vote() {

        require_once JPATH_COMPONENT_ADMINISTRATOR.DS.'configuration.php';

        $cgConfig   = new cgConfig();
        $mainframe  =& JFactory::getApplication();
        $user       =& JFactory::getUser();
        $database   =& JFactory::getDBO();
        $Itemid     =  JRequest::getInt('Itemid');
        $entry_id   =  JRequest::getInt('id');
        $vote       =  JRequest::getInt('v');
        $visitor_ip = $_SERVER['REMOTE_ADDR'];
        
        
        // TODO: check entry status/permissions.
        if( !(($cgConfig->vote_allow && $user->id) || $cgConfig->vote_allow == 0) ) $mainframe->redirect('index.php?option=com_customgallery&task=entry&id='.$entry_id.'&Itemid='.$Itemid, 'You are not allowed to vote.');
        $query = "SELECT id FROM #__customgallery_ratings WHERE ip_address = '$visitor_ip' AND entry_id = '$entry_id' LIMIT 1";
        $database->setQuery( $query );
        $exists = $database->loadResult();
        if(!$exists) {
            $query = "INSERT INTO #__customgallery_ratings (id,entry_id,ip_address,rating) VALUES (0,'$entry_id','$visitor_ip',$vote)";
            $database->setQuery( $query );
            $database->query();
            $msg = JText::_('VOTING_THANKS');
        } else {
            $msg = JText::_('VOTING_ONCE');
        }
        
        $mainframe->redirect(JRoute::_('index.php?option=com_customgallery&task=entry&id='.$entry_id.'&Itemid='.$Itemid), $msg);
    }
    
    function add_comment() {

        // SpoofCheck
        JRequest::checkToken() or jexit( 'Invalid Token.');

        require_once JPATH_COMPONENT_ADMINISTRATOR.DS.'configuration.php';

        $cgConfig  =  new cgConfig();
        $mainframe =& JFactory::getApplication();
        $user      =& JFactory::getUser();
        $Itemid    =  JRequest::getInt('Itemid');

        if( ($cgConfig->comment_allow && $user->id) || $cgConfig->comment_allow == 0) {
            
            $database = &JFactory::getDBO();
            JTable::addIncludePath(JPATH_ADMINISTRATOR.DS.'components'.DS.'com_customgallery'.DS.'tables');
            $entry = &JTable::getInstance('customGalleryEntry','Table');
            $Itemid = JRequest::getInt('Itemid');
            $comment_ip = $_SERVER['REMOTE_ADDR'];
            $comment_name = $user->id? $user->username : JRequest::getVar('name');
            
            $comment_entry = JRequest::getInt('id');
            $entry->load($comment_entry);
            $comment_title = JRequest::getVar('title');
            $comment_details = JRequest::getVar('details');
            $comment_published = $cgConfig->approve_comments?0:1;
            $query = "INSERT INTO #__customgallery_comments (id,entry_id,username,title,details,ip_address,published) VALUES (0,{$entry->id},'$comment_name','$comment_title','$comment_details','$comment_ip','$comment_published')";
            $database->setQuery( $query );
            $database->query();
            $mainframe->redirect(
                JRoute::_('index.php?option=com_customgallery&task=entry&id='.$entry->id.'&Itemid='.$Itemid),
                JText::_('COMMENT_THANKS').$cgConfig->approve_comments ? ' '.JText::_('COMMENT_APPROVAL') : ''
            );
        } else {
            $mainframe->redirect(
                JRoute::_('index.php?option=com_customgallery&task=entry&id='.$entry->id.'&Itemid='.$Itemid), JText::_('COMMENT_DISABLED')
            );
        }
    }
    
    function sendemail() {

        // SpoofCheck
        JRequest::checkToken() or jexit( 'Invalid Token.');

        $mainframe    =& JFactory::getApplication();
        $option       =  JRequest::getCmd('option','com_customgallery');
        $Itemid       =  JRequest::getInt('Itemid');
        $id           =  JRequest::getInt('id');
        $fromname     =  JRequest::getCmd('from',$mainframe->getCfg('fromname'));
        $fromemail    =  $mainframe->getCfg('mailfrom');
        $message_body =  JRequest::getString('desc','');
        $message_body =  JText::_('Message from').' : '.$fromname."\n\n".$message_body;
        $recipient    =  strtolower(JRequest::getString('to',''));

        // !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
        // !!! uwalter: NO SPAM PLEASE, hence we delete anything after the first !!!
        // !!!          email address, especially new lines that are often used  !!!
        // !!!          by spam bots in order to append hundreds of email        !!!
        // !!!          addresses.                                               !!!
        // !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
        // For allowed characters see RFC's 3696, 5321, 5322 
        $recipient = preg_replace('/^((?:[a-z0-9\.!#\&\$%\'*+\-\/=?\^_`{|}~]+\.?)+@(?:[a-z0-9-]+\.)+\.?[a-z0-9-]{2,4})'."[;:,\.\s\n]?".'.*$/', '$1', $recipient);

        /* !!! THIS IS A SPAMMING LEAK !!!
           !!! ONLY FYI :: Dan, you can delete this code !!!
        if( strpos($recipient,',') !== false ) {
            $recipients = explode(',',$recipient);
        } else if( strpos($recipient,';') !== false ) {
            $recipients = explode(';',$recipient);
        } else {
            $recipients = array($recipient);
        }
        */
        
        $mailer = &JFactory::getMailer();
        // Build e-mail message format
        $mailer->setSender(array( $fromemail, $fromname ));
        $mailer->setSubject(JText::_('Link from').':'.JURI::root());
        $mailer->setBody($message_body);
        //$mailer->IsHTML($mode);
        $mailer->addRecipient($recipient);

        // Add recipients <= already done !!!

        // And this one too!
        //foreach( $recipients as $rec ) {
            //if(!preg_match('/^[_A-z0-9-]+((\.|\+)[_A-z0-9-]+)*@[A-z0-9-]+(\.[A-z0-9-]+)*(\.[A-z]{2,4})$/',$rec))
                //continue;
            //else
                //if(!empty($rec)) $mailer->addRecipient($rec);
        //}

        // Send the Mail
        $rs = $mailer->Send();
        
        // Check for an error
        if ( JError::isError($rs) ) {
            $msg = $rs->getError();
        } else {
            $msg = $rs ? JText::_( 'EMAIL_SENT' ) : JText::_('EMAIL_NOT_SENT');
        }

        // Redirect with the message
        $mainframe->redirect( JRoute::_('index.php?option='.$option.'&task=entry&id='.$id.'&Itemid='.$Itemid), $msg );
    }
    /**
     * Method to display the view
     *
     * @access    public
     */
    function display()
    {
        parent::display();
    }

}
