<?php
defined( '_JEXEC' ) or die( 'Restricted access' );

jimport('joomla.application.component.controller');

class NinjamonialsControllerTestimonials extends JController
{
	function add()
	{
		
	//Get our component parameters
		$paramsObj = JComponentHelper::getParams( 'com_ninjamonials' );
		
	//If show_add is set to NO redirect to the display view
		if 	(!$paramsObj->get('show_add'))
		{
			if ($paramsObj->get('show_all'))
			{
			//if show_add is NO but show_all is YES then redirect to the display view
				JRequest::setVar('view', 'display');
			} else {
			//If both show_add and show_all are set to NO, redirect to the home page
				$this->setRedirect('index.php');
				$this->redirect();				
			}
		} else {
			JRequest::setVar('view', 'add');
		}

		$this->display();
		
	}

	function save()
	{
		
		JRequest::checkToken() or jexit( 'Invalid Token' );
		
		$mainframe = JFactory::getApplication();
 
 $mainframe->getUserStateFromRequest( "$option.state_variable", 'state_variable', 'state1' );

 
    // store the current field data so we can post it back to the page if needed  (e.g. file or recaptcha error)
    $mainframe->getUserStateFromRequest( "com_ninjamonials.testimonial", 'testimonial' );
    $mainframe->getUserStateFromRequest( "com_ninjamonials.summary", 'summary' );
    $mainframe->getUserStateFromRequest( "com_ninjamonials.author_name", 'author_name' );
    $mainframe->getUserStateFromRequest( "com_ninjamonials.author_title", 'author_title' );
    $mainframe->getUserStateFromRequest( "com_ninjamonials.author_location", 'author_location' );
    $mainframe->getUserStateFromRequest( "com_ninjamonials.author_email", 'author_email' );
    $mainframe->getUserStateFromRequest( "com_ninjamonials.website_text", 'website_text' );
    $mainframe->getUserStateFromRequest( "com_ninjamonials.website_url", 'website_url' );
    		
	//Almost all of our redirects will use the same path so to make things more readable
	//and increase maintainability lets put it in a variable isntead of writing it every time	
		$redirectPath = 'index.php?option=com_ninjamonials&task=add&controller=testimonials';
	
		
	//Get our component parameters
		$paramsObj = JComponentHelper::getParams( 'com_ninjamonials' );
			
	//load and check the captcha value
		if ($paramsObj->get('use_captcha')) {

		//load the recaptcha helper if captcha is requested
			require_once(JPATH_COMPONENT.DS.'helpers'.DS.'recaptchalib.php');
			
			$resp = recaptcha_check_answer ($paramsObj->get('recaptcha_priv_key'),
			                                $_SERVER["REMOTE_ADDR"],
			                                JRequest::getCmd( 'recaptcha_challenge_field', '', 'post'),
			                                JRequest::getCmd( 'recaptcha_response_field', '', 'post'));
			
			if (!$resp->is_valid) {
			
        
      //there was an error in the recaptcha       
				$this->setRedirect($redirectPath, JText::_('The reCAPTCHA wasnt entered correctly:').' '. $resp->error);
				$this->redirect();
			
			}
		}
		
		global $option;
		global $mainframe;
		$db = JFactory::getDBO();

		$row = JTable::getInstance('Ninjamonials', 'Table');

		if (!$row->bind(JRequest::get('post'))) 
		{
			JError::raiseError(500, $row->getError() );
		}
		
		$row->testimonial = $db->getEscaped($row->testimonial);
		$row->summary = $db->getEscaped($row->summary);
		$row->author_id = $db->getEscaped($row->author_id);
		$row->author_name = $db->getEscaped($row->author_name);
		$row->author_title = $db->getEscaped($row->author_title);
		$row->author_location = $db->getEscaped($row->author_location);
		$row->author_email = $db->getEscaped($row->author_email);
		$row->website_text = $db->getEscaped($row->website_text);
		
		//clear the url if it jsut has the default http:// in it
		if ($row->website_url == 'http://') {
			$row->website_url = '';
		} else {
			$row->website_url = $db->getEscaped($row->website_url);
		}
		
		$row->viewed = $db->getEscaped($row->viewed);
		$row->createdate = date( 'Y-m-d H:i:s');
	
	// first let's set some variables		
	// make a note of the directory that will recieve the uploaded file
		$uploadsDirectory = JPATH_SITE.'/media/com_ninjamonials/uploadedmedia/';
		
	//we will always have 1-3 files, with the same <input> tag names so do the same loop 3 times
		for ($i=0, $n=3; $i < $n; $i++) 
		{
		
		//if our delete file checkboxes are checked, or we are uploading a new file, remove the existing file
			if (
				($i==0 && (array_key_exists('avatar_file',$_FILES)) && $_FILES['avatar_file']['name']  )||
				($i==1 && (array_key_exists('audio_file', $_FILES)) && $_FILES['audio_file']['name']   )||
				($i==2 && (array_key_exists('video_file', $_FILES)) && $_FILES['video_file']['name']   )

			   )
			{
			//to prevent duplicate file names, and also orphaned files, we will have fixed names for the files
			//and include the testimonial id to make them unique and traceable
			//the file suffix will be inherited from the filetype uploaded
				switch ($i) 
				{
					case 0:
					//fieldName is used to determine which field from the post to get
						$fieldName = 'avatar_file';
					//the file extensions acceptable for this file type
						$validExtns= array ('.jpg', '.gif', '.png');
					//set an error message to go with the file types
						$extnError= JText::_('Only image files allowed');
						break;					
					case 1:
						$fieldName = 'audio_file';
						$validExtns= array ('.mp3');
						$extnError= JText::_('Only audio files allowed');
						break;				
					case 2:
						$fieldName = 'video_file';
						$validExtns= array ('.swf', '.avi', '.flv', '.mov', '.mpg', '.qt', '.wmv');
						$extnError= JText::_('Only video files allowed');
						break;
				}
			// Now let's deal with the upload
				
			// check the upload form was actually submitted else print the form
				if (!isset($_POST['submit'])){
					$this->setRedirect($redirectPath, JText::_('Please Submit Form'));
					//echo '1';
					//exit;
					$this->redirect();
				}
			// possible PHP upload errors
				$errors = array(1 => JText::_('PHP ini max file size exceeded'),
								2 => JText::_('HTML form max file size exceeded'),
								3 => JText::_('File upload was only partial'),
								4 => JText::_('No file was attached')); 
				
			// check for PHP's built-in uploading errors
				if (!($_FILES[$fieldName]['error'] == 0)){
					$this->setRedirect($redirectPath, $errors[$_FILES[$fieldName]['error']]);
					//echo '2';
					//exit;
					$this->redirect();
				}
				
			// check that the file we are working on really was the subject of an HTTP upload
				$tmp_file_path = $_FILES[$fieldName]['tmp_name'];
				if (!(@is_uploaded_file($tmp_file_path))){
					$this->setRedirect($redirectPath, JText::_('Not an HTTP upload'));
					//echo '3';
					//exit;
					$this->redirect();
				}
				
			// Do some filename cleaning.
			//first get our helper file with some functions in it
				require_once(JPATH_COMPONENT_ADMINISTRATOR.DS.'helpers'.DS.'file_helpers.php');
				$tmp_file_name = cleanFileName( $_FILES[$fieldName]['name'] );
				
			// validation... since we only need specific types of files
			// we should run a check to prevent wrong file types from being uploaded
				$file_ext      = substr($tmp_file_name, strripos($tmp_file_name, '.'));	
				
				
				$timestamp = date("YmdHis");
				//$newName = $timestamp.$file_ext; //.$realFileName;
				$newName = $timestamp.'_'.$tmp_file_name;

			
			//compare our file's extension with our array of allowed extensions
				if (!in_array($file_ext, $validExtns )){
					$this->setRedirect($redirectPath,$extnError);
					//echo '4';
					//exit;
					$this->redirect();
				}
				
			//check that we don't already have a file with the same name
				if (file_exists($uploadsDirectory.DS.basename($tmp_file_name)))
				{
					
				//delete the existing file so we can upload the new one
					if (!unlink($uploadsDirectory.DS.basename($tmp_file_name)))
					{
						$this->setRedirect($redirectPath, JText::_('Error deleting file').': '.'. '.JText::_('Operation aborted'));
						echo '5';
						exit;
						
						$this->redirect();
					}
				}
				
			//is the dir writable??
				if ( !is_writable( $uploadsDirectory ) ) {
					$this->setRedirect($redirectPath, JText::_('Upload permission error Please check the permissions on the uploads directory'));
					echo '6';
					exit;
					$this->redirect();
				}
						
			// now let's move the file to its final location and allocate the new filename to it
				$target_path = $uploadsDirectory.DS.$newName; 
		
				if(move_uploaded_file($_FILES[$fieldName]['tmp_name'], $target_path)) {
					$this->setRedirect($redirectPath, JText::_('File').' '.$tmp_file_name.' '.JText::_('has been uploaded successfully'));
				} else{
					echo '7';
					exit;
					$this->setRedirect($redirectPath, JText::_('There was an error uploading the file').' '.$tmp_file_name.JText::_('please try again'));
				}
				
				$row->$fieldName = $newName;


			}//end delete file checkboxes
		}//end file processing loop
		
		if ($paramsObj->get('auto_publish')) {
			$row->published = 1;
		} 
		else
		{
			$row->published = 0;
		}
		
		//If needed, trigger content plugins on the feed as a whole.
		//used to trigger content plugins below
		JPluginHelper::importPlugin( 'ninjamonials' );
		$dispatcher = JDispatcher::getInstance();
		$dispatcher->trigger( 'beforeSaveTestimonial', array( &$row, &$paramsObj ) );
		
		if (!$row->store()) 
		{
			JError::raiseError(500, $row->getError() );
		}
				
	//send a notification email if requested
		if ($paramsObj->get('send_email')){	
			
		//prepare the body of our notification mail; list all the fields with values
			$bodytext ='';
			
			if($row->avatar_file != '' )
	    	{
	    		$bodytext.= JText::_('Avatar File').': '.$row->audio_file."\n";
	    	}	
	    	if($row->author_name != '')
	    	{
	    		$bodytext.= JText::_('Author Name').': '.$row->author_name."\n";
	    	}
	    	if($row->author_title != '')
	    	{
	    		$bodytext.= JText::_('Author Title').': '.$row->author_title."\n";	
	    	}    	
	    	if($row->author_location != '')
	    	{
	    		$bodytext.= JText::_('Author Location').': '.$row->author_location."\n";
	    	}	    	
	    	if ($row->website_text != '')
			{
				$bodytext.= JText::_('Website Text').': '.$row->website_text."\n";
			}
			if($row->website_url != '')
	    	{
	    		$bodytext.= JText::_('Website URL').': '.$row->website_url."\n";	
	    	}	    	    	
			if($row->summary != '')
			{ 
				$bodytext.= JText::_('Summary Text').': '.$row->summary."\n"; 
			} 
			if($row->testimonial != '' )
			{ 
				$bodytext.= JText::_('Testimonial Text').': '.$row->testimonial."\n";
			} 
	    	if($row->video_file != '')
	    	{
	    		$bodytext.= JText::_('Video File').': '.$row->video_file."\n";
	    		 
	    	} 
	    	if($row->audio_file != '')
	    	{
	    		$bodytext.= JText::_('Audio File').': '.$row->audio_file."\n";
	    		 
	    	}  
	    	
	    //add to the body text a link to the new item
	    
	    	$lastId = JDatabase::insertid();
	    
	    	$viewPath = JURI::base().'administrator/index.php?option=com_ninjamonials&controller=testimonials&task=edit&cid='.$row->id;
	    	$publishPath = JURI::base().'administrator/index.php?option=com_ninjamonials&controller=testimonials&task=publish&cid='.$row->id;
	    	$unPublishPath = JURI::base().'administrator/index.php?option=com_ninjamonials&controller=testimonials&task=unpublish&cid='.$row->id;
	    	
	    	$bodytext.= "\n".JText::_('View this testimonial')."\n".$viewPath;
	    	
	    	//only include the publish link if auto publish is off
	    	if (!$paramsObj->get('auto_publish')) {
				$bodytext.= "\n".JText::_('Publish this testimonial')."\n".$publishPath;
			} else {
				$bodytext.= "\n".JText::_('Testimonial has been auto-published, unpublish it?')."\n".$publishPath;
			}
	    	
	    				
		//send an email to the saved addresses
			$siteName = $mainframe->getCfg('sitename');
	
		//put the email addresses into an array which we will pass to the mail->Send function
			$email = explode(',',$paramsObj->get('email_addresses'));
			
			
		//Put the site name and person's name into the subject of the emails for people with multiple sites.
			$subject = JText::_('A new testimonial has been added to the site').': '.$siteName.' '.JText::_('by').': '.$row->author_name ;
		
		//get our mail from information from the site config
			$MailFrom = $mainframe->getCfg('mailfrom');
			$FromName = $mainframe->getCfg('fromname');
		
		//if our email is blank, then use the default from email 	
			if (!$email) {
				$email = $MailFrom;
			}
			
	
		//If there is not at least 1 valid email address or message body then we throw an
		//error and return false.	
			jimport('joomla.mail.helper');
			if (!$email || !$bodytext) // || (JMailHelper::isEmailAddress($email[0]) == false))
			{
				$this->setError(JText::_('Testimonial Email Error'));
				$this->setRedirect($redirectPath, JText::_('Email Error'));
				return false;
			}
					
			$mail = JFactory::getMailer();
			
			$mail->addRecipient( $email );
			$mail->setSender( array( $MailFrom, $FromName ) );
			$mail->setSubject( $subject );
			$mail->setBody( $bodytext );
			
			$sent = $mail->Send();
		}//end of if ($this->send_email)	
		
		$redirectMessage = JText::_('Testimonial Saved');
		
		if ($paramsObj->get('do_redirect') && $paramsObj->get('redirect_url'))
			$redirectPath = $paramsObj->get('redirect_url');
			
		if ($paramsObj->get('custom_thanks') == 1)
			$redirectMessage = '';
		
		if ($paramsObj->get('custom_thanks') == 2 && $paramsObj->get('custom_thanks_msg'))
			$redirectMessage = $paramsObj->get('custom_thanks_msg');
		
		$this->setRedirect($redirectPath, $redirectMessage);
		
	}
			
	function display()
	{
		$view	=  JRequest::getVar('view');
		
		if (!$view) {
		//our view is named 'display'
			JRequest::setVar('view', 'display');
		}		
		
	//Get our component parameters
		$paramsObj = JComponentHelper::getParams( 'com_ninjamonials' );
		
	//If show_all is set to NO, redirect to the add view
		if 	(!$paramsObj->get('show_all'))
		{
			if ($paramsObj->get('show_add'))
			{
			//if show_all is NO but show_add is YES then redirect to the add view
				JRequest::setVar('view', 'add');
			} else {
			//If both show_add and show_all are set to NO, redirect to the home page
				$this->setRedirect('index.php');
				$this->redirect();				
			}
		}
			
		parent::display();
	}
	
}

?>
