<?php 
defined( '_JEXEC' ) or die( 'Restricted access' );

jimport( 'joomla.application.component.view');

class NinjamonialsViewDisplay extends JView
{
	function display($tpl = null)
	{

	//we use the filtering functions on our urls below
		jimport('joomla.filter.output');
		
		$option = JRequest::getCmd('option');
		$Itemid = JRequest::getInt( 'Itemid', '');
		$this->assignRef('Itemid', $Itemid);

	//Get our component parameters
		$paramsObj = JComponentHelper::getParams( 'com_ninjamonials' );
		$this->assignRef('paramsObj', $paramsObj);
		
	//get our model manually because we are doing some non-ordinary things with it	
		$model	= $this->getModel();		
	
	//This is used to store our generated select lists	
		$lists = array();		
	
	//we want to know if categories are enabled
		$this->assignRef('enable_categories', $paramsObj->get('enable_categories'));
		
		$catDispStyle =  $paramsObj->get('cat_display_style');
		$this->assignRef('cat_display_style',$catDispStyle);
		
		$catToDisp = $paramsObj->get('cat_to_display');
		$this->assignRef('cat_to_display', $catToDisp);
		
		$show_cat = $paramsObj->get('show_cat');
		$this->assignRef('show_cat', $show_cat);
	
	//TODO - search the url for a new cat id then replace $catToDisp with it
		$getCat = JRequest::getInt('category_id');
	
	//only build the list for options 1 and 3 for display style
		if ($catDispStyle == 1 || ($catDispStyle == 3 && $getCat !== null))
		{
			$lists['catlist'] = $model->getCatList();
		} elseif ($catDispStyle == 3 && $getCat === null) 
		{
		//we need to pass in the default category for option 3 so our drop down list matches the content of the page
			$lists['catlist'] = $model->getCatList($catToDisp);
		}
	
	//the $lists variable is just a generic variable for holding lists.
		$this->assignRef('lists',$lists);
		
	//if we have selected options 2 or 3 for display style, or option 1 and we have selected a category from the list, then we need to limit it to only 1 category
		if ($catDispStyle == 2 || $catDispStyle == 3 || ($catDispStyle == 1 && $getCat))
		{
			$model->setCategory($catToDisp);			
		} else {
			$model->setCategory(null);
		}						

	//get the testimonial id from the request if present
		$tmid = JRequest::getInt('tmid', '');
		$this->assignRef('tmid', $tmid );	
		
		$rows = $model->getData();
		
		$pagination = $model->getPagination();
		
		//If needed, trigger content plugins on the feed as a whole.
		//used to trigger content plugins below
		JPluginHelper::importPlugin( 'ninjamonials' );
		$dispatcher = JDispatcher::getInstance();
		$dispatcher->trigger( 'onPrepareTestimonialsDisplay', array( &$rows, &$paramsObj ) );
		
		$this->assignRef('rows', $rows);
		$this->assignRef('pagination', $pagination);

	//if categories are enabled, include the category in the add link
		if ($paramsObj->get('enable_categories')){
			$catParam='&category_id='.$model->getCategory();
		} else {
			$catParam = '';
		}

		$showAllLink = JRoute::_(JFilterOutput::ampReplace('index.php?option=com_ninjamonials&controller=testimonials&task=display&Itemid='.$Itemid));
		$this->assignRef('showAllLink', $showAllLink);

		$addLink = JRoute::_(JFilterOutput::ampReplace('index.php?option=com_ninjamonials&controller=testimonials&task=add&Itemid='.$Itemid.$catParam));
		$this->assignRef('addLink', $addLink);	

		$this->assignRef('rows', $rows);
		
	//if needed, load and configure our bbcode parser
		if ($paramsObj->get('enable_bbcode'))
		{		
		//load our BBcode parser - Dan: This probably shouldn't be in the controller but I can't think of a better place for it
			if(!class_exists('StringParser_BBCode'))
        require_once(JPATH_COMPONENT.DS.'helpers'.DS.'stringparser_bbcode.class.php');
			$bbcode = new StringParser_BBCode();
			
			//Initialise the settings
			// Unify line breaks of different operating systems
			function convertlinebreaks ($text) {
			    $text = preg_replace ("/\015\012|\015|\012/", "\n", $text);
				$text = str_replace ("\r\n", "\n", $text);
				$text = str_replace ('\r\n', "\n", $text);
				$text = str_replace ("<br/>", "\n", $text);
				$text = str_replace ("<br />", "\n", $text);
				return str_replace ("<br>", "\n", $text);
			}
			
			// Remove everything but the newline charachter
			function bbcode_stripcontents ($text) {
			    return preg_replace ("/[^\n]/", '', $text);
			}
			
			function do_bbcode_url ($action, $attributes, $content, $params, $node_object) {
			    if (!isset ($attributes['default'])) {
			        $url = $content;
			        $text = htmlspecialchars ($content);
			    } else {
			        $url = $attributes['default'];
			        $text = $content;
			    }
			    if ($action == 'validate') {
			        if (substr ($url, 0, 5) == 'data:' || substr ($url, 0, 5) == 'file:'
			          || substr ($url, 0, 11) == 'javascript:' || substr ($url, 0, 4) == 'jar:') {
			            return false;
			        }
			        return true;
			    }
			    return '<a href="'.htmlspecialchars ($url).'">'.$text.'</a>';
			}
			
			// Function to include images
			function do_bbcode_img ($action, $attributes, $content, $params, $node_object) {
			    if ($action == 'validate') {
			        if (substr ($content, 0, 5) == 'data:' || substr ($content, 0, 5) == 'file:'
			          || substr ($content, 0, 11) == 'javascript:' || substr ($content, 0, 4) == 'jar:'
					  || substr ($content, -4) == '.php') {
			            return false;
			        }
			        return true;
			    }
			    return '<img src="'.htmlspecialchars($content).'" alt="">';
			}
			
			function do_bbcode_color ($action, $attributes, $content, $params, $node_object) {
			    //the default attribute is one after the bbtag itself [color=blah]text[/color]
				if (isset ($attributes['default']))
					return '<span style="color:'.$attributes['default'].'">'.$content.'</span>';

				return $content;
			    
			}
			
			function do_bbcode_quote ($action, $attributes, $content, $params, $node_object) {
			   if (!isset ($attributes['default'])) {
			        $whoSaid = '';
			    } else {			    	
			        $whoSaid = '<span class="nmWhoSaid">'.JText::sprintf('NM_WHOSAID', $attributes['default']).'</span>';
			    }
				
				 return '<blockquote class="nmQuote"><span>'.$whoSaid.$content.'</span></blockquote>';
			}
			
			function do_bbcode_size ($action, $attributes, $content, $params, $node_object) {
			   
				if (isset ($attributes['default'])) 
			       return '<span style="font-size:'.$attributes['default'].'%">'.$content.'</span>';

				return $content;
			}
			
			$bbcode->addFilter (1, 'convertlinebreaks');
			
			$bbcode->addParser (array ('block', 'inline', 'link', 'listitem'), 'htmlspecialchars');
			$bbcode->addParser (array ('block', 'inline', 'link', 'listitem'), 'nl2br');
			$bbcode->addParser ('list', 'bbcode_stripcontents');
				
			$bbcode->addCode ('b', 'simple_replace', null, array ('start_tag' => '<strong>', 'end_tag' => '</strong>'),
			                  'inline', array ('listitem', 'block', 'inline', 'link'), array ());
			
			$bbcode->addCode ('i', 'simple_replace', null, array ('start_tag' => '<em>', 'end_tag' => '</em>'),
			                  'inline', array ('listitem', 'block', 'inline', 'link'), array ());
			
			$bbcode->addCode ('u', 'simple_replace', null, array ('start_tag' => '<u>', 'end_tag' => '</u>'),
			                  'inline', array ('listitem', 'block', 'inline', 'link'), array ());
			
			$bbcode->addCode ('color', 'callback_replace', 'do_bbcode_color', array ('usecontent_param' => 'default'),
			                  'inline', array ('listitem', 'block', 'inline', 'link'), array ());
			
			$bbcode->addCode ('url', 'usecontent?', 'do_bbcode_url', array ('usecontent_param' => 'default'),
			                  'link', array ('listitem', 'block', 'inline'), array ('link'));
			
			$bbcode->addCode ('quote', 'callback_replace', 'do_bbcode_quote', array ('usecontent_param' => 'default'),
			                  'block', array ('block'), array ('link','listitem', 'inline'));
			
			$bbcode->addCode ('size', 'callback_replace', 'do_bbcode_size', array ('usecontent_param' => 'default'),
			                  'inline', array ('listitem', 'block', 'inline', 'link'), array ());
			
			$bbcode->addCode ('img', 'usecontent', 'do_bbcode_img', array (),
			                  'image', array ('listitem', 'block', 'inline', 'link'), array ());
			$bbcode->setOccurrenceType ('img', 'image');
			$bbcode->setMaxOccurrences ('image', 4);
			
			$bbcode->addCode ('ul', 'simple_replace', null, array ('start_tag' => '<ul>', 'end_tag' => '</ul>'),
			                  'list', array ('block', 'listitem'), array ());
			$bbcode->addCode ('ol', 'simple_replace', null, array ('start_tag' => '<ol>', 'end_tag' => '</ol>'),
			                  'list', array ('block', 'listitem'), array ());
			$bbcode->addCode ('*', 'simple_replace', null, array ('start_tag' => '<li>', 'end_tag' => '</li>'),
			                  'listitem', array ('list'), array ());
			$bbcode->setCodeFlag ('*', 'closetag', BBCODE_CLOSETAG_OPTIONAL);
			$bbcode->setCodeFlag ('*', 'paragraphs', true);
			$bbcode->setCodeFlag ('list', 'paragraph_type', BBCODE_PARAGRAPH_BLOCK_ELEMENT);
			$bbcode->setCodeFlag ('list', 'opentag.before.newline', BBCODE_NEWLINE_DROP);
			$bbcode->setCodeFlag ('list', 'closetag.before.newline', BBCODE_NEWLINE_DROP);
			
			$bbcode->setRootParagraphHandling (true);
				
		
			$this->assignRef('bbcode', $bbcode);
		/*
		 * End setup bbcode
		 */
		}
		
		/*
		 * TODO - This is a very quick and dirty emoticon emoticon handler.
		 * This MUST be replaced asap
		 */
		
		// Smileys to find...
		$in = array( 	 ':)', 	
						 ':(',
						 ':o',
						 ':s',
						 '8)',
						 ':D'
		);
		// And replace them with...
		$out = array(	'<img border="0" src="'.JURI::root().'components/com_ninjamonials/emoticons/smiley_smile.png" alt=":)"/>',
						'<img border="0" src="'.JURI::root().'components/com_ninjamonials/emoticons/smiley_sad.png" alt=":("/>',
						'<img border="0" src="'.JURI::root().'components/com_ninjamonials/emoticons/smiley_surprised.png" alt=":o"/>',
						'<img border="0" src="'.JURI::root().'components/com_ninjamonials/emoticons/smiley_confused.png" alt=":s"/>',
						'<img border="0" src="'.JURI::root().'components/com_ninjamonials/emoticons/smiley_cool.png" alt="8)"/>',
						'<img border="0" src="'.JURI::root().'components/com_ninjamonials/emoticons/smiley_biggrin.png" alt=":D"/>'
		);
		$this->assignRef('emoticonsIn', $in);
		$this->assignRef('emoticonsOut', $out);

	//put our component parameters into references for our template
		$this->assignRef('use_text', $paramsObj->get('use_text'));
		$this->assignRef('use_summary', $paramsObj->get('use_summary'));
		$this->assignRef('use_website', $paramsObj->get('use_website'));
		$this->assignRef('link_website', $paramsObj->get('link_website'));	
		$this->assignRef('coll_website', $paramsObj->get('coll_website'));
		$this->assignRef('website_link_params', $paramsObj->get('website_link_params'));
		$this->assignRef('use_title', $paramsObj->get('use_title'));
		$this->assignRef('use_location', $paramsObj->get('use_location'));
		$this->assignRef('use_avatar', $paramsObj->get('use_avatar'));
		$this->assignRef('use_audio', $paramsObj->get('use_audio'));
		$this->assignRef('use_video', $paramsObj->get('use_video'));
		$this->assignRef('use_email', $paramsObj->get('use_email'));
		$this->assignRef('load_css', $paramsObj->get('load_css'));
		$this->assignRef('which_css', $paramsObj->get('which_css'));
		$this->assignRef('show_all', $paramsObj->get('show_all'));
		$this->assignRef('show_add', $paramsObj->get('show_add'));
		$this->assignRef('vid_height', $paramsObj->get('vid_height'));
		$this->assignRef('vid_width', $paramsObj->get('vid_width'));
		$this->assignRef('avatar_height', $paramsObj->get('avatar_height'));
		$this->assignRef('avatar_width', $paramsObj->get('avatar_width'));
		$this->assignRef('enable_bbcode', $paramsObj->get('enable_bbcode'));
		$this->assignRef('enable_emoticons', $paramsObj->get('enable_emoticons'));
		$this->assignRef('show_createdate', $paramsObj->get('show_createdate'));
		$this->assignRef('createdate_format', $paramsObj->get('createdate_format'));
		
		$this->assignRef('show_page_title',$paramsObj->get('show_page_title', 1)); 
		$this->assignRef('pageclass_sfx',$paramsObj->get('pageclass_sfx'));
		
	//build a link to the add form
		$this->assignRef('add_link',JRoute::_( JURI::base().'index.php?option=' . $option .'&amp;task=add&amp;controller=testimonials'));	

	//get the document so we can load stylesheets and javascript to it if needed
		$document = JFactory::getDocument();
			
	//set the base location from which our css and js files will branch
		$mediadir = JURI::base(true).'/media/com_ninjamonials';
		$this->assignRef('mediadir',$mediadir);
	
	//Where our avatars and videos etc will be loaded from
		$uploadsPath = $mediadir.'/uploadedmedia/';
		$this->assignRef('uploadsPath',$uploadsPath);
	//load the chosen css file if requested
		if ($this->load_css)
		{
			$document->addStyleSheet($mediadir.'/styles/'.$this->which_css.'/'.$this->which_css.'.css', 'text/css', null, array());
		}
	
		//get eh page header from our language file
		$pageHeader = JText::_('Testimonial List');		
		$this->assignRef('pageHeader',$pageHeader);
		
	//Only load our videoplayer JS if needed 
		if($this->use_video){
			$document->addScript($mediadir.'/js/flowplayer-3.1.1.min.js');				
		}
		
		switch ($this->which_css)
		{
			case 'classic_beige':
			case 'classic_white':
				break;
				
			case 'oceanic_white':
			case 'oceanic_blue':
			case 'oceanic_green':
			case 'oceanic_grey':
				$tpl = 'oceanic';
				break;
				
			case 'squarius_white':
			case 'squarius_blue':
			case 'squarius_green':
			case 'squarius_grey':
				$tpl = 'squarius';
				break;
				
			default:
				break;
		}
				 
		parent::display($tpl);

	}

}