/**
 * @version		$Id: mootools.3dcarousel.js 1909 2009-12-08 14:36:31Z stian $
 * @category	Ninja 3D Carousel
 * @copyright	Copyright (C) 2007 - 2009 NinjaForge. All rights reserved.
 * @license		GNU GPLv2 <http://www.gnu.org/licenses/old-licenses/gpl-2.0.html>
 * @link     	http://ninjaforge.com
 */

var N3DCarousel = new Class({

    getOptions: function(){
        return {
			center: {
				x: 300,
				y: 190
			}, 
			radius: {
				x: 190,
				y: 40
			},
			rpm:	3,
        	selector: 'n3dcarousel'
        }
    },

    initialize: function(options){
        this.setOptions(this.getOptions(), options);
		  		  
		this.carousel = $(this.options.selector);
	 
		this.children = this.carousel.getChildren();
		this.thumbs   = this.carousel.getElementsByTagName('img');
		
		this.childcount = this.children.length;
		
		this.count = 1;
		this.elements = [];
		this.counter = 0;
		
		this.round = Math.PI * (360/this.childcount*2);	
		this.rounded = this.round.round();
		
		this.time	= (60000/this.options.rpm)/this.round;
		this.fx = {duration:this.time, transition:Fx.Transitions.linear};
		this.timer 	= this.rotate.periodical(this.time, this);
						
		this.carousel.effect('opacity', {duration:600}).start(1);
				
        if (this.options.initialize) this.options.initialize.call(this);
    },
    rotate: function(){

		this.const1 = ( Math.PI * 2 ) / ( this.childcount ); 
		this.const2 = this.count * ( this.childcount / 360 );
		this.angle = 0;
		var pos = [];
		for(i=0; i < this.childcount; i++){
			thumb 		= this.children[i]; 
			thumb.img 	= this.thumbs[i];
		
			if (!$chk(this.elements[this.counter])) 
			{
				this.const3 = this.const2 + this.angle; /* (this eliminates 1 addition)*/
				this.angle += this.const1;
				pos.x = ( Math.sin( this.const3 )* this.options.radius.x) + this.options.center.x ;
				pos.y = ( Math.cos( this.const3 )* this.options.radius.y) + this.options.center.y ;
								
				width = pos.y/2;
				zindex = Math.round(width)+100;
				
				this.elements.include({x:pos.x, y:pos.y, w:width, z:zindex});
			}	
				e = this.elements[this.counter];
				
				thumb.style.zIndex = e.z;
				thumb.effects(this.fx).start({left:e.x+'px', top:''+e.y+'px', width:e.w});
				this.counter++;
		}

		if (this.count == this.rounded)
		{
			this.count = 0;
			this.counter = 0;
		}
		this.count++;		
    }
});

N3DCarousel.implement(new Events);
N3DCarousel.implement(new Options);