<?php

// no direct access
defined('_JEXEC') or die('Just Harakiri');

/**
* Breaking News Helper
* 
* @static
*/
if(!defined('_BREAKINGNEWS_')) {
	define ('_BREAKINGNEWS_', 1);
	
	require_once(JPATH_SITE.DS.'components'.DS.'com_content'.DS.'helpers'.DS.'route.php');
	
	class modBreakingNewsHelper
	{
		/**
		* Gets an array of breaking news items 
		* Breaking news items is the most recent content items created
		* @param JParameter Module parameters
		* @return mixed Array of items, false on failure
		*/
		function &getItems($catorsec, $catid, $numitems, $period)
		{
			$db =& JFactory::getDBO();
			$user		=& JFactory::getUser();
			$config 	=& JFactory::getConfig();
			$tzoffset 	= intval($config->getValue('config.offset'));
			
			jimport('joomla.utilities.date');
			$date = new JDate();
			$now = $date->toMySQL();
			
			$noauth=0;
			$access=0;

			$nullDate = $db->getNullDate();
			
			//$catids = explode( ',', $catid );
			$whereid = ( ($catorsec) ? "\n AND a.catid IN (".$catid.')' : ' AND a.sectionid IN (' .$catid.')' ) ;
			
			$orderby = ' ORDER BY a.created DESC';
			
			// query to determine article count
			$query = 'SELECT a.*, cc.description as catdesc, cc.title as cattitle, s.description as secdesc, s.title as sectitle,' .
				' CASE WHEN CHAR_LENGTH(a.alias) THEN CONCAT_WS(":", a.id, a.alias) ELSE a.id END as slug,'.
				' CASE WHEN CHAR_LENGTH(cc.alias) THEN CONCAT_WS(":", cc.id, cc.alias) ELSE cc.id END as catslug,'.
				' CASE WHEN CHAR_LENGTH(s.alias) THEN CONCAT_WS(":", s.id, s.alias) ELSE s.id END as secslug'.
				' FROM #__content AS a' .
				' INNER JOIN #__categories AS cc ON cc.id = a.catid' .
				' INNER JOIN #__sections AS s ON s.id = a.sectionid' .
				' WHERE a.state = 1 ' .
				($access ? ' AND a.access <= ' .(int) $aid. ' AND cc.access <= ' .(int) $aid. ' AND s.access <= ' .(int) $aid : '').
				' AND (a.publish_up = '.$db->Quote($nullDate).' OR a.publish_up <= '.$db->Quote($now).' ) ' .
				' AND (a.publish_down = '.$db->Quote($nullDate).' OR a.publish_down >= '.$db->Quote($now).' )' .
				' AND ( ( TO_DAYS("' . date( 'Y-m-d', time()+$tzoffset*60*60 ) .'") - TO_DAYS(a.created) ) <= '.$period.')'.
				$whereid.
				' AND cc.section = s.id' .
				' AND cc.published = 1' .
				' AND s.published = 1' .
				$orderby;
			
			$db->setQuery($query, 0, $numitems);
			$rows = $db->loadObjectList();
			
			return $rows;
		}
		
		
		function &getFeaturedItems($ids, $numitems, $ordering, $maxchars)
		{
			$db =& JFactory::getDBO();
			
			$strIds = implode( ',', $ids );
			
			$whereid = ' WHERE a.id IN (' . $strIds . ')';
			/* ORDERING for Featured Article is solely/supposed to only depends on the Editor */
			/**
			* Added by Richie
			* we need to check the ordering option
			**/
			switch ($ordering) {
				default:
				case 0: // created date
					$query_sel = '';
					$left_join = '';
					$orderby = ' ORDER BY a.created DESC';
					break;
				case 1: // top rated
					$query_sel = 'CASE WHEN cr.rating_count IS NULL THEN 0.0 ELSE cr.rating_sum / cr.rating_count + cr.rating_count * 0.1 END AS rating_val, cr.rating_count,';
					$left_join = ' LEFT JOIN #__content_rating AS cr ON cr.content_id = a.id';
					$orderby = ' ORDER BY 1 DESC,2 DESC, 3 DESC';
					break;
				case 2: // most read recent
					$query_sel = '';
					$left_join = '';
					$orderby = ' ORDER BY a.hits DESC';
					break;	
				case 3: // aricle manager ordering
					$query_sel = '';
					$left_join = '';
					$orderby  = ' ORDER BY a.ordering ASC';
					break;
				case 4: // frontpage ordering
					$query_sel = '';
					$left_join = '';
					$orderby  = ' ORDER BY f.ordering ASC';
					break;
				
			}		
			//$orderby = ' ORDER BY FIELD(a.id, '.$strIds.')';
			
			$sql = 'SELECT ' . $query_sel .
			' a.id, a.title, a.introtext, a.fulltext, a.created, a.modified, a.sectionid, a.catid, a.created_by, a.hits,'
						.' cc.description as catdesc, cc.title as cattitle, s.description as secdesc, s.title as sectitle, u.username,'
						.' CASE WHEN CHAR_LENGTH(a.alias) THEN CONCAT_WS(":", a.id, a.alias) ELSE a.id END as slug,'
						.' CASE WHEN CHAR_LENGTH(cc.alias) THEN CONCAT_WS(":", cc.id, cc.alias) ELSE cc.id END as catslug,'
						.' CASE WHEN CHAR_LENGTH(s.alias) THEN CONCAT_WS(":", s.id, s.alias) ELSE s.id END as secslug'
						.' FROM #__content AS a'
						.$leftjoin
						.' INNER JOIN #__categories AS cc ON cc.id = a.catid'
						.' INNER JOIN #__sections AS s ON s.id = a.sectionid'
						.' INNER JOIN #__users AS u ON u.id = a.created_by'
						.$whereid 
						.' AND cc.section = s.id'
						.' AND cc.published = 1'
						.' AND s.published = 1'
						.$orderby;
			$db->setQuery($sql, 0, $numitems);
			$items = $db->loadObjectList();
			
			return $items;
		}
		
		/*
		 * Get content item by section / category look up from menu selection - Rakou.org features
		 * ORDERING 
		*/
		function getBySecCatItems($params) {
			global $mainframe;

			$db			=& JFactory::getDBO();
			$user		=& JFactory::getUser();
			$aid		= $user->get('aid', 0);
			$introitems = intval (trim( $params->get( 'introitems', 1 ) ));
			$linkitems 	= intval (trim( $params->get( 'linkitems', 0 ) ));
			$ordering 	= intval( $params->get('ordering') );
			$numitems 	= $introitems + $linkitems;
			$show_front	= $params->get('show_front', '1'); // hard code in here
			$period		= intval( $params->get('period', 3600) );
			$config 	=& JFactory::getConfig();
			$tzoffset 	= intval($config->getValue('config.offset'));
			
			$menus 		= &JSite::getMenu();
			$currentMenu  = $menus->getActive();   
			$menuOption	= $currentMenu->query['option'];
			
			$catid = 0;
			$secid = 0;
			
	
			if($menuOption == 'com_content'){
				$menuView = $currentMenu->query['view'];
				if($menuView == 'section'){
					$secid = $currentMenu->query['id'];
					$secCondition = ' AND a.sectionid='.$secid; 
				}
				elseif($menuView == 'category'){
					$catid = $currentMenu->query['id'];
					$catCondition = ' AND a.catid='.$catid;      
				}
			}
			elseif($menuOption == 'com_sectionex'){
				$menuView = $currentMenu->query['view'];
				if($menuView=='category'){
					$secid = $currentMenu->query['id'];
					$secCondition = ' AND a.sectionid='.$secid; 
				}
			}
	
			$contentConfig = &JComponentHelper::getParams( 'com_content' );
			$access		= !$contentConfig->get('shownoauth');
			$nullDate	= $db->getNullDate();
			jimport('joomla.utilities.date');
			$date = new JDate();
			$now  = $date->toMySQL();
						
			switch ($ordering) {
				default:
				case 0: // created date
					$query_sel = '';
					$left_join = '';
					$orderby = ' ORDER BY a.created DESC';
					break;
				case 1: // top rated
					$query_sel = 'CASE WHEN cr.rating_count IS NULL THEN 0.0 ELSE cr.rating_sum / cr.rating_count + cr.rating_count * 0.1 END AS rating_val, cr.rating_count,';
					$left_join = ' LEFT JOIN #__content_rating AS cr ON cr.content_id = a.id';
					$orderby = ' ORDER BY 1 DESC,2 DESC, 3 DESC';
					break;
				case 2: // most read recent
					$query_sel = '';
					$left_join = '';
					$orderby = ' ORDER BY a.hits DESC';
					break;	
				case 3: // aricle manager ordering
					$query_sel = '';
					$left_join = '';
					$orderby  = ' ORDER BY a.ordering ASC';
					break;
				case 4: // frontpage ordering
					$query_sel = '';
					$left_join = '';
					$orderby  = ' ORDER BY f.ordering ASC';
					break;
				
			}
	
			//Content Items only
			$query = 'SELECT ' . $query_sel .
			' a.id, a.title, a.introtext, a.fulltext, a.created, a.modified, a.sectionid, a.catid, u.username AS name,' .
			' CASE WHEN CHAR_LENGTH(a.alias) THEN CONCAT_WS(":", a.id, a.alias) ELSE a.id END as slug,'.
			' CASE WHEN CHAR_LENGTH(cc.alias) THEN CONCAT_WS(":", cc.id, cc.alias) ELSE cc.id END as catslug'.
			' FROM #__content AS a' .
			$left_join .
			' LEFT JOIN #__content_frontpage AS f ON f.content_id = a.id' .
			' INNER JOIN #__categories AS cc ON cc.id = a.catid' .
			' INNER JOIN #__sections AS s ON s.id = a.sectionid' .
			' INNER JOIN #__users AS u ON u.id = a.created_by' .
			' WHERE ( a.state = 1 AND s.id > 0 )' .
			' AND ( a.publish_up = '.$db->Quote($nullDate).' OR a.publish_up <= '.$db->Quote($now).' )' .
			' AND ( a.publish_down = '.$db->Quote($nullDate).' OR a.publish_down >= '.$db->Quote($now).' )'.
			' AND ( ( TO_DAYS("' . date( 'Y-m-d', time()+$tzoffset*60*60 ) .'") - TO_DAYS(a.created) ) <= '.$period.')'.
			($access ? ' AND a.access <= ' .(int) $aid. ' AND cc.access <= ' .(int) $aid. ' AND s.access <= ' .(int) $aid : '').
			($catid ? $catCondition : '').
			($secid ? $secCondition : '').
			($show_front == '0' ? ' AND f.content_id IS NULL' : '').
			' AND s.published = 1' .
			' AND cc.published = 1'.
			$orderby;
	
			$db->setQuery($query, 0, $numitems);
			$lists = $db->loadObjectList();
			
			return $lists;
		}
		
		
		function getCatIdLink($catid)
		{
			$db 	=& JFactory::getDBO();
			
			$whereCatId = '';
			
				$catIds = explode( ',', $catid );
				JArrayHelper::toInteger($catIds );
				//array_unshift($catIds, intval($breakCatId) );
				$whereCatId = " WHERE ( cc.id=" . implode( " OR cc.id=", $catIds ) . " )";
				$ordrby = 'ORDER BY cc.id DESC';
				
				jimport('joomla.utilities.date');
				$date = new JDate();
				$now = $date->toMySQL();

				$nullDate = $db->getNullDate();
						
				$sql = 'SELECT cc.id, cc.title FROM #__categories AS cc'
						.$whereCatId
						.'AND cc.published = 1'
						.$orderby
						;
				/*
				$sql = 'SELECT a.id, a.title, a.introtext, a.fulltext, a.created, a.modified, a.sectionid, a.catid, a.created_by,'
						.' cc.description as catdesc, cc.title as cattitle, s.description as secdesc, s.title as sectitle,'
						.' CASE WHEN CHAR_LENGTH(a.alias) THEN CONCAT_WS(":", a.id, a.alias) ELSE a.id END as slug,'
						.' CASE WHEN CHAR_LENGTH(cc.alias) THEN CONCAT_WS(":", cc.id, cc.alias) ELSE cc.id END as catslug,'
						.' CASE WHEN CHAR_LENGTH(s.alias) THEN CONCAT_WS(":", s.id, s.alias) ELSE s.id END as secslug'
						.' FROM #__content AS a'
						.' INNER JOIN #__categories AS cc ON cc.id = a.catid'
						.' INNER JOIN #__sections AS s ON s.id = a.sectionid'
						.$whereCatId 
						.' AND cc.section = s.id'
						.' AND cc.published = 1'
						.' AND s.published = 1'
						.$orderby;
				*/
				$db->setQuery($sql);
				$cats = $db->loadObjectList();
				return $cats;
			
		}
		
		/*
		 * replaceImage from JA News
		 */
		function replaceImage( &$row, $align, $autoresize, $maxchars, $showimage, $width = 0, $height = 0 ) {
			global $database;
			
			$regex = "/\<img.+src\s*=\s*\"([^\"]*)\"[^\>]*\>/";
			preg_match ($regex, $row->introtext, $matches);
			if(!count($matches)) preg_match ($regex, $row->fulltext, $matches);
			
			$images = (count($matches)) ? $matches : array();
			$image = '';
			
			if (count($images)) $image = $images[1];
			$align = $align? "align=\"$align\"" : "";
			
			if ($image && $showimage) {
				if ( $autoresize && function_exists('imagecreatetruecolor') 
					 && ( $image1 = modBreakingNewsHelper::processImage ( $image, $width, $height ) ) ) 
				{
						$image = "<img src=\"".$image1."\" alt=\"{$row->title}\" $align />";
				} else {
					$width = $width?"width=\"$width\"":"";
					$height = $height?"height=\"$height\"":"";
					$image = "<img src=\"".$image."\" alt=\"{$row->title}\" $width $height $align />";
				}
				
			} else $image = '';

			$regex1 = "/\<img.*\/\>/";
			$row->introtext = preg_replace( $regex1, '', $row->introtext );
			$row->introtext = trim($row->introtext);

			$row->introtext1 = $row->introtext;
			if ($maxchars && strlen ($row->introtext) > $maxchars) {
				$row->introtext1 = substr ($row->introtext1, 0, $maxchars) . "...";
			}
			// clean up globals
			return $image;
		}

		/*
		 * processImage from JA News
		 */
		function processImage ( &$img, $width, $height ) {
			if(!$img) return;
			$img = str_replace(JURI::base(),'',$img);
			$img = rawurldecode($img);
			$imagesurl = (file_exists(JPATH_SITE .'/'.$img)) ? modBreakingNewsHelper::thumbIt($img,$width,$height) :  '' ;
			return $imagesurl;
		}
		
		/*
		 * getAllCatIds from JA News
		 */
		function getAllCatIds ($catorsec) {
			$db 	=& JFactory::getDBO();
			if($catorsec){
				$query = "SELECT id FROM #__categories WHERE published = 1;";
			}
			else{
				$query = "SELECT id FROM #__sections WHERE published = 1;";
			}
			$db->setQuery($query);
			$c = $db->loadObjectList();
			$catids = array();
			foreach($c as $_c) $catids[] = $_c->id;
			
			$catid = implode(',', $catids);
			//return $catids;
			return $catid;
		}
		
		/*
		 * replaceImage from JA News
		 */
		function thumbIt($image,$max_width,$max_height){
			$path = JPATH_SITE;
			$sizeThumb = getimagesize(JPATH_SITE.'/'.$image);
			$width = $sizeThumb[0];
			$height = $sizeThumb[1];
			
			if (!$max_width && !$max_height) {
				$max_width = $width;
				$max_height = $height;
			} else{
				if (!$max_width) $max_width = 1000;
				if (!$max_height) $max_height = 1000;
			}
			
			$x_ratio = $max_width / $width;
			$y_ratio = $max_height / $height;
			
			if (($width <= $max_width) && ($height <= $max_height) ) {
				// don't make any larger thumb than the orig.img
				$tn_width = $width;
				$tn_height = $height;
			} else if (($x_ratio * $height) < $max_height) {
				$tn_height = ceil($x_ratio * $height);
				$tn_width = $max_width;
			} else {
				$tn_width = ceil($y_ratio * $width);
				$tn_height = $max_height;
			}
			// read image
			$ext = strtolower(substr(strrchr($image, '.'), 1)); // get the file extension
			$rzname = strtolower(substr($image, 0, strpos($image,'.')))."_{$tn_width}_{$tn_height}.{$ext}"; // get the file extension
			$resized = $path.'/images/resized/'.$rzname;
			if(file_exists($resized)){
				$smallImg = getimagesize($resized);
				if (($smallImg[0] <= $tn_width && $smallImg[1] == $tn_height) ||
					($smallImg[1] <= $tn_height && $smallImg[0] == $tn_width)) {
						return "images/resized/".$rzname;
				}
			}
			if(!file_exists($path.'/images/resized/') && !mkdir($path.'/images/resized/',0755)) return '';
			$folders = explode('/',$image);
			$tmppath = $path.'/images/resized/';
			for($i=0;$i < count($folders)-1; $i++){
				if(!file_exists($tmppath.$folders[$i]) && !mkdir($tmppath.$folders[$i],0755)) return '';
				$tmppath = $tmppath.$folders[$i].'/';
			}
			
			switch ($ext) {
				case 'jpg':     // jpg
					$src = imagecreatefromjpeg(JPATH_SITE.'/'.$image);
					break;
				case 'png':     // png
					$src = imagecreatefrompng(JPATH_SITE.'/'.$image);
					break;
				case 'gif':     // gif
					$src = imagecreatefromgif(JPATH_SITE.'/'.$image);
					break;
				default:
			}
			$dst = imagecreatetruecolor($tn_width,$tn_height);
			
			if (function_exists('imageantialias')) imageantialias ($dst, true);
			imagecopyresampled ($dst, $src, 0, 0, 0, 0, $tn_width, $tn_height, $width, $height);
			imagejpeg($dst, $resized, 90); // write the thumbnail to cache as well...
			return "images/resized/".$rzname;
		}
		
		
		function limitText(&$txt,$limit)
		{
			$len = strlen($txt);
			if ($len <= $limit) { return $txt; }
			else {
				$txt = substr($txt,0,$limit);
				$pos = strrpos($txt," ");
				if($pos > 0) {
					$txt = substr($txt,0,$pos);
					if (($tpos =strrpos($txt,"<")) >  strrpos($txt,">") && $tpos>0)
					{
						$txt = substr($txt,0,$tpos-1);
					}
				}
				return $txt . "...";
			}
		}
		
		/*
		 * getFile from JA News Joomlart.com
		 */
		
		function getFile($name, $modPath, $tmplPath) {
			if (file_exists(JPATH_SITE.DS.$tmplPath.$name)) {
				return $tmplPath.$name;
			}
			return $modPath.$name;
		}
		
		
	}// end class
}
?>