<?php

defined( '_JEXEC' ) or die( 'Just Harakiri' );

// based on FeaturedArticle module from www.dart-creation.com, JA News from Joomlart

require_once(dirname(__FILE__).DS.'helper.php');
global $mainframe;
// If the template has a css override use it
JHTML::stylesheet('',modBreakingNewsHelper::getFile('style.css','modules/mod_breakingnews/css/', 'templates/'.$mainframe->getTemplate().'/css/'));


$mode		= $params->get('mode', 0); // 0=default=breaking news, 1=Editor's pick, 2=By Section/Category
$id			= 	trim( $params->get( 'id' ));
$catid 		= 	trim( $params->get( 'catid' ));
$catorsec	= 	trim( $params->get( 'catorsec' ));
$introitems 	= 	intval (trim( $params->get( 'introitems', 1 ) ));
$linkitems 		= 	intval (trim( $params->get( 'linkitems', 0 ) ));
$maxchars 		= 	intval (trim( $params->get( 'maxchars', 100 ) ));
$period			= intval( trim($params->get('period', 1)) );
$ordering = intval( $params->get('ordering') );

$numitems = $linkitems + $introitems;

switch ($mode) {
	case 0: // breaking News
	default:
		if($catid) {
			$catids = explode( ',', $catid );
			JArrayHelper::toInteger($catids);
		}
		else //if ($catid==0) 
		{
			$catid = modBreakingNewsHelper::getAllCatIds($catorsec);
		}
		
		$rows = modBreakingNewsHelper::getItems($catorsec, $catid, $numitems, $period);
		if ( count($rows) ) {
			$path = JModuleHelper::getLayoutPath('mod_breakingnews', 'default');
			if (file_exists($path)) { require($path); }
			else { echo JText::_('Failed to get Items, check your parameters!'); }
		}
		else {
			echo JText::_('Failed to get Items, check your parameters!');
		}
		break;
		
	case 1: // Editor's Pick - Featured Article
		$ids = explode( ',', $id );
		JArrayHelper::toInteger($ids);
		$items = modBreakingNewsHelper::getFeaturedItems($ids, $numitems, $ordering, $maxchars);
				
		if( count($items) ) {
			$layoutpath = JModuleHelper::getLayoutPath('mod_breakingnews', 'featured' );
			if( file_exists($layoutpath) ) { require($layoutpath); }
		}
		else {
			echo JText::_('Failed to get Items, check your parameters!');
		}
		
		break;
	
	case 2: // mod by section/category look up
	
		$lists = modBreakingNewsHelper::getBySecCatItems($params);
		if( count($lists) ) {
			$layoutpath = JModuleHelper::getLayoutPath('mod_breakingnews', 'byseccat' );
			if( file_exists($layoutpath) ) { require($layoutpath); }
		}
		else {
			echo JText::_('Failed to get Items, check your parameters!');
		}
		break;
}

?>