<?php
/**
* @version		$Id: helper.php 2009 vargas $
* @package		Joomla
* @license		GNU/GPL, see LICENSE.php
*/

// no direct access
defined('_JEXEC') or die('Restricted access');

jimport('joomla.filesystem.file');

class modImgsCrawlerHelper
{

	function getImages(&$params, $folder)
	{
		$images	= array();
		
		$links     = explode( ',', $params->get( 'links' ) );
		$target    = $params->get( 'target', '_self' );
		$repeat    = $params->get( 'repeat', 0 );
		$margin    = intval($params->get( 'margin', 3 ));
		$direction = $params->get( 'direction', 'left' );
		$substoo   = $params->get( 'substoo', 0 );
		
		switch ( $direction ) {
			case 'left';
				$space = 'margin-right:'.$margin.'px';
				break;
			case 'right';
				$space = 'margin-left:'.$margin.'px';
				break;
		}

		// check if directory exists
		if (is_dir(JPATH_BASE.DS.$folder))
		{
			$files = modImgsCrawlerHelper::getFiles($folder,$substoo);
			$i = 0;
			$repeated = 0;
			foreach ($files as $file)
			{
				if (modImgsCrawlerHelper::isImage($file)) {
					$file	    = str_replace( '\\', '/', $file );
					$images[$i] = JHTML::_('image', $file, '', array('style' => $space));
					if ($links && (isset($links[$i]) or $repeat)) :
						if ($links[$i]) {
							$images[$i] = JHTML::_('link', $links[$i], $images[$i], ($target ? array('target' => '_blank') : '' ) );
						} else {
							$repeated++;
							$images[$i] = JHTML::_('link', $links[$repeated-1], $images[$i], ($target ? array('target' => '_blank') : '' ) );
							if ($repeated == count($links)) $repeated = 0 ;
						}
					endif;
					++$i;
				}
			}
		}

		return $images;
	}

	function getFolder(&$params)
	{
		$folder 	= $params->get( 'folder' );

		$LiveSite 	= JURI::base();

		// if folder includes livesite info, remove
		if ( JString::strpos($folder, $LiveSite) === 0 ) {
			$folder = str_replace( $LiveSite, '', $folder );
		}
		// if folder includes absolute path, remove
		if ( JString::strpos($folder, JPATH_SITE) === 0 ) {
			$folder= str_replace( JPATH_BASE, '', $folder );
		}
		$folder = str_replace('\\',DS,$folder);
		$folder = str_replace('/',DS,$folder);

		return $folder;
	}
	
	function getFiles($folder,$substoo) {
	
		$dir      = JPATH_BASE.DS.$folder;
	
		$files	  = array();
		$subfiles = array();
	
		if ($handle = opendir($dir)) {
			while (false !== ($file = readdir($handle))) {
				if ($file != '.' && $file != '..' && $file != 'CVS' && $file != 'index.html' ) {
					if (!is_dir($dir . DS . $file))
					{
						$files[] = $folder . DS . $file;
					} elseif ($substoo != 0) {
						$newfolder = $folder . DS . $file;
						$subfiles  = modImgsCrawlerHelper::getFiles($newfolder,$substoo);
					}
				}
			}
		}
		closedir($handle);
		
		$files = array_merge($files,$subfiles);
		
		return $files;
	}
	
    function isImage($file) {
		$file  = JFile::getName($file);
		$file  = JFile::getExt($file);
		$file  = strtolower($file);
        $types = array("jpg", "jpeg", "gif", "png");
        if (in_array($file, $types)) return true;
        else return false;
    }
}
