<?php
/*
 * Ninja Helper Functions Class
 * 
 * This is just some utility functions which we use frequently.
 */
 
 
// Ensure this file is being included by a parent file. 
defined ( '_JEXEC' ) or die( 'Direct Access to this location is not allowed.' );

if (!class_exists('nf_helper_funcs')) {

class modNinjaSlideHelper {

/****
* Retrieve the details of a specific module from their id 
****/
	function getModDets( $id ) {
		
			//We need the databaseloaded to do our query
			$database     = &JFactory::getDBO();
		
			$query    = "SELECT *" 
						. "\n FROM #__modules AS m"
						. "\n where m.id = '" . $id . "' "
						. "\n AND m.client_id != 1";

            $database->setQuery( $query );
            $modDets  = $database->loadObjectList();
		 
		return $modDets[0];
	
	}//getModDets function
	
/****
* Check if module exist
****/
	function exist( $id ) {
		
			//We need the databaseloaded to do our query
			$database     = &JFactory::getDBO();
		
			$query    = "SELECT *" 
						. "\n FROM #__modules AS m"
						. "\n where m.id = '" . $id . "' "
						. "\n AND m.client_id != 1";

            $database->setQuery( $query );
            $exist  = $database->loadResult();
		 
		return $exist;
	
	}//exist function
	
/**** 
* Render a particular module inside another module (or component etc.) 
****/
	function getModBody( $module ) {
        
        //our custom modules in J1.0, mambo and mia don't have a mod_ prefix
        //they should also be the only modules with content so we can double check these
        if (($module->content) || ($module->module == 'mod_custom')){
        
            echo($module->content);
        
        } else { //its not a custom module
                
            //create a new $params object so we get the right information to our module
            $params = new JParameter( $module->params );
            
            //Strip any slashes from our name so we can find the html file for it 
            $module->module      = str_replace( '/', '', $module->module );
            $module->module      = str_replace( '\\', '', $module->module );
            
            $lang = & JFactory :: getLanguage();
            $lang->load($module->module, JPATH_ADMINISTRATOR);
            
            //set the path to our module's primary file
            $path      = JPATH_SITE. DS .'modules'.DS.$module->module.DS.$module->module.'.php';
             
            //Once we have the path load the module   
                if ( file_exists( $path ) ) {
                    require $path;
                }
        }
    
    }//getModBody function
	
	
/**** 
* Get the sufix for the contained modules 
****/
	function getModSuffix( $module ) {
				//create a new $params object so we get the right information to our module
			$params = new JParameter( $module->params );
			
			return $params->get( 'moduleclass_sfx');
				
	}

/**
* Get a user's group data
*
* @param int user id
*/
  	function getGroup($user){
		
		//We need to access the $acl global variable to check permissions
		$user = &JFactory::getUser();
		
		//$user contains user information, $acl contains account level information
		$myRealGid = $user->gid;
		// For standard Joomla groups
		// $myRealGid = 18 - Registered
		//		19 - Author
		//		20 - Editor
		//		21 - Publisher
		//		23 - Manager
		//		24 - Administrator
		//		25 - Super Administrator   
		
		return $myRealGid;
	}
    
} //class declaration
} // if class exists
?>
