<?php
/**
 * @version		$Id: ninjimage.css.php, 1 2008/12/27 14:18:39 +0100 uwalter Exp $
 * @package		NinjaForge.Ninjimage 
 * @subpackage	Joomla.Modules 
 * @copyright	Copyright (C) 2008 ninjaforge.com - Get on the Cutting Edge.
 * @licence		GNU/GPL http://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 * @developer	Uwe Walter
 * @email		uwe@ninjforge.com
 * @homepage	http://ninjaforge.com 
 * #############################################################################
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 * #############################################################################
 * $LastModified: 2008-12-28 13:03:27 +0100 uwalter $
 */

header('Content-Type: text/css');

define('_JEXEC', 1);
define('DS', DIRECTORY_SEPARATOR);
define('JPATH_BASE', '..'.DS.'..'.DS.'..'); // Path traversal up to the Joomla! root.

// Load needed libs.
require_once JPATH_BASE.DS.'includes'.DS.'defines.php';
require_once JPATH_BASE.DS.'includes'.DS.'framework.php';

// Retrieve module ID and type cast to integer.
$id	= isset($_GET['i']) ? (int) $_GET['i'] : exit;

// Prepare environment.
$mainframe	=& JFactory::getApplication('site');
$database	=& JFactory::getDBO();

// Get module parameters.
$database->setQuery("SELECT params FROM #__modules WHERE `id` = $id");
$parameters = explode("\n", $database->loadResult());

$params = array();
while ($p = array_shift($parameters)) {
	// Load parameters into params array.
	list ($k, $v)	= explode('=', $p);
	$params[$k]		= $v;
}
// Delete no more needed variables.
unset($p, $k, $v);

// Shall we use a custom DIV id?
$nfniId	 = ($params['useid'] == 'pleaseReadTooltip' || $params['useid'] == '') ? 'nfni'.$id : $params['useid']; 

// Validate colors.
$check = array('bcolor', 'hdrcol', 'backcol');
while ($f = array_shift($check)) {
	if ($params[$f] && $params[$f] != 'transparent' && !preg_match(',^#,', $params[$f]))
		$params[$f] = '#'.$params[$f]; 
}
$width	= $params['width']	? 'width:'	.$params['width'].	'px;'	: '';
$height	= $params['height']	? 'height:'	.$params['height'].	'px;'	: '';
$margin	= $float = '';
if ($params['position'] == 1) {
	$position	 = 'position:absolute;';
	$z_index	 = $params['z_index']	? 'z-index:'.$params['z_index'].';'		: '';
	$margin		.= $params['mtop']		? 'top:'	.$params['mtop'].'px;'		: '';
	$margin		.= $params['mleft']		? 'left:'	.$params['mleft'].'px;'		: '';
	$margin		.= $params['mright']	? 'right:'	.$params['mright'].'px;'	: '';
	$margin		.= $params['mbottom']	? 'bottom:'	.$params['mbottom'].'px;'	: '';
}
else {
	$position	 = '';
	$float		 = 'float:left;overflow: auto;';
	$margin		 = 'margin:';
	$margin		.= $params['mtop']		? $params['mtop'].'px '		: '0 ';
	$margin		.= $params['mright']	? $params['mright'].'px '	: '0 ';
	$margin		.= $params['mbottom']	? $params['mbottom'].'px '	: '0 ';
	$margin		.= $params['mleft']		? $params['mleft'].'px;'	: '0;';
}
$padding = 'padding:';
$padding .= $params['ptop']		? $params['ptop'].'px '		: '0 ';
$padding .= $params['pright']	? $params['pright'].'px '	: '0 ';
$padding .= $params['pbottom']	? $params['pbottom'].'px '	: '0 ';
$padding .= $params['pleft']	? $params['pleft'].'px;'	: '0;';

$backcol = $params['backcol']	? 'background-color:'.$params['backcol'].';': '';
$hdrcol	 = $params['hdrcol']	? 'color:'.$params['hdrcol'].';'			: '';

$border  = '';
if ($params['bwidth']) {
	$border  = 'border:';
	$border .= $params['bwidth'].'px ';
	$border .= $params['bstyle'].' ';
	$border .= $params['bcolor'].';';
}

// Do we have a draggable item? Then show it to the user.
$cursor = $params['type'] != 'img' ? 'cursor:move;' : '';

/**
 * Print CSS definitions.
 */

// Enclosing DIV container.
echo '#', $nfniId, ' {',
	$width,
	$height,
	$position,
	$z_index,
	$float,
	$margin,
	$padding,
	$backcol,
	$border,
	$cursor,
	"}\n";

if ($params['hdr']) {
	// Custom header, if necessary.
	echo '#', $nfniId, ' h', $params['hdr'], ' {',
		'margin:0;',
		'padding:0 0 -5px;',
		'font-weight:bold;',
		$hdrcol,
		"}\n";
}

?>
