<?php
/**
 * @version		$Id: helper.php, 1 2008/12/25 15:15:32 +0100 uwalter Exp $
 * @package		NinjaForge.Ninjimage 
 * @subpackage	Joomla.Modules 
 * @copyright	Copyright (C) 2008 ninjaforge.com - Get on the Cutting Edge.
 * @licence		GNU/GPL http://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 * @developer	Uwe Walter
 * @email		uwe@ninjforge.com
 * @homepage	http://ninjaforge.com 
 * #############################################################################
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 * #############################################################################
 * $LastModified: 2008-12-28 12:18:58 +0100 uwalter $
 */

// Are we under development? If not then leave this constant empty,
// otherwise put '.dev' into it.
define('DEV', '');

class modNinjimageHelper {

	/**
	 * Creates the HTML output for our basic image.
	 *
	 * @access	public
	 * @param	reference	Array containing module parameters.
	 * @return	string		Basic Image HTML code.
	 */
	function getImage(&$params) {

		global $mainframe;

		// Get basic environment.
		$domain		=  JURI::base();
		$modpath	=  $doamin.'modules/'.$params['mname'];
		$document	=& JFactory::getDocument();

		if ($params['usecss'])
			// Set CSS header tag, if needed
			$document->addStyleSheet($modpath.'/css/ninjimage.css.php?i='.$params['mid']);

		// Create Image HTML code.
		if ($params['path'] != 'url' && !preg_match(',^/,', $params['file']))
			$params['file'] = '/'.$params['file'];

		$html = $params['hdr'] ? '<h'.$params['hdr'].'>'.$params['hdrtxt'].'</h'.$params['hdr'].'>' : '';
		if ($params['useurl'] != 'none') {
			$html .= '<a href="';
			$html .= $params['useurl'] == 'default' ? $domain : $params['location'];
			$html .= '" target="_'.$params['target'].'">';
		}
		$html .= '<img src="';
		if     ($params['path'] == 'tpl') { $html .= $domain.'templates/'.$mainframe->getTemplate().$params['file']; }
		elseif ($params['path'] == 'img') { $html .= $domain.'images'.$params['file']; }
		else                              { $html .= $params['file']; }
		$html .= '" width="'.$params['iwidth'].'"';
		$html .= ' height="'.$params['iheight'].'"';
		$html .= ' alt="'.$params['alt'].'"';
		$html .= $params['title'] = ' title="'.$params['title'].'"';
		$html .= '>';
		if ($params['useurl'] != 'none') $html .= '</a>';

		return $html;

	} // End function getImage

	/**
	 * Creates the HTML output for our draggable images.
	 *
	 * @access	public
	 * @param	reference	Array containing module parameters.
	 * @return	string		Draggable Image HTML code.
	 */
	function getDraggable(&$params) {

		// Get basic environment.
		$modpath	=  JURI::base().'modules/'.$params['mname'];
		$document	=& JFactory::getDocument();

		// Load JacaScripts, if necessary.
		if ($params['core'])	$document->addScript($modpath.'/js/jquery.js');
		if ($params['js'])		$document->addScript($modpath.'/js/ninjimage'.DEV.'.js');

		return modNinjimageHelper::getImage($params);

	} // End function getDraggable

	/**
	 * Creates the HTML output for our draggable module.
	 *
	 * @access	public
	 * @param	reference	Array containing module parameters.
	 * @return	string		Draggable Module HTML code.
	 */
	function getModule(&$params) {

		// Get basic environment.
		$modpath	=  JURI::base().'modules/'.$params['mname'];
		$document	=& JFactory::getDocument();
		$database	=& JFactory::getDBO();

		if ($params['usecss'])
			// Set CSS header tag, if needed
			$document->addStyleSheet($modpath.'/css/ninjimage.css.php?i='.$params['mid']);

		// Load JacaScripts, if necessary.
		if ($params['core'])	$document->addScript($modpath.'/js/jquery.js');
		if ($params['js'])		$document->addScript($modpath.'/js/ninjimage'.DEV.'.js');

		$html = $params['hdr'] ? '<h'.$params['hdr'].'>'.$params['hdrtxt'].'</h'.$params['hdr'].'>' : '';

		// Get the module data
		$database->setQuery("
			SELECT module, content FROM #__modules
			WHERE id = '".$params['id']."'
			AND client_id != 1
		");
		list ($module, $content) = $database->loadResultArray();

		// If our module is a custom module then load it's content.
		if ($module->content || $module->module == 'mod_custom') $html .= $content;
		else {
			// Otherwise load and render it.
			$mod	 = JModuleHelper::getModule($module);
			$html	.= JModuleHelper::renderModule($mod);
		}
		return $html;

	} // End function getModule

} // End class
