<?php
// no direct access
defined('_JEXEC') or die('Restricted access');

/**
 * @Name         Theme Joomla Power Slide Diplay Module
 * @URL          http://powerslide.themejoomla.com
 * @version      $Id: helper.php 3 skashi $
 * @package      Joomla (1.5.x)
 * @subpackage   Power Slide Diplay Module
 * @copyright    Copyright (C) 2008-2020 Theme Joomla. All rights reserved. E & OE
 */

class modPowerSlideHelper {
  /**
   * Goes through folders and returns an array of images
   *
   * @param  int images identifier
   * @param  string dir file directory path
   * @param  string regex regular expression
   * @param  string folder image path
   *
   * @return images
   *
   */
  function traverseDirectory( &$images, $dir, $regex, $folder ) {
    if (is_dir($dir)) {
      if ($handle = opendir($dir)) {
        while (false !== ($file = readdir($handle))) {
          if ($file != '.' && $file != '..' && $file != 'CVS' && $file != 'index.html' ) {
            $files[] = $file;
          }
        }
      }
      closedir($handle);

      $i = 0;
      foreach ($files as $img) {
        if (!is_dir($dir .DS. $img)) {
          if (preg_match($regex, $img)) {
            $images[$i]->filename   = $img;
            $images[$i]->folder     = $folder;
            ++$i;
          }
        }
      }
      return $images;
    }
  }

  /**
   * Gets the images from the file system
   *
   * @param  array module params
   * @param  string folder image path
   *
   * @return images
   *
   */
  function getImages( &$params, $folder ) {
    $image_types        = array('jpg','png','gif','jpeg');
    $regex = '/'.implode ('|', $image_types).'$/i';
    $files  = array();
    $images = array();

    $dir = $folder;

    // check if directory exists

    if (is_dir($dir)) {
      $images = modPowerSlideHelper::traverseDirectory($images, $dir, $regex, $folder);
      sort( $images );
    }
    if ( $params->get('random_sort') == '1' ) {
      shuffle($images);
    }

    return $images;
  }

  /**
   * Gets the images specified in the xml file
   *
   * @param  array module params
   * @param  string dir image path
   *
   * @return images
   *
   */
  function getImagesFromXMLFile( &$params, $dir ) {
    // check if directory exists
    if (is_dir($dir)) {
      $i        = 0;
      $xml_path = $dir."mod_powerslide.xml";
      if (file_exists($xml_path)) {
        $xml = @simplexml_load_file($xml_path);
        foreach( $xml->gallery[0]->image as $image ) {
          $images[$i] = $image;
          $i++;
        }
      } else {
        exit( "Failed to open $xml_path." );
      }
    }
    if ( $params->get('random_sort') == '1' ) {
      shuffle( $images );
    }
    return $images;
  }
}
?>
