<?php
/*
 * @component AlphaUserPoints
 * @copyright Copyright (C) 2008 Bernard Gilly
 * @license : GNU/GPL
 * @Website : http://www.alphaplug.com
 */

// Check to ensure this file is included in Joomla!
defined( '_JEXEC' ) or die( 'Restricted access' );

jimport( 'joomla.plugin.plugin' );

/**
 * AlphaUserPoints Content Plugin
 *
 * @package		Joomla
 * @subpackage	AlphaUserPoints
 * @since 		1.5
 */

class plgContentsysplgaup_raffle extends JPlugin
{

	function plgContentsysplgaup_raffle( &$subject, $params )
	{
		parent::__construct( $subject, $params );
	}


	function onPrepareContent( &$article, &$params, $limitstart )
	{
		global $mainframe;
		
		$db	   =& JFactory::getDBO();
		$user = & JFactory::getUser();
		
		$print  			= JRequest::getVar('print', '');
		$format 			= JRequest::getVar('format', '');
		
		$aupraffleid 		= JRequest::getVar('aupraffleid', 0, 'POST', 'int');		
		$aupraffleuserid 	= JRequest::getVar('aupraffleuserid', 0, 'POST', 'int');
		$auprafflepoints	= JRequest::getVar('auprafflepoints', 0, 'POST', 'int');
		$auprafflepointsremove = JRequest::getVar('auprafflepointsremove', 0, 'POST', 'int');
		
		$inscription = 0;
		$pointstoparticipate = 0;
		$removepointstoparticipate =  0;
		
		if ( !$user->id || $print || $format=='pdf' ) {
			$article->text = preg_replace( " |{AUP::RAFFLE=(.*)}| ", "", $article->text );
			return;
		}
		
		if ($mainframe->isAdmin()) return;
		
		JPlugin::loadLanguage( 'com_alphauserpoints' );		
		
		$api_AUP = JPATH_SITE.DS.'components'.DS.'com_alphauserpoints'.DS.'helper.php';
		require_once ($api_AUP);
		
		if ( preg_match('#{AUP::RAFFLE=(.*)}#Uis', $article->text, $m) && !$aupraffleid )
		{
			$raffleid = $m[1];
			
			$query = "SELECT * FROM #__alpha_userpoints_raffle WHERE `id`='$raffleid' AND `published`='1'";						
			$db->setQuery( $query );
			$result = $db->loadObjectList();			
			if ( $result ) 
			{
				$inscription = $result[0]->inscription;
				$pointstoparticipate = $result[0]->pointstoparticipate;
				$removepointstoparticipate = $result[0]->removepointstoparticipate;
			} 
			
			if ( $inscription ) 
			{							
				$query = "SELECT userid FROM #__alpha_userpoints_raffle_inscriptions WHERE `userid`='$user->id' AND `raffleid`='$raffleid'";
				$db->setQuery( $query );
				$userid = $db->loadResult();
				
				if ( !$userid )
				{				
					$registrationForm = "\n<form action=\"\" method=\"post\" name=\"RaffleForm\">\n"
										. "<input type=\"hidden\" name=\"aupraffleid\" id=\"aupraffleid\" value=\"".$raffleid."\" />\n"
										. "<input type=\"hidden\" name=\"aupraffleuserid\" id=\"aupraffleuserid\" value=\"".$user->id."\" />\n"
										. "<input type=\"hidden\" name=\"auprafflepoints\" id=\"auprafflepoints\" value=\"".$pointstoparticipate."\" />\n"
										. "<input type=\"hidden\" name=\"auprafflepointsremove\" id=\"auprafflepointsremove\" value=\"".$removepointstoparticipate."\" />\n"
										. "<input class=\"button\" type=\"submit\" name=\"Submit\" value=\"".JText::_('AUP_SIGNUP_FOR_THIS_RAFFLE_NOW')."\" />\n"
										."</form>\n";
				
					if ( $pointstoparticipate ) 
					{
						$referreid = AlphaUserPointsHelper::getAnyUserReferreID( $user->id );
						$currentpoints = AlphaUserPointsHelper::getCurrentTotalPoints ( $referreid );
						if ( $currentpoints>=$pointstoparticipate )						
						{
							$article->text .= $registrationForm;
						}
						else
						{
							$article->text .= "\n<p>".JText::_('AUP_YOUDONOTHAVEENOUGHPOINTSTOPERFORMTHISOPERATION')."</p>\n";
						}
					}
					else
					{					
						$article->text .= $registrationForm;
					}									
				}
				else
				{
					$article->text .= "\n<p>".JText::_('AUP_ALREADY_REGISTERED_FOR_THIS_RAFFLE')."</p>\n";
				}
			}					
		} 
		elseif ( preg_match('#{AUP::RAFFLE=(.*)}#Uis', $article->text, $m) && $aupraffleid && $aupraffleuserid ) 
		{		
			$query = "SELECT userid FROM #__alpha_userpoints_raffle_inscriptions WHERE `userid`='$aupraffleuserid' AND `raffleid`='$aupraffleid'";
			$db->setQuery( $query );
			$registration = $db->loadResult();
			
			if ( !$registration )
			{
				//Save registration
				JTable::addIncludePath(JPATH_ADMINISTRATOR.DS.'components'.DS.'com_alphauserpoints'.DS.'tables');					
				$row =& JTable::getInstance('raffle_inscriptions');
				$row->id				= NULL;
				$row->raffleid			= $aupraffleid;
				$row->userid			= $aupraffleuserid;
				if ( !$row->store() )
				{
					JError::raiseError(500, $row->getError());
				} 
				else 
				{
					// remove points if necessary
					if ( $auprafflepointsremove && $auprafflepoints ) {
						AlphaUserPointsHelper::newpoints( 'sysplgaup_raffle', '', '', JText::_('AUP_LABEL_REGISTRATION_RAFFLE'), (abs($auprafflepoints)*(-1)) );
					}					
					$mainframe->enqueueMessage( JText::_('AUP_CONFIRM_RAFFLE_REGISTRATION') );
					$article->text .= "\n<p>".JText::_('AUP_ALREADY_REGISTERED_FOR_THIS_RAFFLE')."</p>\n";
				}			
			} else $article->text .= "\n<p>".JText::_('AUP_ALREADY_REGISTERED_FOR_THIS_RAFFLE')."</p>\n";
		
		}		
		$article->text = preg_replace( " |{AUP::RAFFLE=(.*)}| ", "", $article->text );
	}
}
?>