<?php
/*
 * @component AlphaUserPoints
 * @copyright Copyright (C) 2008-2009 Bernard Gilly
 * @license : GNU/GPL
 * @Website : http://www.alphaplug.com
 */

// Check to ensure this file is included in Joomla!
defined( '_JEXEC' ) or die( 'Restricted access' );

jimport( 'joomla.plugin.plugin' );

/**
 * AlphaUserPoints Content Plugin
 *
 * @package		Joomla
 * @subpackage	AlphaUserPoints
 * @since 		1.5
 */

class plgContentsysplgaup_reader2author extends JPlugin
{

	function plgContentsysplgaup_reader2author( &$subject, $params )
	{
		parent::__construct( $subject, $params );
	}


	function onAfterDisplayContent( &$article, &$params, $limitstart )
	{
		global $mainframe;
		
		$user = & JFactory::getUser();	
		
		$authorid  = $article->created_by;
		$articleid = $article->id;
		
		//if ($mainframe->isAdmin() || !$user->id || $user->id==$authorid || !$articleid ) return;		
		if ($mainframe->isAdmin() || $user->id==$authorid || !$articleid ) return;		
		
		$option = JRequest::getCmd('option', '');
		$view   = JRequest::getVar('view',   '');		

		switch ( $view ) {
			case 'article' :
				if ( $option=='com_content' && $limitstart==0 ) {
					JPlugin::loadLanguage( 'com_alphauserpoints' );
					require_once (JPATH_SITE.DS.'components'.DS.'com_alphauserpoints'.DS.'helper.php');
					
					// Rule reader to author (guest and registered)
					$authorarticle = ($article->created_by_alias) ? $article->created_by_alias : $article->author;
					AlphaUserPointsHelper::reader2author($authorid, $authorarticle, $articleid, $article->title, JURI::current());
					
					// Rule read article (only for registered not guest user)
					if ( $user->id ) {
						$datareference = '<a href="' . JURI::current() . '">' . $article->title . '</a>' ;
						if ( AlphaUserPointsHelper::userpoints( 'sysplgaup_readarticle', '', 0, $articleid, $datareference, '', true )===false )
						{
							$mainframe->redirect('index.php');
						}
					}
				}
				break;
			default:					
		}	
	}
}
?>