<?php
/**
* @version		$Id: radio.php 10707 2008-08-21 09:52:47Z eddieajau $
* @package		Joomla.Framework
* @subpackage	Parameter
* @copyright	Copyright (C) 2005 - 2008 Open Source Matters. All rights reserved.
* @license		GNU/GPL, see LICENSE.php
* Joomla! is free software. This version may have been modified pursuant
* to the GNU General Public License, and as distributed it includes or
* is derivative of works licensed under the GNU General Public License or
* other free or open source software licenses.
* See COPYRIGHT.php for copyright notices and details.
*/

// Check to ensure this file is within the rest of the framework
defined('JPATH_BASE') or die();

/**
 * Renders a radio element
 *
 * @package 	Joomla.Framework
 * @subpackage		Parameter
 * @since		1.5
 */

class JElementButtonGroup extends JElement
{
	/**
	* Element name
	*
	* @access	protected
	* @var		string
	*/
	var	$_name = 'ButtonGroup';
	
	var $_script = false;

	function fetchElement($name, $value, &$node, $control_name)
	{	
		jimport('joomla.application.component.helper');
		$doc = & JFactory::getDocument();
		$scope = $node->attributes('scope');
		$class = $node->attributes('class');
		$options = array ();
		$html    = array();
		$html[]    = '
<span id="'.$name.'" class="nf-filterset fg-buttonset fg-buttonset-single nf-buttonset-group ui-corner-all ui-widget-header '.$class.'">
';			$i = 1;
			$c = count($node->children());
			foreach ($node->children() as $option)
			{
				$val	= $option->attributes('value');
				// Lazy code below
				$childclass  = null;
				$childclass .= $option->attributes('childclass');
				if ($option->attributes('com'))
				{
					$compare = JComponentHelper::getComponent($option->attributes('com'), true);
					if($compare->enabled) {
						$valid = true;
					}
					else
					{
						$valid = false;
					}
				}
				else
				{
					$valid = true;
				}

				$priority = ( $option->attributes('promo') ? true : false );
				
				if($priority && !$valid && !($value==$val))
				{
					$priorityClass 	= ' ui-priority-primary ui-priority-secondary ui-state-highlight fg-button fg-button-icon-left ';
					$icon 			= '<span class="ui-icon ui-icon-info"></span>';
					$error 			= false;
				}
				elseif($value==$val && !$valid)
				{
					$priorityClass 	= ' ui-priority-primary ui-state-error fg-button fg-button-icon-left ';
					$icon 			= '<span class="ui-icon ui-icon-alert"></span>';
					$error 			= true;
				}
				elseif($value==$val)
				{
					$priorityClass	= ' ui-priority-primary ';
					$icon			= '<span class="ui-icon ui-icon-radio-off fm m-invert m-'.$val.' hasTip" title="This your previously saved selection"></span><span class="ui-icon ui-icon-radio-on fm m-'.$val.' hasTip" title="This your previously saved selection"></span>';
					$error 			= false;
				}
				else
				{
					$priorityClass 	= ' ui-priority-primary ';
					$icon			= null;
					$error 			= false;
				}
				
				$text	= $option->data();
				$active = ( $value==$val ? ' ui-state-active ui-state-original fg-button-icon-left ' : '' );
				$left   = ( $i===1 ? /*'ui-corner-left'*/ '' : '' );
				$right  = ( $i===$c ? /*'ui-corner-right'*/ '' : '' );
				if($valid||$priority||$error)
				{
					$html [] = '<a href="#'.$val.'" class="all fg-button ui-filter-trigger ui-state-default '.$left . $right . $priorityClass . $childclass . $active.'">'.$icon.$text.'</a>';
				}
				$i++;
				$valid = null;
			}//end foreach
			//Save which button are active
			$html[] = '<input type="hidden" name="'.$control_name.'['.$name.']" value="'.$value.'" class="ui-filter-avoid" /></span>';
				$script = "
			jQuery(document).ready(function($){			
				$('.nf-filterset.fg-buttonset').livequery('filter', function(){
					var check = $(this).children().filter('.ui-state-default:not(.ui-state-disabled)').is('.ui-state-active');
					if(!check)
					{
						var one = false;
						$(this).children().filter('.ui-state-default:not(.ui-state-disabled)').each(function(){
							if(!one)
							{
								$(this).mousedown().mouseup();
								one = true;
							}
						});
					} 
					else 
					{
						var one = false;
						$(this).children().filter('.ui-state-default.ui-state-active').each(function(){
							if(!one)
							{
								$(this).mousedown().mouseup();
								one = true;
							}
						});
					}
					var activeValue = $(this).children().filter('.ui-state-active').attr('href');
					$(this).children().filter('input').val(activeValue.replace(/#/gi, ''));
				});
				$('.nf-filterset.fg-buttonset .fg-button:visible').livequery('click', function(){
					$(this).trigger('filterme').trigger('filter');
				});
			});";
		if(!defined($node->attributes('type'))) 
		{
			$doc->addScriptDeclaration($script);
			define($node->attributes('type'), '1');
		}
		return implode("\n", $html);
	}
}