<?php
/**
* @version		$Id: article.php 10381 2008-06-01 03:35:53Z pasamio $
* @package		Joomla
* @copyright	Copyright (C) 2005 - 2008 Open Source Matters. All rights reserved.
* @license		GNU/GPL, see LICENSE.php
* Joomla! is free software. This version may have been modified pursuant
* to the GNU General Public License, and as distributed it includes or
* is derivative of works licensed under the GNU General Public License or
* other free or open source software licenses.
* See COPYRIGHT.php for copyright notices and details.
*/

// Check to ensure this file is included in Joomla!
defined('_JEXEC') or die( 'Restricted access' );

class JElementK2 extends JElement
{
	/**
	 * Element name
	 *
	 * @access	protected
	 * @var		string
	 */
	var	$_name = 'k2';

	function fetchElement($name, $value, &$node, $control_name)
	{
		global $mainframe;
		$com_k2 = JComponentHelper::getComponent('com_k2', true);
		if(!$com_k2->enabled) 
		{	
			return false;
		}
		else 
		{

			$db			=& JFactory::getDBO();
			$doc 		=& JFactory::getDocument();
			$template 	= $mainframe->getTemplate();
			$fieldName	= $control_name.'['.$name.']';
			$class      = ( $node->attributes('class') ? ' class="'.$node->attributes('class').'" ' : '');
			JTable::addIncludePath(JPATH_ADMINISTRATOR.DS.'components'.DS.'com_k2'.DS.'tables');
			$item = & JTable::getInstance('K2Item', 'Table');
			if ($value) {
				$item->load($value);
				$descr = JText::_('Caution! By selecting a new article it\'ll replace your previous selection. Click to open a modal window and pick your content item.');
			} else {
				$item->title = JText::_('Select an Item');
				$descr = JText::_('Click to open a modal window and pick your content item.');
			}
	
			$js = "
			var k2input = '$name';
			
			function k2object(object)
			{
				k2input = object;
			}
			function jSelectItem(kid, title, object) {
				jQuery('#'+k2input).val(kid);
				jQuery('#'+k2input+'_name').val(title);
				jQuery('#sb-nav-close').click();
			}";
			$doc->addScriptDeclaration($js);
			$link = 'index.php?option=com_k2&amp;view=items&amp;task=element&amp;tmpl=component&amp;object='.$name;
	
			//TODO remove shitty inline css
			JHTML::_('behavior.shadowbox');
			$html = '<span class="ui-helper-clearfix ui-resizable"><input type="text" name="'.$control_name.'['.$name.'_name]" id="'.$control_name.$name.'_name" value="'.$item->title.'" class="text ui-widget-content ui-corner-all ui-state-disabled ui-width 60" disabled="disabled" size="20">';
			$html .= '<a href="'.$link.'" title="'.JText::_('Select an Item').'::'.$descr.'" class="fg-button ui-state-default ui-width-40 fg-button-icon-right modal shadowbox hasTip ui-corner-right text ui-widget-content" rel="shadowbox;height=375;width=650;title=Select Article;" onclick="javascript:k2object(\''.$control_name.$name.'\');"><span class="ui-icon ui-icon-newwin"></span>'.htmlspecialchars(JText::_('Select an item from K2'), ENT_QUOTES, 'UTF-8').'</a>   
			';
			$html .= "\n".'</span><input type="hidden" class="k2item_id" '.$class.' id="'.$control_name.$name.'" name="'.$fieldName.'" value="'.(int)$value.'" />';
		} 
		return $html;
	}
}
