<?php
/**
* @version		$Id: author.php 10381 2008-06-01 03:35:53Z pasamio $
* @package		Joomla
* @subpackage	Articles
* @copyright	Copyright (C) 2005 - 2008 Open Source Matters. All rights reserved.
* @license		GNU/GPL, see LICENSE.php
* Joomla! is free software. This version may have been modified pursuant
* to the GNU General Public License, and as distributed it includes or
* is derivative of works licensed under the GNU General Public License or
* other free or open source software licenses.
* See COPYRIGHT.php for copyright notices and details.
*/

// Check to ensure this file is included in Joomla!
defined('_JEXEC') or die( 'Restricted access' );

/**
 * Renders a author element
 *
 * @package 	Joomla
 * @subpackage	Articles
 * @since		1.5
 */

class NParameter extends JParameter
{
	/**
	 * The raw params string
	 *
	 * @access	private
	 * @var		string
	 * @since	1.5
	 */
	var $_raw = null;

	/**
	 * The xml params element
	 *
	 * @access	private
	 * @var		object
	 * @since	1.5
	 */
	var $_xml = null;

	/**
	* loaded elements
	*
	* @access	private
	* @var		array
	* @since	1.5
	*/
	var $_elements = array();

	/**
	* directories, where element types can be stored
	*
	* @access	private
	* @var		array
	* @since	1.5
	*/
	var $_elementPath = array();

	/**
	 * Constructor
	 *
	 * @access	protected
	 * @param	string The raw parms text
	 * @param	string Path to the xml setup file
	 * @since	1.5
	 */
	function __consstruct($data, $path = '', $replace = null, $with = null)
	{
		parent::__construct('_default');

		// Set base path
		$this->_elementPath[] = dirname( __FILE__ ).DS.'parameter'.DS.'element';

		if (trim( $data )) {
			$this->loadINI($data);
		}

		if ($path) {
			$this->loadSetupFile($path);
		}

		$this->_raw = $data;
	}

	/**
	 * Set a value
	 *
	 * @access	public
	 * @param	string The name of the param
	 * @param	string The value of the parameter
	 * @return	string The set value
	 * @since	1.5
	 */
	function set($key, $value = '', $group = '_default')
	{
		return $this->setValue($group.'.'.$key, (string) $value);
	}

	/**
	 * Get a value
	 *
	 * @access	public
	 * @param	string The name of the param
	 * @param	mixed The default value if not found
	 * @return	string
	 * @since	1.5
	 */
	function get($key, $default = '', $group = '_default')
	{
		$value = $this->getValue($group.'.'.$key);
		$result = (empty($value) && ($value !== 0) && ($value !== '0')) ? $default : $value;
		return $result;
	}

	/**
	 * Sets a default value if not alreay assigned
	 *
	 * @access	public
	 * @param	string	The name of the param
	 * @param	string	The value of the parameter
	 * @param	string	The parameter group to modify
	 * @return	string	The set value
	 * @since	1.5
	 */
	function def($key, $default = '', $group = '_default') {
		$value = $this->get($key, (string) $default, $group);
		return $this->set($key, $value);
	}

	/**
	 * Sets the XML object from custom xml files
	 *
	 * @access	public
	 * @param	object	An XML object
	 * @since	1.5
	 */
	function setXML( &$xml )
	{
		if (is_object( $xml ))
		{
			if ($group = $xml->attributes( 'group' )) {
				$this->_xml[$group] = $xml;
			} else {
				$this->_xml['_default'] = $xml;
			}
			if ($dir = $xml->attributes( 'addpath' )) {
				$this->addElementPath( JPATH_ROOT . str_replace('/', DS, $dir) );
			}
		}
	}

	/**
	 * Bind data to the parameter
	 *
	 * @param	mixed	$data Array or Object
	 * @return	boolean	True if the data was successfully bound
	 * @access	public
	 * @since	1.5
	 */
	function stianbind($data, $group = '_default')
	{
		if ( is_array($data) ) {
			return $this->loadArray($data, $group);
		} elseif ( is_object($data) ) {
			return $this->loadObject($data, $group);
		} else {
			return $this->loadINI($data, $group);
		}
	}

	/**
	 * Render
	 *
	 * @access	public
	 * @param	string	The name of the control, or the default text area if a setup file is not found
	 * @return	string	HTML
	 * @since	1.5
	 */
	function stianrender($name = 'params', $group = '_default')
	{
		if (!isset($this->_xml[$group])) {
			return false;
		}

		$params = $this->getParams($name, $group);
		$html = array ();
		$html[] = '<table width="100%" class="paramslist admintable" cellspacing="1">';

		if ($description = $this->_xml[$group]->attributes('description')) {
			// add the params description to the display
			$desc	= JText::_($description);
			$html[]	= '<tr><td class="paramlist_description" colspan="2">'.$desc.'</td></tr>';
		}

		foreach ($params as $param)
		{
			$html[] = '<tr>';

			if ($param[0]) {
				$html[] = '<td width="40%" class="paramlist_key"><span class="editlinktip">'.$param[0].'</span></td>';
				$html[] = '<td class="paramlist_value">'.$param[1].'</td>';
			} else {
				$html[] = '<td class="paramlist_value" colspan="2">'.$param[1].'</td>';
			}

			$html[] = '</tr>';
		}

		if (count($params) < 1) {
			$html[] = "<tr><td colspan=\"2\"><i>".JText::_('There are no Parameters for this item')."</i></td></tr>";
		}

		$html[] = '</table>';

		return implode("\n", $html);
	}

	/**
	 * Render all parameters to an array
	 *
	 * @access	public
	 * @param	string	The name of the control, or the default text area if a setup file is not found
	 * @return	array	Array of all parameters, each as array Any array of the label, the form element and the tooltip
	 * @since	1.5
	 */
	function renderToArray($name = 'params', $group = '_default')
	{
		if (!isset($this->_xml[$group])) {
			return false;
		}
		$results = array();
		foreach ($this->_xml[$group]->children() as $param)  {
			$result = $this->getParam($param, $name);
			$results[$result[5]] = $result;
		}
		return $results;
	}

	/**
	 * Return number of params to render
	 *
	 * @access	public
	 * @return	mixed	Boolean falst if no params exist or integer number of params that exist
	 * @since	1.5
	 */
	function getNumParams($group = '_default')
	{
		if (!isset($this->_xml[$group]) || !count($this->_xml[$group]->children())) {
			return false;
		} else {
			return count($this->_xml[$group]->children());
		}
	}

	/**
	 * Get the number of params in each group
	 *
	 * @access	public
	 * @return	array	Array of all group names as key and param count as value
	 * @since	1.5
	 */
	function getGroups()
	{
		if (!is_array($this->_xml)) {
			return false;
		}
		$results = array();
		foreach ($this->_xml as $name => $group)  {
			$results[$name] = $this->getNumParams($name);
		}
		return $results;
	}

	/**
	 * Render all parameters
	 *
	 * @access	public
	 * @param	string	The name of the control, or the default text area if a setup file is not found
	 * @return	array	Aarray of all parameters, each as array Any array of the label, the form element and the tooltip
	 * @since	1.5
	 */
	function stiangetParams($name = 'params', $group = '_default')
	{
		if (!isset($this->_xml[$group])) {
			return false;
		}
		$results = array();
		foreach ($this->_xml[$group]->children() as $param)  {
			$results[] = $this->getParam($param, $name);
		}
		return $results;
	}

	/**
	 * Render a parameter type
	 *
	 * @param	object	A param tag node
	 * @param	string	The control name
	 * @return	array	Any array of the label, the form element and the tooltip
	 * @since	1.5
	 */
	function getParam(&$node, $control_name = 'params', $group = '_default')
	{
		//get the type of the parameter
		$type = $node->attributes('type');

		//remove any occurance of a mos_ prefix
		$type = str_replace('mos_', '', $type);

		$element =& $this->loadElement($type);

		// error happened
		if ($element === false)
		{
			$result = array();
			$result[0] = $node->attributes('name');
			$result[1] = JText::_('Element not defined for type').' = '.$type;
			$result[5] = $result[0];
			return $result;
		}

		//get value & add name suffix
		$name = $node->attributes('name');
		$node->removeAttribute('name');
		$node->addAttribute('name', $name.'greedy');
		$value = $this->get($node->attributes('name'), $node->attributes('default'), $group);
		echo 'stian';

		return $element->render($node, $value, $control_name);
	}

	/**
	 * Loads an xml setup file and parses it
	 *
	 * @access	public
	 * @param	string	path to xml setup file
	 * @return	object
	 * @since	1.5
	 */
	function stianloadSetupFile($path, $with = null, $replace = null)
	{
		$result = false;

		if ($path)
		{
			$xml = & JFactory::getXMLParser('Simple');

			if ($xml->loadFile($path))
			{
				if ($params = & $xml->document->params) {
					foreach ($params as $param)
					{
						$this->searchReplace($this->setXML( $param ), '@', 'stian');
						$result = true;
					}
				}
			}
		}
		else
		{
			$result = true;
		}

		return $result;
	}

	/**
	 * Loads a element type
	 *
	 * @access	public
	 * @param	string	elementType
	 * @return	object
	 * @since	1.5
	 */
	function &stianloadElement( $type, $new = false )
	{
		$false = false;
		$signature = md5( $type  );

		if( (isset( $this->_elements[$signature] ) && !is_a($this->_elements[$signature], '__PHP_Incomplete_Class'))  && $new === false ) {
			return	$this->_elements[$signature];
		}

		$elementClass	=	'JElement'.$type;
		if( !class_exists( $elementClass ) )
		{
			if( isset( $this->_elementPath ) ) {
				$dirs = $this->_elementPath;
			} else {
				$dirs = array();
			}

			$file = JFilterInput::clean(str_replace('_', DS, $type).'.php', 'path');

			jimport('joomla.filesystem.path');
			if ($elementFile = JPath::find($dirs, $file)) {
				include_once $elementFile;
			} else {
				return $false;
			}
		}

		if( !class_exists( $elementClass ) ) {
			return $false;
		}

		$this->_elements[$signature] = new $elementClass($this);

		return $this->_elements[$signature];
	}

	/**
	 * Add a directory where JParameter should search for element types
	 *
	 * You may either pass a string or an array of directories.
	 *
	 * JParameter will be searching for a element type in the same
	 * order you added them. If the parameter type cannot be found in
	 * the custom folders, it will look in
	 * JParameter/types.
	 *
	 * @access	public
	 * @param	string|array	directory or directories to search.
	 * @since	1.5
	 */
	function stianaddElementPath( $path )
	{
		// just force path to array
		settype( $path, 'array' );

		// loop through the path directories
		foreach ( $path as $dir )
		{
			// no surrounding spaces allowed!
			$dir = trim( $dir );

			// add trailing separators as needed
			if ( substr( $dir, -1 ) != DIRECTORY_SEPARATOR ) {
				// directory
				$dir .= DIRECTORY_SEPARATOR;
			}

			// add to the top of the search dirs
			array_unshift( $this->_elementPath, $dir );
		}


	}
	
	function searchReplace($from, $with = null, $replace = null)
	{
		$from = preg_replace( '/'.$replace.'/', $with, $from );
		return $from;
	}
}
 
class JElementLoopGroup extends JElement
{
	/**
	 * Element name
	 * @access	protected
	 * @var		string
	 */
	var	$_name = 'LoopGroup';
	
	function fetchElement($name, $value, &$node, $control_name)
	{	
		$howmany = $value;
		$doc = & JFactory::getDocument();
		$style = "
#$name {
	border-top-width: 0px;
	border-right-width: 0px;
	border-bottom-width: 0px;
	border-left-width: 0px;
	}";
		$doc->addStyleDeclaration($style);
		$doc->addScript("http://ajax.googleapis.com/ajax/libs/jquery/1.3/jquery.min.js");
		
		$return	= null;
		$group = $node->attributes('loadgroup', 'loop');
		$order = $node->attributes('order', '0');
		$titleprefix = $node->attributes('titleprefix', 'Tab ');
		$placeholder = $node->attributes('placeholder', '');
		$tab = &JPane::getInstance('tabs');

		$id 	= JRequest::getInt('id');
		if (!$id) { 
			$id = reset(JRequest::getVar( 'cid', array())); 
		}
		$db 	=& JFactory::getDBO();
		$query = 'SELECT params'
		. ' FROM #__modules'
		. ' WHERE id ='. $id;
		$db->setQuery( $query );
		$values = $db->loadResult();

		$loop = new NParameter($values, JPATH_ROOT.DS.'modules'.DS.'mod_ninjatabs'.DS.'mod_ninjatabs.xml');
		$loopcontent = '';
		$container = $this->javascriptHTML(' <div id="'.$name.'" class="panel"> 
		'.$tab->startPane($control_name.$name).$tab->endPane().'</div>');
		//$value = explode(', ', $value);
		$switch = ($value==='1'?'one':(is_numeric($value)?'loop':'foreach'));
		switch($switch) {
			case 'one':
				$loopcontent = $this->javascriptHTML($this->setLoopName($placeholder, '0', ($tab->startPanel($titleprefix.'1', $name.'-tab').$loop->render('params', $group).$tab->endPanel())));
				break;
			case 'loop':
				$i = 0;
				while ($i < $value) {
					$loopcontent .= $this->javascriptHTML($this->setLoopName($placeholder, $i, ($tab->startPanel($titleprefix.($i+1), $name.'-tab').$loop->render('params', $group).$tab->endPanel())));
					//echo $this->javascriptHTML($this->setLoopName($placeholder, $i, ($tab->startPanel($titleprefix.($i+1), $name.'-tab').$loop->render('params', $group).$tab->endPanel())));
				$i++;}
				break;
			case 'foreach':
				echo 'nah!';
				break;
		}
		
		//Create variables to avoid conflicts if more than one dynLoop are rolling and more.
		$jqname = $name;
		$jqhtml = $loop->render('params', $group);
		$values = explode("\n", $values);
		$defaults = array();
		$i = null;
		$c = 1;
		$count = count($values);
		
		//print_r($values);
		foreach($values as $value) {
			$tmp = split('[=]', $value);
			if(isset($tmp[0])){
				$jqparam = array($tmp[0]);
				foreach($jqparam as $key => $default) {
					$jqparam = $default;
				}
			} else {
				$jqparam = null;
			}
			$i = (($count===$c)?"\n":",\n");
			
			if((isset($tmp[1]))&&(isset($jqparam))){
				$jqvalue = array($tmp[1]);
				foreach($jqvalue as $key => $default) {
				$default = $this->javascriptHTML($default);
				$defaults[] =	"$jqparam: \"$default\"";
				}
			} 
		}
		$defaults = $this->setLoopName($placeholder, '', implode(",\n", $defaults));
		$script = "
			jQuery.noConflict();

			jQuery(document).ready(function($){
				$('$container').insertBefore($('#menu-pane').children().eq($order));
				$('$loopcontent').appendTo($('#$control_name$name'));
                $('#delete-$name').appendTo('#footer');
				var loopTimes	= $('#$control_name$name').val();
				var defaults = {
$defaults
						};
				var loopOnLoad = function(loopTimes, start) 
				{	
					var limitstart = $('#dynTabs dt').length;
					var current = ' ';
					
					$('#dynTabs .current').fadeOut;
					
					var i=0;
					for (i=1;i<=loopTimes;i++)
					{
							$('#ajax-$name').children().eq(0).clone().attr('id', ('tab-'+(i+limitstart))).appendTo('#dynTabs .tabs');
							$('#ajax-$name').children().eq(1).clone().appendTo('#dynTabs .tabs').hide();
					}
					$('#dynTabs dt.open').show();

					$('#dynTabs dt').children().each(function(i){
						var no = i+1;
						$(this).html('Tab <span>'+(no)+'</span>');
					});
				
					$('#dynTabs dd').each(function(i){
					var countLoop = i;
						$('#dynTabs dd:eq('+i+') .paramlist_value').each(function(i){
							$(this).contents().filter(':input').each(function(i){
								function thisName(str) {
									return str.replace(/^params\[+|\]+$/g, '');
								}
								$(this).attr('name', ('params['+thisName($(this).attr('name'))+countLoop+']'));
							});
						});
					});
					for(key in defaults) {
						$('[name=\"params\['+key+'\]\"]:not(:radio, )').not('#$control_name$name').val(defaults[key]);
					}
				}
				
				loopOnLoad(loopTimes);
				
				$('#$control_name$name').change(function(){
					if(($('#$control_name$name').val())>($('#dynTabs dd').length)){
						loopOnLoad(  (  $('#$control_name$name').val()  )  -  (  $('#dynTabs dd').length  ), $('#dynTabs dd').length    );
					}
				});
				
			});";
		$doc->addScriptDeclaration($script);
		echo 'modname'.$row->module;
		return '<input type="hidden" name="'.$control_name.'['.$name.']" id="'.$control_name.$name.'" value="'.$howmany.'" />';	
	}
	
	function setLoopName($replace, $with, $from)
	{
		$from = preg_replace( '/'.$replace.'/', $with, $from );
		return $from;
	}
	
	function javascriptHTML($text)
	{
		$text = trim( preg_replace( '/\s+/', ' ', $text ) ); 
		$text = trim( preg_replace( "/'/", "\'", $text ) );
		//$text = ereg_replace('"','\"', $text);
		return $text;
	}
}