<?php
/**
* @version		$Id: radio.php 10707 2008-08-21 09:52:47Z eddieajau $
* @package		Joomla.Framework
* @subpackage	Parameter
* @copyright	Copyright (C) 2005 - 2008 Open Source Matters. All rights reserved.
* @license		GNU/GPL, see LICENSE.php
* Joomla! is free software. This version may have been modified pursuant
* to the GNU General Public License, and as distributed it includes or
* is derivative of works licensed under the GNU General Public License or
* other free or open source software licenses.
* See COPYRIGHT.php for copyright notices and details.
*/

// Check to ensure this file is within the rest of the framework
defined('JPATH_BASE') or die();

/**
 * Renders a radio element
 *
 * @package 	Joomla.Framework
 * @subpackage		Parameter
 * @since		1.5
 */

class JElementScroller extends JElement
{
	/**
	* Element name
	*
	* @access	protected
	* @var		string
	*/
	var	$_name = 'Scroller';

	function fetchElement($name, $value, &$node, $control_name)
	{
		$order  = $node->attributes('order', '0');
		$target = $node->attributes('target');
		$filter = $node->attributes('filter');
		$fadeout = $node->attributes('fadeout');
		$fadein = $node->attributes('fadein');
		$update = $node->attributes('update');
		$thumbpath = ( $node->attributes('thumbpath') ? JURI::root(true).$node->attributes('thumbpath') : JURI::root(true).'/media/napi/img/tmpl/' );
		
		$options 	= array ();
		$children 	= '';
		$count		= 0;
		$multiplier	= '128';
		$leftMargin	= '0';
		foreach ($node->children() as $option)
		{
			$val	= $option->attributes('value');
			$text	= $option->data();
			$thumb	= ( $option->attributes('thumbnail') ? 'style="background-image: url('.$thumbpath.$option->attributes('thumbnail').');"' : '' );
			$style  = ( $thumb ? 'thumb ui-corner-all' : '' );
			$active = ( $value===$val ? ' active ' : '' );
			if($active) { $leftMargin = $count * $multiplier; } elseif($count===0||$count) { $count++; };
			$children  .= ' <div id="'.$val.'" class="'.$style.$active.'"><img src="'.$thumbpath.$option->attributes('thumbnail').'" title="'.JText::sprintf('%s plugin', $val).'" alt="'.JText::sprintf('%s plugin', $val).'" class="ui-corner-all"><span>'.JText::_($text).'</span></div>';
		}
		$html    = '
<div id="'.$control_name.$name.'" class="scrollable-wrap ui-corner-all panel">
	<!-- navigator -->
	<div class="navi"></div>
	
	<!-- prev link -->
	<a class="prevPage ui-icon ui-icon-circle-triangle-w"></a>
	
	<!-- root element for scrollable -->
	<div class="scrollable">
		<!-- root element for the items -->
		<div class="items">
			'.$children .'
		</div>
		
	</div>
	
	<!-- next link -->
	<a class="nextPage ui-icon ui-icon-circle-triangle-e"></a>
	<!-- power tag: let rest of the page layout normally --> 
	<input type="hidden" name="'.$control_name.'['.$name.']" id="'.$control_name.$name.'-val" value="'.$value.'" />
	<div style="display:block;clear:both;width:100%;"></div>
	<!--<div class="scrollable-status">Test</div>-->
</div>';
		
		$doc = & JFactory::getDocument();
		$doc->addScript(JURI::root(true)."/media/napi/js/jquery.scrollable-1.0.2.min.js");
		$doc->addScript(JURI::root(true)."/media/napi/js/jquery.mousewheel.js");
		$doc->addStyleSheet(JURI::root(true).'/media/napi/css/scrollable-minimal.css');
	
		$script = "
		jQuery.noConflict();
 
		jQuery(document).ready(function($){
			$(window).load(function () {
					$('#$control_name$name div.scrollable .items div.active').triggerHandler('click');
				});
			$('#$control_name$name div.scrollable .items div').live('click', function() {
				$('#$control_name$name-val').val($('#$control_name$name div.scrollable .items div.active').attr('id'));
			});
			$('#$control_name$name').prependTo('#menu-pane');
			$('#$control_name$name div.scrollable').scrollable({size: Math.floor($('#$control_name$name .scrollable').width()/$('#$control_name$name .scrollable .items > :first').outerWidth(true)) });
	    	
	    	//Initiate first theme
	    	var api = $('#$control_name$name div.scrollable').scrollable();
	    	var mainNavLinks = $('#$control_name$name div.scrollable .items .thumb');
			mainNavLinks.one('click', function(){
				api.seekTo(mainNavLinks.index(this));
			});
		});";
		
		$doc->addScriptDeclaration($script);
		$doc->addStyleDeclaration('.hidden{display:none;} .jpane-slider.content{overflow:hidden;}');
		return $html;
	}
	
	function fetchToolTip()
	{
		return false;
	}
}