<?php
/**
* @version		$Id: text.php 10707 2008-08-21 09:52:47Z eddieajau $
* @package		Joomla.Framework
* @subpackage	Parameter
* @copyright	Copyright (C) 2005 - 2008 Open Source Matters. All rights reserved.
* @license		GNU/GPL, see LICENSE.php
* Joomla! is free software. This version may have been modified pursuant
* to the GNU General Public License, and as distributed it includes or
* is derivative of works licensed under the GNU General Public License or
* other free or open source software licenses.
* See COPYRIGHT.php for copyright notices and details.
*/

// Check to ensure this file is within the rest of the framework
defined('JPATH_BASE') or die();

/**
 * Renders a text element
 *
 * @package 	Joomla.Framework
 * @subpackage		Parameter
 * @since		1.5
 */

class JElementSlider extends JElement
{
	/**
	* Element name
	*
	* @access	protected
	* @var		string
	*/
	var	$_name = 'Slider';

	function fetchElement($name, $value, &$node, $control_name)
	{
		$doc = & JFactory::getDocument();
		$size = ( $node->attributes('size') ? 'size="'.$node->attributes('size').'"' : '' );
		$jqui = ( $node->attributes('ui') ? 'text ui-widget-content ui-corner-all preview ' : 'text_area preview' );
		$class = ( $node->attributes('class') ? ' class="'.$jqui.$node->attributes('class').'"' : ' class="'.$jqui.'"' );
		$placeholder = ( $value ? ' placeholder="'.$value.'"' : ' ' );
		$brackets = "\\";
		$preview = ( $node->attributes('preview') ? true : false );
		if($preview)
		{
			$doc->addScript(JURI::root(true)."/media/napi/js/jquery.magicpreview.pack.js");
			$script = "
				jQuery(document).ready(function($){
					$('.preview:enabled').livequery('focus', function(){
						$(this).magicpreview('mp_'); 
					});
				});
			";
			$doc->addScriptDeclaration($script);
		}
		if(!defined(( $node->attributes('instance') ? $node->attributes('instance') : $name )))
		{
			$script = "
				jQuery(document).ready(function($){
					$('.nf-slider".( $node->attributes('instanceclass') ? '.'.$node->attributes('instanceclass') : '.nf-slider-'.$name )."').livequery(function(){
						var _value = $(this).parent().find('.nf-slider-value input').val();
						$(this).slider({
							value: _value,
							min: ".( $node->attributes('min') ? $node->attributes('min') : '0' ).",
							max: ".( $node->attributes('max') ? $node->attributes('max') : '10' ).",
							step: ".( $node->attributes('step') ? $node->attributes('step') : '1' ).",
							slide: function(event, ui) {
								$(this).parent().find('.nf-slider-value input').val(ui.value);
							}
						});
					});
				});
			";
			$doc->addScriptDeclaration($script);
			define(( $node->attributes('instance') ? $node->attributes('instance') : $name ), 1);
		}
        /*
         * Required to avoid a cycle of encoding &
         * html_entity_decode was used in place of htmlspecialchars_decode because
         * htmlspecialchars_decode is not compatible with PHP 4
         */
        $value = htmlspecialchars(html_entity_decode($value, ENT_QUOTES), ENT_QUOTES);

		return '
		<span class="ui-helper-inherit ui-state-default nf-slider-value ui-corner-all">
			<input type="text" name="'.$control_name.'['.$name.']" id="'.$control_name.$name.'"'.$placeholder.' value="'.$value.'" '.$class.' '.$size.' />
		</span>
		<span class="nf-slider'.( $node->attributes('instanceclass') ? ' '.$node->attributes('instanceclass') : ' nf-slider-'.$name ).'"></span>';
	}
}