<?php
/**
* @version		$Id: ThemeSwitcher.php 10707 2008-08-21 09:52:47Z eddieajau $
* @package		Joomla.Framework
* @subpackage	Parameter
* @copyright	Copyright (C) 2005 - 2008 Open Source Matters. All rights reserved.
* @license		GNU/GPL, see LICENSE.php
* Joomla! is free software. This version may have been modified pursuant
* to the GNU General Public License, and as distributed it includes or
* is derivative of works licensed under the GNU General Public License or
* other free or open source software licenses.
* See COPYRIGHT.php for copyright notices and details.
*/

// Check to ensure this file is within the rest of the framework
defined('JPATH_BASE') or die();

/**
 * Renders a ThemeSwitcher element
 *
 * @package 	Joomla.Framework
 * @subpackage		Parameter
 * @since		1.5
 */

class JElementThemeSwitcher extends JElement
{
	/**
	* Element name
	*
	* @access	protected
	* @var		string
	*/
	var	$_name = 'ThemeSwitcher';

	function fetchElement($name, $value, &$node, $control_name)
	{
		$doc = & JFactory::getDocument();
		$doc->addScript(JURI::root(true)."/media/napi/js/themeswitchertool.js");
		//$doc->addScript('http://jqueryui.com/themeroller/themeswitchertool/');
		$label 	= JText::_($node->attributes('label', 'Switch Theme'));
		$top 	= $node->attributes('top', '348px');
		$right 	= $node->attributes('right', '50%');
		$script = "
		jQuery.noConflict();
 
		jQuery(document).ready(function($){
			//Theme switcher to select the best icons
			$('body').themeswitcher({loadTheme: '$value', initialText: '$label', cookieName: '$name'}).find('a.jquery-ui-themeswitcher-trigger').css({
				position: 'fixed',
				top:      '$top',
				left:     '50%'
			});
		});";
		$doc->addScriptDeclaration($script);
		return '<div id="'.$control_name.$name.'"></div>';
	}

	/*function fetchTooltip($label, $description, &$xmlElement, $control_name='', $name='') {
		return false;
	}*/
}
