<?php
/**
* @version		$Id: article.php 10381 2008-06-01 03:35:53Z pasamio $
* @package		Joomla
* @copyright	Copyright (C) 2005 - 2008 Open Source Matters. All rights reserved.
* @license		GNU/GPL, see LICENSE.php
* Joomla! is free software. This version may have been modified pursuant
* to the GNU General Public License, and as distributed it includes or
* is derivative of works licensed under the GNU General Public License or
* other free or open source software licenses.
* See COPYRIGHT.php for copyright notices and details.
*/

// Check to ensure this file is included in Joomla!
defined('_JEXEC') or die( 'Restricted access' );

class JElementZooItem extends JElement
{
	/**
	 * Element name
	 *
	 * @access	protected
	 * @var		string
	 */
	var	$_name = 'zooitem';

	function fetchElement($name, $value, &$node, $control_name)
	{
		$com_zoo = JComponentHelper::getComponent('com_zoo', true);
		if(!$com_zoo->enabled) 
		{	
			return false;
		}
		global $mainframe;
		
		// load config
		require_once(JPATH_ADMINISTRATOR.'/components/com_zoo/config.php');

		$db			=& JFactory::getDBO();
		$doc 		=& JFactory::getDocument();
		$template 	= $mainframe->getTemplate();
		$fieldName	= $control_name.'['.$name.']';
		$class      = ( $node->attributes('class') ? ' class="'.$node->attributes('class').'" ' : '');
		if ($value) {
			$item = new Item($value);
			$item->title = $item->name;
			$descr = JText::_('Caution! By selecting a new article it\'ll replace your previous selection. Click to open a modal window and pick your content item.');
		} else {
			$item->title = JText::_('Select an Item');
			$descr = JText::_('Click to open a modal window and pick your content item.');
		}

		$js = "
		function jSelectArticle(id, title, object) {
			document.getElementById(object + '_id').value = id;
			document.getElementById(object + '_name').value = title;
			jQuery('#sb-nav-close').click();
		}";
		$doc->addScriptDeclaration($js);
		
		$link = 'index.php?option=com_zoo&amp;controller=item&amp;task=element&amp;tmpl=component&amp;object='.$control_name.$name;

		//TODO remove shitty inline css
		JHTML::_('behavior.shadowbox');
		$html = '<span class="ui-helper-clearfix ui-resizable"><input type="text" name="'.$control_name.'['.$name.'_name]" id="'.$control_name.$name.'_name" value="'.$item->title.'" class="text ui-widget-content ui-corner-all ui-state-disabled ui-width 60" disabled="disabled" size="20">';
		$html .= '<a href="'.$link.'" title="'.JText::_('Select an Item').'::'.$descr.'" class="fg-button ui-state-default ui-width-40 fg-button-icon-right modal shadowbox hasTip ui-corner-right text ui-widget-content" rel="shadowbox;height=375;width=650;title=Select Article;"><span class="ui-icon ui-icon-newwin"></span>'.htmlspecialchars(JText::_('Select an Item'), ENT_QUOTES, 'UTF-8').'</a>   
		';
		$html .= "\n".'</span><input type="hidden"'.$class.' id="'.$control_name.$name.'_id" name="'.$fieldName.'_id" value="'.(int)$value.'" />';

		return $html;
	}
}
