<?php
/**
* @version		$Id: element.php 10707 2008-08-21 09:52:47Z eddieajau $
* @package		Joomla.Framework
* @subpackage	Parameter
* @copyright	Copyright (C) 2005 - 2008 Open Source Matters. All rights reserved.
* @license		GNU/GPL, see LICENSE.php
* Joomla! is free software. This version may have been modified pursuant
* to the GNU General Public License, and as distributed it includes or
* is derivative of works licensed under the GNU General Public License or
* other free or open source software licenses.
* See COPYRIGHT.php for copyright notices and details.
*/
defined ( '_JEXEC' ) or die( 'Direct Access to this location is not allowed.' );


/**
 * Parameter base class
 *
 * The JElement is the base class for all JElement types
 *
 * @abstract
 * @package 	Joomla.Framework
 * @subpackage		Parameter
 * @since		1.5
 */
class NJPluginShowcaseSimpleTabs extends NJPluginShowcaseTemplate
{
	/**
	* element name
	*
	* This has to be set in the final
	* renderer classes.
	*
	* @access	protected
	* @var		string
	*/
	var	$_name = 'simpletabs';

	function fetchItem($item, $id, $module, $params)
	{
		$opt = array();
		$opt['startOffset']        = ( $params->get('items_special')!==NULL ? $params->get('items_special') : null );
		$pane = JPane::getInstance('tabs', $opt);
		return $pane->startPanel($item['title'], 'tabs-'.$module->id.'-item-'.$id).$item['content'].$pane->endPanel();
	}
	
	function fetchItems($items, $module, $params)
	{
		$doc  = & JFactory::getDocument();	
		$doc->addStyleSheet(JURI::root(true).'/administrator/templates/khepri/css/general.css');
		$opt = array();
		$opt['startOffset']        = ( $params->get('items_special') ? $params->get('items_special') : null );
		$pane    = JPane::getInstance('tabs', $opt);
		$return  = $pane->startPane('tabs'.$module->id);
		$return .= $items;
		$return .= $pane->endPane();
		return $return;
	}
}
