<?php
/**
* @version		$Id: element.php 10707 2008-08-21 09:52:47Z eddieajau $
* @package		Joomla.Framework
* @subpackage	Parameter
* @copyright	Copyright (C) 2005 - 2008 Open Source Matters. All rights reserved.
* @license		GNU/GPL, see LICENSE.php
* Joomla! is free software. This version may have been modified pursuant
* to the GNU General Public License, and as distributed it includes or
* is derivative of works licensed under the GNU General Public License or
* other free or open source software licenses.
* See COPYRIGHT.php for copyright notices and details.
*/
defined ( '_JEXEC' ) or die( 'Direct Access to this location is not allowed.' );


/**
 * Parameter base class
 *
 * The JElement is the base class for all JElement types
 *
 * @abstract
 * @package 	Joomla.Framework
 * @subpackage		Parameter
 * @since		1.5
 */
class NJPluginShowcaseSpaceGallery extends NJPluginShowcaseTemplate
{
	/**
	* element name
	*
	* This has to be set in the final
	* renderer classes.
	*
	* @access	protected
	* @var		string
	*/
	var	$_name = 'spacegallery';
	
	function fetchItems($items, $module, $params)
	{	
		$options['border'] = $params->get('spacegalleryborder') ? $params->get('spacegalleryborder') : null;
		$options['duration'] = $params->get('spacegalleryduration') ? $params->get('spacegalleryduration') : null;
		$options['perspective'] = $params->get('spacegalleryperspective') ? $params->get('spacegalleryperspective') : null;
		$options['minscale'] = $params->get('spacegalleryminscale') ? $params->get('spacegalleryminscale') : null;
		$options['loadingClass'] = $params->get('spacegalleryloadingClass') ? $params->get('spacegalleryloadingClass') : 'loading';
		$options['before'] = $params->get('spacegallerybefore') ? $params->get('spacegallerybefore') : null;
		$options['after'] = $params->get('spacegalleryafter') ? $params->get('spacegalleryafter') : null;
		$return  = '<div id="'.$module->name.'-'.$module->id.'" class="spacegallery">';
		$return .= $this->script('#'.$module->name.'-'.$module->id, $options);
		$return .= $items;
		$return .= '</div>';
		return $return;
	}
	
	function script($selector='div.spacegallery', $params = array())
	{
		static $galleries;
		static $included;

		$document =& JFactory::getDocument();

		// Load the necessary files if they haven't yet been loaded
		if (!isset($included)) {

			// Load the javascript and css
			JHTML::_('behavior.jquery');
			JHTML::script('jquery.eye.js', NAPI_JS.'/spacegallery/', false);
			JHTML::script('jquery.utils.js', NAPI_JS.'/spacegallery/', false);
			JHTML::script('jquery.spacegallery.js', NAPI_JS.'/spacegallery/', false);
			JHTML::stylesheet('spacegallery.css', NAPI_CSS.'/spacegallery/');

			$included = true;
		}

		if (!isset($galleries)) {
			$galleries = array();
		}

		$sig = md5(serialize(array($selector,$params)));
		if (isset($galleries[$sig]) && ($galleries[$sig])) {
			return;
		}

		// Setup options object
		$opt['border']		= (isset($params['border'])) ? $params['border'] : null;
		$opt['duration']		= (isset($params['duration'])) ? $params['duration'] : null;
		$opt['perspective']		= (isset($params['perspective'])) ? $params['perspective'] : null;
		$opt['minScale']	= (isset($params['minScale'])) ? $params['minScale'] : null;
		$opt['loadingClass']	= (isset($params['loadingClass'])) ? $params['loadingClass'] : null;
		$opt['before']		= (isset($params['before'])) ? $params['before'] : null;
		$opt['after']		= (isset($params['after'])) ? $params['after'] : null;

		$options = JHTMLBehavior::_getJSObject($opt);

		// Attach modal behavior to document
		$document->addScriptDeclaration("
		jQuery(function($) {
			$('$selector').spacegallery($options);
		});");

		// Set static array
		$galleries[$sig] = true;
		return;
	}
}
