<?php
/*
* The Ninja Super sIFR allows you display fonts which are normally not useable on the web (except as images) on your web pages
* Using flash.  Sifr 3 adapted to Joomla by Daniel Chapman 
* 
* (c) Copyright: Ninja Forge, www.ninjaforge.com - Get on the cutting edge.
* email: daniel@ninjaforge.com 
* date: August, 2008
* Release: 1.1
* License : GNU GPL. See <http://creativecommons.org/licenses/LGPL/2.1/>
* 
* $Id: ninjastyler.php 1847 2009-11-24 02:32:02 uwalter Exp $
*/

defined( '_JEXEC' ) or die( 'Restricted access' );

// Import library dependencies
jimport( 'joomla.plugin.plugin' );

class plgSystemNinjasitestyler extends JPlugin
{
   /**
    * Constructor
    *
    * For php4 compatability we must not use the __constructor as a constructor for
    * plugins because func_get_args ( void ) returns a copy of all passed arguments
    * NOT references.  This causes problems with cross-referencing necessary for the
    * observer design pattern.
    */
    function plgSystemNinjasitestyler( &$subject )
    {
        parent::__construct( $subject );

         // load plugin parameters

        $this->_plugin = JPluginHelper::getPlugin( 'system', 'Ninjasitestyler' );
      //$this->_params = new JParameter( $this->_plugin->params );
    }

    /**
    * Plugin method with the same name as the event will be called automatically.
    */
    function    onAfterDispatch()
    {
        $mainframe  =& JFactory::getApplication();
        $db         =& JFactory::getDBO();
        $document   =& JFactory::getDocument();
        $user       =& JFactory::getUser();
        $option     =  JRequest::getCmd('option');

        //In non content items the $id var will be null. in this case put a value in it to fool the sql        
        # And we do an integer type cast to prevent sql injection attacks.
        # The string type cast back is done automatically through the
        # concatenation later on.

		$id = array_key_exists('id', $_REQUEST) ? (int) $_REQUEST['id'] : 'notcontent';


    	if (! $mainframe->isAdmin()) # Site Styler is not applied on admin pages 
        {
            // load our config params:
	        //   Select our Site Styler Preferences from the DB 

	    	$params =& JComponentHelper::getParams( 'com_ninjasitestyler' );
	    	

	    	 //if default mootools is to be changed, change it

    		$use_moo_fix	= $params->get('use_moo_fix');
			$search			= array('mootools', 'caption.js');

    		if ($use_moo_fix == 1)
			{
			    //disable default mootools completely
			    //remove the mootools and caption.js files

				foreach($document->_scripts as $key => $script)
				{
					foreach($search as $findme)
					{
						if(stristr($key, $findme) !== false)
						{
							unset($document->_scripts[$key]);
						}
					}
				}
			} 
			else if ($use_moo_fix == 2)
			{
				//replace default mootools with ours from the uploads directory.
				//using the uploads directory allows users to replace our file with their own if they want 
				// remove the mootools and caption.js files

				foreach($document->_scripts as $key => $script)
				{
					foreach($search as $findme)
					{
						if(stristr($key, $findme) !== false)
						{
							unset($document->_scripts[$key]);
						}
					}
				}

				//now load our mootools

				$document->addScript(JURI::root().'administrator/components/com_ninjasitestyler/uploads/mootools.js');
			}



			if ($params->get('use_generator_tag') == 2)
			{
			    //Check if we want to replace the generator tag
				# This is a global, not rule dependent option.

				$document->setGenerator($params->get('new_generator_tag'));						
			}

			if ('html' == $document->getType())
			{
		        //The next two options should only be applied to HTML output
				# This is a global, not rule dependent option.
				
				/**
			     * Credit:
				 * Author: Hut32
				 * WebSite: http://hut32.blogspot.com/
				 * Plugin is released under GNU/GPL license (http://www.gnu.org/copyleft/gpl.html)
				 */

				if ($params->get('remove_inclusions'))
				{	
			        // If set to, remove any excess JS or CSS files	

					require_once(JPATH_SITE.DS.'plugins'.DS.'system'.DS.'plg_ninjasitestyler'.DS.'remove_inclusions_helper.php');	
							
					$headData                   = $document->getHeadData();
					$headData['scripts']        = removeInclHelperClass::getUpdatedInclusions($headData['scripts'],     $params->get('jsInclusions'));
					$headData['styleSheets']    = removeInclHelperClass::getUpdatedInclusions($headData['styleSheets'], $params->get('cssInclusions'));
				
					$document->setHeadData($headData);
				}

		        //The next option should only be applied to HTML output
	    	    //load IE8 Compatibility mode if requested and the viewer is using ie8

			    /**
			     * Credits:
			     * IE8 Compatibility Mambot
			     * Author: Jeremy.J <joly.jeremy@gmail.com>
			     * Copyright (C) 2009 All Rights Reserved
			     */

	    		if ($params->get('use_ie8_compat') && strpos($_SERVER['HTTP_USER_AGENT'], 'MSIE 8') !== FALSE)
				{						
				    // Get selected compatibility mode and set custom header

				    $document->setMetaData('X-UA-Compatible', 'IE='.$params->get('use_ie8_compat'), true);						
				}

			    //load png fix if needed, and if we are in ie6

	    		if ($params->get('use_png_fix') && $browser == 'ie6' )
				{
				    //load png fix file
				
				    $document->addStyleDeclaration(
                        $params->get('png_fix_selectors').' { behavior: url("'.JURI::root().'/administrator/components/com_ninjasitestyler/css/iepngfix.htc") }'
                    );
				}


	    	    //load ie warning if needed

	    		$use_ie6_warn = $params->get('use_ie6_warn');
#die($_SERVER['HTTP_USER_AGENT']);

	    		if ($use_ie6_warn && strpos($_SERVER['HTTP_USER_AGENT'], 'MSIE 6') !== FALSE && !preg_match('/(?:trident|opera)/i',$_SERVER['HTTP_USER_AGENT']))
				{
				    //Load the regular small message warning
				
					if ($use_ie6_warn == '1' )
					{
						$document->addScript(JURI::root().'administrator/components/com_ninjasitestyler/js/jquery.js');
						$document->addScript(JURI::root().'administrator/components/com_ninjasitestyler/js/ie6update.js');
					}
                    elseif ($use_ie6_warn == '2' )
					{
					    //load the big ie warning script, that forbids entry 

					    /**
					    * Credit:
					    * version	$Id: plg_iewarning.php 10709 2009-03-21 09:58:52Z juanparati $
					    * package	Joomla
					    * copyright	Copyright (C) 2009 Terrasolutions.es. All rights reserved.
					    * license	GNU/GPL, see LICENSE.php 
					    */
					
						if (JRequest::getCmd('iewarning_off', '') != '')
                        {
					        setcookie('iewarning_off', 1);

					        $_COOKIE['iewarning_off'] = 1;
					    }
                        else
                        {
							//$lang = JFactory::getLanguage();
							//$lang = JLanguage::getInstance($lang->_lang);
							//JPlugin::loadLanguage('com_ninjasitestyler');
							//$lang = $lang->_strings; // <== This is quick and DIRTY :-((
							
							$lang   =& JFactory::getLanguage();
         					$lang->load( 'plg_ninjasitestyler' , JPATH_ADMINISTRATOR );
							  
					    	$document->addScriptDeclaration('
					          var msg1  = "'.JText::_('IEISOUTDATE_TEXT').'";
					          var msg2  = "'.JText::_('BESTEXPERIENCE_TEXT').'.";
					          var msg3  = "'.JText::_('JUSTCLICK_TEXT').'";
					          var br1   = "'.JText::_('IEVERSION').'"; // 7+
					          var br2   = "'.JText::_('FIREFOXVERSION').'"; // 3+
					          var br3   = "'.JText::_('SAFARIVERSION').'"; // 3+
					          var br4   = "'.JText::_('OPERAVERSION').'"; // 9.5+";
					          var br5   = "'.JText::_('CHROMEVERSION').'"; //2.0+
					          var url1  = "'.JText::_('IEURL').'"; // http://www.microsoft.com/windows/Internet-explorer/default.aspx
					          var url2  = "'.JText::_('MOZILLAURL').'"; // http://www.mozilla.com/firefox/
					          var url3  = "'.JText::_('SAFARIURL').'"; // http://www.apple.com/safari/download/
					          var url4  = "'.JText::_('OPERAURL').'"; // http://www.opera.com/download/
					          var url5  = "'.JText::_('CHROMEURL').'"; //http://www.google.com/chrome
					          var allowmsg = "'.JText::_('CONTINUEATMYRISK').'";
					          var allowcontinue ='.$params->get('ie6_allow_continue').';
					          var waruri = "'.JURI::root().'administrator/components/com_ninjasitestyler/images/";    
					          
					          window.addEvent(\'domready\', function(){ e(waruri); });
					         ');
					                         
					        $document->addScript(JURI::root().'administrator/components/com_ninjasitestyler/js/say.no.to.ie.6.js');
					    }

						//$scriptActivator = 'window.onload=function(){e("'.$file = JURI::root().'administrator/components/com_ninjasitestyler/images/")}';
						//$document->addScriptDeclaration($scriptActivator);	
						
					} # if ($use_ie6_warn == '1')
	
				} # if ($params->get('use_ie6_warn') && $browser == 'ie6')
			}



   			if ($params->get('block_tp_equals_1') && JRequest::getCmd('tp', ''))
			{
		        //if we want to disable tp=1 then do so first and set it to null.

				JRequest::setVar('tp', '');	
			}

		    /**
		     * Append the site name to the page title if needed
		     *
		     * Credit:
		     * Plugin Website Name
		     * autor : Nicolas Ogier
		     * thanks to :
		     *  JM Simonet (infograph768) for the English translation
		     *  Joaoh Bruni for the Brazilian Portuguese translation
		     */

			if ($params->get('append_sitename'))
			{
   				$sitename = $mainframe->getCfg('sitename');
   				$title    = $document->getTitle();

			    //Just do a simple check to see if the sitename is already present
			    //This can be done just by doing a strpos for the sitename

   				$pos = strpos($title, $sitename);

			    if ($pos === false)
                   {
			     	if ($params->get('append_sitename') == 1)
					{
						$title = $title.$params->get('appd_sitename_separator').$sitename;
					
					}
                       elseif ($params->get('append_sitename') == 2)
					{
						$title = $sitename.$params->get('appd_sitename_separator').$title;
					}
				
					$document->setTitle( $title );
				}
			}


	    	if ($params->get('append_to_meta_desc'))
			{
				//append our pre/postfix to the metadata
			    //get the current meta data and
			    //append to either the front or rear of the metadata

				if ($params->get('append_to_meta_desc') == 1)
				{
					$document->setMetaData('description', $params->get('appd_meta_desc').$document->getMetaData('description'), true);
				}
				else
				{
					$document->setMetaData('description', $document->getMetaData('description').$params->get('appd_meta_desc'), true);
				}
			}

    		if ($params->get('use_iconize'))
			{
				//if iconize is to be used, activate it

   				$document->addStyleSheet(
					JURI::root().'administrator/components/com_ninjasitestyler/css/icz_'.$params->get('position').'.css',
					'text/css',
					'screen'       
				);	
			}
   	
	   		if ($params->get('use_rules'))
            {
                /**
		   	     * build our rules comparison list - the user id, the browser etc. (only needed rules are checked)
                 *
		   		 * Our rules are based around the following: component name, content id, user id, user group, 
                 * browser and aec subscription so gather this information
                 */

				$clausesArray = array();

		   		//component (option)
		   		if ($params->get('use_component_rules'))
				{
		   			$clausesArray[] = ' ((all_comp = "1" OR all_ctnt_comp="1") OR custom_comp like "%'.$option.'%") ';
				}

				if ($params->get('use_content_rules'))
				{
                    # We use a regular expression here in order not to match
                    # the id 22 if the id 2 was requested.

		   			$clausesArray[] = " (
                        (all_ctnt = '1' OR all_ctnt_comp='1') OR (
                            'com_content' = '$option' AND (
                                custom_ctnt rlike '^$id$' OR
                                custom_ctnt rlike '^$id,' OR
                                custom_ctnt rlike ',$id$' OR
                                custom_ctnt rlike ',$id,'
                            )
                        ) 
                    ) ";
				}

				if ($params->get('use_user_rules'))
				{
					//User details (id)

		   			$clausesArray[] = " (
                        all_users = '1' OR 
                        custom_users rlike '^".$user->id."$' OR
                        custom_users rlike '^".$user->id.",' OR
                        custom_users rlike ',".$user->id."$' OR
                        custom_users rlike ',".$user->id.",'
                    ) ";
				}


				if ($params->get('use_user_group_rules'))
				{
					//group (gid)

		   			$clausesArray[] = " (
                        all_groups = '1' OR 
                        custom_groups rlike '^".$user->gid."$' OR
                        custom_groups rlike '^".$user->gid.",' OR
                        custom_groups rlike ',".$user->gid."$' OR
                        custom_groups rlike ',".$user->gid.",'
                    ) ";
				}
		   		

		   		//browser
		   		if ($params->get('use_browser_rules'))
		   		{
			   		//google chrome, and the iphone both have 'safari' in their user agent string,
                    //so we need to check for them before we check for the real safari 

		   			if (strpos($_SERVER['HTTP_USER_AGENT'], 'Chrome') !== FALSE)
					{
					   $browser = 'chrome';
					}
                    else if (strpos($_SERVER['HTTP_USER_AGENT'], 'iPhone') !== FALSE)
					{
					   $browser = 'iphone';
					}
                    else if (strpos($_SERVER['HTTP_USER_AGENT'], 'Safari') !== FALSE)
					{
					   $browser = 'safari';
					}
					else if (strpos($_SERVER['HTTP_USER_AGENT'], 'Firefox') !== FALSE)
					{
					     $browser = 'firefox';			   
					}
					else if (strpos($_SERVER['HTTP_USER_AGENT'], 'MSIE 6') !== FALSE && !preg_match('/opera/i',$_SERVER['HTTP_USER_AGENT']) )
					{     
					   $browser = 'ie6';
					}
					else if (strpos($_SERVER['HTTP_USER_AGENT'], 'MSIE 7') !== FALSE)
					{     
					   $browser = 'ie7';
					}
					else if (strpos($_SERVER['HTTP_USER_AGENT'], 'MSIE 8') !== FALSE)
					{     
					   $browser = 'ie8';
					}
					else if (strpos($_SERVER['HTTP_USER_AGENT'], 'Opera') !== FALSE)
					{
					   $browser = 'opera';
					}
					else
					{
					   $browser = 'other';
					}
						
					$clausesArray[] = ' (all_browsers = "1" OR custom_browsers like "%'.$browser.'%") ';
		   		} 
					   			

		   		//AEC Subscriptions

		   		$subSql = '';		   				

		   		if ($params->get('use_aec_rules'))
			   	{
			   		//check if AEC is installed before building the list of subscriptions	

					$db->setQuery( 'select count(*) from #__components where link = "option=com_acctexp"') ;
					$aecExists = $db->loadResult();
													
					if ($aecExists)
                    {
			   		    //AEC allows people to have multiple simultaneous subcriptions, so we need to be able to check for that

			   			$db->setQuery( 'SELECT id FROM #__acctexp_subscr where userid="'.$user->id.'" and status in ("Active","Excluded")') ;
						$subscriptions = $db->loadResultArray();
							
						//Only build the query string if our user actually has a subscription
						//if not, ignore this.

						$n = count($subscriptions);

						if ($n)
						{
							$subSql = ' (all_aec_subscrs = "1" OR ( ';
								
							//now loop through our array of subscruiptions (usually only 1) 

							for ($i=0; $i < $n; $i++)
                            {
								//for any subscriptions after the first put an OR in front	

								$subSql .= $i > 0 ? ' OR ': '';

								//We are using this concat function so we can isolate the full subscription by making
								//the stored db values into a list starting and finishing with a comma.
								//without doing this, values like %9% would translate as true for 19, 29, 191, etc.
								//but %,9,%  will only ever map to 9    

								$subSql .= ' concat(",",custom_aec_subscrs,",") like "%,'.$subscriptions[$i].',%" ';
							}
							$subSql .= ' ))';

						} # if ($n)

					} # if ($aecExists)

		   		} # if ($params->get('use_aec_rules'))
		   			
		   		if ($subSql)
				{
                    $clausesArray[] = $subSql;
				}
		   		

                /**
		   	     * Implode our sql clauses together with ANDs to get our list of valid rules for this page.
		   	     * Rules we have disabled in the config will be blank. 
		   	     * We are using this array and implode system because any of the items could be the first one in the list 
                 *
		   	     * if any of our above clauses have been set, then $caluses will have a non null (and thus true) value
		   	     * wrap it in an OR clause and brackets to allow the sql to be formed properly
                 */

		   		$clauses = "AND  all_pages='1' "; # Default clause => no unlocked rules except the main one (all pages)

		   		if (count($clausesArray))
				{
                    $clauses .= 'OR ('. implode(' AND ', $clausesArray). ')';
				}
                
		   		$db->setQuery("
                    SELECT id FROM #__rulesinstance 
		   			WHERE published='1' ".$clauses
                );
				$rules = $db->loadResultArray();
	
	   		}
            else
            {
	   			//we will specify no rules here, because an empty result above means that there are rules, but none apply to this page
	   			//but the entry below means all rules are disabled so load everything
	   			$rules = array('norules');

	   		} # if ($params->get('use_rules'))

 		
	   		if (count($rules))
	   		{
	   	        //only do our checks if some rules apply to this page

    
	   			if ($params->get('use_redirects'))
				{
		            //if redirects are enabled, check and load redirects. 
		            //Do this first because a redirect will change the page, making other functions meaningless.
				    //load redirect file and execute the class, passing in the required params

					require_once(JPATH_SITE.DS.'plugins'.DS.'system'.DS.'plg_ninjasitestyler'.DS.'loadredirects.php');

					loadRedirectsClass::loadRedirects($rules,$params);	
				}


				
				
				
				
	    	    //if a Google verification key is set, use it.

				$googleVerCode = $params->get('google_ver_key');
			
	    		if ($googleVerCode)
				{
				
				    //set the meta data

					$document->setMetaData('google-site-verification', $googleVerCode);	
				}			
			
	    
	    	    //if sIFR is enabled, check and load sIFR
	    		if ($params->get('use_sifr'))
				{
				    //load sIFR files

					require_once(JPATH_SITE.DS.'plugins'.DS.'system'.DS.'plg_ninjasitestyler'.DS.'loadsifr.php');

					loadSifrClass::loadSifr($rules,$params);
				}
	    

	    	    //if scripts are enabled, check and load any scripts

	    		if ($params->get('use_scripts'))
				{
				    //load scripts files

					require_once(JPATH_SITE.DS.'plugins'.DS.'system'.DS.'plg_ninjasitestyler'.DS.'loadscripts.php');

					loadScriptsClass::loadScripts($rules,$params);	
				}


				if ($params->get('use_add_code'))
				{					
	    	        //if addcode is enabled, check and load the added code

					require_once(JPATH_SITE.DS.'plugins'.DS.'system'.DS.'plg_ninjasitestyler'.DS.'loadaddcode.php');

					loadAddCodeClass::loadAddCode($rules,$params);	
				}
				

			
	   		}//end of our if count(rules)
		}//end of our if !$mainframe->isAdmin()  
    }//end of our onAfterDispatch function
	
	// Credit:
	/**
	* version		1.0
	* package		RokClicky
	* copyright	Copyright (C) 2008 RocketTheme, LLC. All rights reserved.
	* license		GNU/GPL, see LICENSE.php
	* RokClicky Analytics Plugin
	*
	* author		Andy Miller
	* package		RokClicky
	* subpackage	System
	*/
	
	function onAfterRender()
	{
		global $mainframe;

		$params		=& JComponentHelper::getParams( 'com_ninjasitestyler' );
		$document	=& JFactory::getDocument();
		$user       =& $mainframe->getUser();

		
	//Storage for our eventual scripts
		$outputScript = '';
		
		$clicky_id = trim($params->get('clicky_siteid', 0));
		$useWoopra = $params->get('use_woopra');

		// Only render for HTML output
		if ('html' !== $document->getType()) return;

		// Don't show if admin tracking is off and we're in admin
		if ($mainframe->isAdmin() && $params->get('clicky_trackadmin', 0) == 0)
			$clicky_id = 0;	
	
		//Only execute if we actually have a clicky id
		if ($clicky_id != 0) {
			
			$clicky_dbserver = trim($params->get('clicky_dbserver', 'db10'));
			
			$clicky_namedisplay = $params->get('clicky_namedisplay', 'name');
		    switch($clicky_namedisplay) {
		        case "username": $clicky_username = $user->username; break;
		        case "onlyname": $clicky_username = $user->name; break;
		        case "name":
		        default:
		            $clicky_username = (trim($user->name)) ? $user->name : $user->username;
		    }
			
			$clicky_email			= $user->email;
			$clicky_trackusernames	= $params->get('clicky_trackusernames');
			$clicky_trackemails		= $params->get('clicky_trackemails');
			
		    
    		if ($clicky_trackusernames==1 or $clicky_trackemails==1) {
    		    $outputScript .= " <script type='text/javascript'>\n
					                  var clicky_custom = {};
					                  clicky_custom.session = {";
                if ($clicky_trackusernames==1) $outputScript .= "\n              username: '". $clicky_username ."'";
                if ($clicky_trackusernames==1 and $clicky_trackemails==1) $outputScript .= ",";
                if ($clicky_trackemails==1) $outputScript .= "\n              email: '". $clicky_email ."'";
                $outputScript .= "\n                };
                					</script>\n";
    		}
			    				    
            if (isset($_SERVER['HTTPS']) && $_SERVER['HTTPS']=='on') {
              $outputScript .= "<script src='https://static.getclicky.com/$clicky_id.secure.js' type='text/javascript'></script>
              					<noscript><p><img alt='Clicky' src='https://static.getclicky.com/$clicky_id-$clicky_dbserver.gif' /></p></noscript>\n";
            }
            else
			{
              $outputScript .= "<script src='http://static.getclicky.com/$clicky_id.js' type='text/javascript'></script>
              					<noscript><p><img alt='Clicky' src='http://static.getclicky.com/$clicky_id-$clicky_dbserver.gif' /></p></noscript>\n";
            }
		}
		
		/**
		 * Credit:
		 * version $Id$
		 * package jx_modules
		 * subpackage JX Woopra
		 * copyright Copyright (C) 2008 JX Development. All rights reserved.
		 * license http://www.gnu.org/copyleft/gpl.html GNU/GPL, see LICENSE.php
		 *
		 * version		1.2
		 * package		Woopra
		 * copyright	Copyright (C) 2008 RocketTheme, LLC. All rights reserved.
		 * license		GNU/GPL, see LICENSE.php
		 *
		 * Woopra analytics plugin
		 *
		 * author		Andy Miller
		 * package		Woopra
		 * subpackage	System
		 */
		
		
		// Don't show if admin tracking is off and we're in admin
		if ($mainframe->isAdmin() && $params->get('wp_track_admin', 0) == 0) 
		{
			$useWoopra = 0;
		}
	
		//Only execute if we have been told to use woopra
		if ($useWoopra)
		{
			$woopra_namedisplay = $params->get('wp_namedisplay', 'name');
			
			switch($woopra_namedisplay)
			{
		        case "username": $woo_username = $user->username;	break;
		        case "onlyname": $woo_username = $user->name;		break;
		        case "name":
		        default:
		            $woo_username = trim($user->name) ? $user->name : $user->username;
		            break;
		    }

		//Only setup the woopra user variables if they are logged in and we are supposed to
			if ($params->get('wp_auto_tag', 0) && $woo_username != NULL) {
			
				$woo_email = $user->email;
				
				$gravatar_support = $params->get('wp_gravatar_support', 1) == 1 ? true : false;
				
				$outputScript .= "<script type=\"text/javascript\">\r\n";
			
					$outputScript .= "var woopra_visitor = new Array();\r\n";
					$outputScript .= "woopra_visitor['name'] = '" . $woo_username . "';\r\n";
					$outputScript .= "woopra_visitor['email'] = '" . $woo_email . "';\r\n";
					if ($gravatar_support) $outputScript .= "woopra_visitor['avatar'] = 'http://www.gravatar.com/avatar.php?gravatar_id=" . md5(strtolower($woo_email)) . "&size=60&default=http%3A%2F%2Fstatic.woopra.com%2Fimages%2Favatar.png';\r\n";
			
				$outputScript .= "</script>\r\n";
			}
			
			if (isset($_SERVER['HTTPS']) && $_SERVER['HTTPS']=='on') {
            	$outputScript .= '<!-- Woopra Code Start -->'."\n";
				$outputScript .= '<script type="text/javascript">'."\n";
				$outputScript .= ' var _wh = ((document.location.protocol=="https:") ? "https://sec1.woopra.com" : "http://static.woopra.com");'."\n";
				$outputScript .= ' document.write(unescape("%3Cscript src=\'" + _wh + "/js/woopra.js\' type=\'text/javascript\'%3E%3C/script%3E"));'."\n";
				$outputScript .= ' </script>'."\n";
				$outputScript .= '<!-- Woopra Code End -->'."\n";
            }
            else {
              $outputScript .= "<script type=\"text/javascript\" src=\"http://static.woopra.com/js/woopra.js\"></script>\r\n";
            }
		}	
	

		$response = false;
		
		if ($outputScript)
		{
			//Only start messing with the joomla output if we actually have something to insert

			$response = str_replace('</body>', $outputScript.'</body>', JResponse::getBody());
		}


		if (!$mainframe->isAdmin() && $params->get('use_generator_tag') == 1)
		{
			//Check if we want to remove the generator tag and create the expression.

			if (!$response) $response = JResponse::getBody();

			$response = preg_replace('/<meta\s+name="generator"[^>]+>/i', '', $response);
		}

		if ($response)
		{
			JResponse::setBody($response);
		}
	}
	
}//end of our plugin
