<?php
/*
* The Ninja Super sIFR allows you display fonts which are normally not useable on the web (except as images) on your web pages
* Using flash.  Sifr 3 adapted to Joomla by Daniel Chapman 
* 
* (c) Copyright: Ninja Forge, www.ninjaforge.com - Get on the cutting edge.
* email: daniel@ninjaforge.com 
* date: August, 2008
* Release: 1.0
* License : GNU GPL. See <http://creativecommons.org/licenses/LGPL/2.1/>
* 
*/

defined( '_JEXEC' ) or die( 'Restricted access' );

// Import library dependencies
jimport( 'joomla.plugin.plugin' );

class plgSystemNinjasupersifr extends JPlugin
{
   /**
    * Constructor
    *
    * For php4 compatability we must not use the __constructor as a constructor for
    * plugins because func_get_args ( void ) returns a copy of all passed arguments
    * NOT references.  This causes problems with cross-referencing necessary for the
    * observer design pattern.
    */
    function plgSystemNinjasupersifr( &$subject )
    {
            parent::__construct( $subject );

         // load plugin parameters
            $this->_plugin = JPluginHelper::getPlugin( 'system', 'ninjasupersifr' );
            $this->_params = new JParameter( $this->_plugin->params );
    }

    /**
    * Plugin method with the same name as the event will be called automatically.
    */
    function    onAfterDispatch()
    {
        global $mainframe;
        global $option;
		    $paramsObj = &JComponentHelper::getParams( 'com_ninjasupersifr' );

    //In non content items the $id var will be null. in this case put a value in it to fool the sql        
		$id = array_key_exists('id',$_REQUEST) ? preg_replace('/^(\d+):.*$/', '$1', $_REQUEST['id']) : 'notcontent';

    if (!$mainframe->isAdmin()){
	    //first load our base sIFR css and js files
	    //get the document so we can load into it
	        $document =& JFactory::getDocument();
	        
	        $stylesheetType = 'text/css';
	        
			//add the sIFR css files
				$file = JURI::base().'administrator/components/com_ninjasupersifr/css/sIFR-screen.css';
				$document->addStyleSheet($file,$stylesheetType,'screen');
				
				$file = JURI::base().'administrator/components/com_ninjasupersifr/css/sIFR-print.css';
				$document->addStyleSheet($file,$stylesheetType,'print');
				
	      
		  	if (isset($paramsObj->sifr_version)) {
		    
		    //add the sIFR js
				$file = JURI::base().'administrator/components/com_ninjasupersifr/js/419/sifr.js';
				$document->addScript($file);
	        
		  	} else {
		  								
		    //add the sIFR js
				$file = JURI::base().'administrator/components/com_ninjasupersifr/js/sifr.js';
				$document->addScript($file);
		  	}
			
			
			//This is for debugging only not needed anymore
			//$file = JURI::base().'/administrator/components/com_ninjasupersifr/js/sifr-debug.js';
			//$document->addScript($file);
	       
	    //load the database object so we can query about what fonts etc to load
	        $database = &JFactory::getDBO();

	    
	    //Check if our preferences exist, and if not use 'yes' as the default
	    	if (!isset($paramsObj->use_display_ctrls))
	    	 	$paramsObj->use_display_ctrls = 1;
	    	 	
	    	if($paramsObj->use_display_ctrls) { 
	    		$where = ' 
					AND (
						all_pages=1
							OR (all_ctnt = 1 AND "'.$option.'" = "com_content")
							OR (all_comp = 1 AND "'.$option.'" <> "com_content")
							OR (
								all_ctnt = 0 AND (
									custom_ctnt RLIKE "'. $id.'"	OR
									custom_ctnt RLIKE ",'.$id.'"	OR
									custom_ctnt RLIKE "'. $id.',"	OR
									custom_ctnt RLIKE ",'.$id.',"
								)
							)
							OR (
								all_comp = 0 AND (
									custom_comp RLIKE "'. $option.'"		OR
									custom_comp RLIKE ",'.$option.'"		OR
									custom_comp RLIKE "'. $option.',"	OR
									custom_comp RLIKE ",'.$option.',"
								)
							)
	    			)';
	    	}else{
	    		$where = '';
	    	}
	        
	    //to do - first get the list of fonts we need to load
	        $database->setQuery('SELECT distinct font FROM #__njsifr where published=1 '.$where);
	        $fonts = $database->loadResultArray();
	        
	    //store our output JS into this variable. Initialise it to avoid errors later on
	     	$sIFRJS = '';
	     
	    //Build a url to reference our font loading scripts with
	     	$urlBase = JURI::root().'administrator/components/com_ninjasupersifr/fonts/';
	     	
	        for ($i=0, $n=count( $fonts ); $i < $n; $i++) 
	        {	
	        	$sIFRJS .= ' var '.$fonts[$i].' = { src: \''.$urlBase.$fonts[$i].'.swf\' }; '."\n"; 
	        	
	        }
	        
	    //implode our font array into a comma seperated list so we can build the next stop of our js with it
	     	$activateList = implode(',',$fonts);
	     	
	    //write the js to activate our sIFR fonts and append it onto the $sIFRJS variable
	     	$sIFRJS .= ' sIFR.activate('.$activateList.'); '; 
	        
	    //write our activate statement to the head of our page
	      $document->addScriptDeclaration($sIFRJS);
	        
	    //now we need to get and process all of our sIFR instances. 
	    //each instance is a combination of one font, one or more CSS selectors, and any other display rules for it

	     
			$database->setQuery('SELECT * FROM #__njsifr where published=1 '.$where);
			$instances = $database->loadObjectList();
			
		//initate the variables we will use to hold the overall data before it's printed
			$styleVar = '';
			
		//loop through each instance and build the css and js we need to display the sIFR correctly
			foreach ($instances as $instance)
			{
			
			//initialise needed variables
				$cssTemp = array();
				$selectorsList ='';
								
			//build the list of selectors first
				if ($instance->ctnt_hdng_selector)
				{
					$cssTemp[] = '.contentheading';			
				}
				
				if ($instance->comp_hdng_selector)
				{
					$cssTemp[] = '.componentheading';			
				}
				
				if ($instance->mod_hdng_selector)
				{
					$cssTemp[] = '.module h3';	
					$cssTemp[] = '.moduletable h3';		
				}
				
				if ($instance->custom_selector)
				{
					$cssTemp[] = $instance->custom_selector;			
				}
				
				$selectorsList = implode(', ',$cssTemp);
				$selectorsList2 = implode(', .sIFR-active ',$cssTemp);
				
			//append our css for this instance onto the styleVar so ti can be output once the list is complete
				$styleVar .='.sIFR-active '.$selectorsList2.' {visibility:hidden; font-family:Verdana; line-height:1em !important;';
				
				if ($instance->size)
				{
					$styleVar .='font-size: '.$instance->size.'px !important;';
				}
							
				$styleVar .='}';
				
			//write the style to the head
				$document->addStyleDeclaration($styleVar);
							
			//build the js in the same manner
			
			//prebuild our drop shadow filter js if needed, initializing the variable to avoid errors
				$shadowJS = '';
				$shadowTemp = array();
			
				if($instance->use_ds) 
				{
					if ($instance->ds_knockout)
					{
						$shadowTemp[] = ' knockout: true ';			
					}else {
						$shadowTemp[] = ' knockout: false ';
					}
					
					if ($instance->ds_color)
					{
						$shadowTemp[] = ' color: \'#'.$instance->ds_color.'\' ';			
					}
					
					if ($instance->ds_angle)
					{
						$shadowTemp[] = ' angle: \''.$instance->ds_angle.'\' ';			
					}
					
					if ($instance->ds_distance)
					{
						$shadowTemp[] = ' distance: \''.$instance->ds_distance.'\' ';			
					}
					
					if ($instance->ds_strength)
					{
						$shadowTemp[] = ' strength: \''.$instance->ds_strength.'\' ';			
					} 
					else 
					{
						$shadowTemp[] = ' strength:1 ';
					}
					 
					
					$shadowList = implode(',',$shadowTemp);
	                               
					$shadowJS .= ',filters: { DropShadow: {'.$shadowList.' }  } ';
	    		}
	    		
	    	//next start the js CSS declarations
	    	
	    	//the seperators are different for the css depending on if it has links or not
	    	//it is because of a quirk in the sifr script that requires different style of entering the css info
	    		$sp3 = '\' ';
	    		$sp6 = '; ';
	    		$br  = '';
	    		$br2 = '';
	    		
	    		if ($instance->has_links)
	    		{
	    			$sp3 = '\' ';
	    			$br = '[';
	    			$br2 = ']';
				}
				
				$mainJS = '';
				$mainJSTemp = array();
				
				if ($instance->align)
				{
					$mainJSTemp[] = 'text-align:'.$instance->align;			
				}
				
				if ($instance->decoration)
				{
					$mainJSTemp[] = 'text-decoration:'.$instance->decoration;			
				}
				
				if ($instance->color)
				{
  				$mainJSTemp[] = 'color:#'.$instance->color;
				}
				
				if ($instance->bg_color)
				{
					$mainJSTemp[] = 'background-color:#'.$instance->bg_color;			
				}
								
				if ($instance->opacity)
				{
					$mainJSTemp[] = 'opacity:'.$instance->opacity;			
				}
				
				if (!$instance->has_links)
				{
    				if ($instance->cursor == 'default' || $instance->cursor == 'arrow')
    				{
              $mainJSTemp[] = 'cursor:'.$instance->cursor;
            }
            else
            {
              $mainJSTemp[] = 'cursor:pointer';
            }
        }	
        else 	
        {
            $mainJSTemp[] = 'cursor:pointer';
        }
				
				if ($instance->font_weight)
				{
					$mainJSTemp[] = 'font-weight:'.$instance->font_weight;
				}
				
				if ($instance->font_style)
				{
					$mainJSTemp[] = 'font-style:'.$instance->font_style;			
				}
				
				if ($instance->leading)
				{
					$mainJSTemp[] = 'leading:'.$instance->leading;			
				}
				
				if ($instance->kerning)
				{
					$mainJSTemp[] = 'kerning:'.$instance->kerning;			
				}
				
				if ($instance->letter_spacing)
				{
					$mainJSTemp[] = 'letter-spacing:'.$instance->letter_spacing;			
				}	
				
				if ($instance->margin_left)
				{
					$mainJSTemp[] = 'margin-left:'.$instance->margin_left;			
				}
				
				if ($instance->margin_right)
				{
					$mainJSTemp[] = 'margin-right:'.$instance->margin_right;			
				}
				
				if ($instance->text_indent)
				{
					$mainJSTemp[] = 'text-indent:'.$instance->text_indent;			
				}
				
				if ($instance->display)
				{
					$mainJSTemp[] = 'display:'.$instance->display;			
				}
				
				$mainJSList = implode($sp6,$mainJSTemp).$sp6.'}';
				
			//pre initialise our linksCSS variable
				$linkCSS = '';
			
			//check to see if our selector has been set to show links, and if so write the link css into our variable
				if ($instance->has_links)
				{
					
					$linkCSS = ', \'a { text-decoration:none; }\' ';
					
					if ($instance->color)
					{
						$linkCSS = ', \'a { text-decoration:none; color:#'.$instance->color.'; } \'';
					}

					if ($instance->hover_color)
					{
						$linkCSS .= ', \'a:hover { color:#'.$instance->hover_color.'; } \'';			
					}
					
					if ($instance->active_color)
					{
						$linkCSS .= ', \'a:active { color:#'.$instance->active_color.'; } \'';			
					}
												
				}
				
				
				$selectable = '';
				if ($instance->cursor == 'arrow')
				{
          $selectable = ',selectable:false';
        }
				
				$offset_top = '';
				$offset_left = '';
				$fit_exactly = '';
				$force_singleline = '';
				
				if ($instance->offset_top)
				{
					$offset_top = ' offsetTop: '.$instance->offset_top.',';			
				}
				
				if ($instance->offset_left)
				{
					$offset_left = ' offsetLeft: '.$instance->offset_left.',';			
				}
				
				if ($instance->fit_exactly)
				{
          $fit_exactly = ' fitExactly: true,';
        }
        
        if ($instance->force_singleline)
				{
          $force_singleline = ' forceSingleLine: true,';
        }

					
				$mainJS .=' sIFR.replace('.$instance->font.', { ' .
								' selector: \''.$selectorsList.'\',' .
								' wmode: \'transparent\',' .
								$offset_top.
								$offset_left.
								$fit_exactly.
								$force_singleline.
								' css: '.$br.'\'.sIFR-root'.' { '.$mainJSList.$sp3.$linkCSS.$br2.' '.$shadowJS.' '.$selectable.'}); ';
				    
	                            
	         //write our activate statement to the head of our page
	        	$document->addScriptDeclaration($mainJS);
	    
	    	}//end of our our foreach instances as instance loop
		}//end of our onAfterRoute function
    }//end of our if !$mainframe->isAdmin()
}//end of our plugin
?>
