<?php defined( '_JEXEC' ) or die( 'Restricted access' );

	# $Id: loadaddcode.php 1593 2009-10-18 06:28:29Z uwalter $

class loadAddCodeClass 
{
	//rules = comma seperated list of the ids of all rules that are considered 'valid' for the current page
	//$paramsObj - the parameters from the config screen of the Ninja Site Styler component
	function loadAddCode($rules = array('norules'), $paramsObj)
  	{
  	//first check for valid rules or the no rules setting
		if (count($rules))	
		{
			$where = '';
			
			if ($rules[0] != 'norules')

				$where = ' AND rule_id IN ('.implode(',',$rules).') ';

			
		 //load the database object so we can query about what fonts etc to load
	        $database = &JFactory::getDBO();
		
		 //now grab our instances. 
	     	$database->setQuery('SELECT * FROM #__addcodeinstance WHERE published=1 '.$where);
			$instances = $database->loadObjectList();
			
		 //only load scripts if we have at least one rule match
			if (count($instances))
			{
				self::generate_add_code($instances);
			}
		}	
  	}//end of loadAddCode
  	
  	function generate_add_code($instances)
  	{
  	
  		$document =& JFactory::getDocument();
  			
	//loop through each instance and build the css and js we need to display the sIFR correctly
		foreach ($instances as $instance)
		{
			switch ($instance->code_type){
				case 'php':
					self::parsePHP($instance->added_code);
					break;
				case 'js':
					# uwalter: Added comment signs for hiding the JavaScript code from browsers who don't understand JS.
					$document->addScriptDeclaration("<!--\n".$instance->added_code.'//-->');
					break;
				case 'css':
					$document->addStyleDeclaration($instance->added_code);
					break;
			}			
		}//end of foreach loop	
  		
  	}//end of generate_add_code
  	
  	function parsePHP($php){
  		
  		//Code in this function si derived from mod_html from Fiji Web Design
  		//Credits below:
  		/*
		* mod_html allows inclusion of HTML/JS/CSS and now PHP, in Joomla/Mambo Modules
		* (c) Copyright: Fiji Web Design, www.fijiwebdesign.com.
		* email: info@fijiwebdesign.com 
		* date: Feb 4, 2007
		* Release: 1.0.0.Beta Test2
		*/
		$php = "<?php ".$php." ?>";
  		
  		$temp_dir = JPATH_SITE.DS.'administrator'.DS.'components'.DS.'com_ninjasitestyler'.DS.'addcodetmp';
		$tmpfname = tempnam($temp_dir, "tempfile.php");
		if ($handle = @fopen($tmpfname, "w")) {
			fwrite($handle, $php, strlen($php));
			fclose($handle);
			include_once($tmpfname);
			unlink($tmpfname);
		} else {
			echo 'Could not open temporary file for writing. <br />';
			echo 'Please check that the folder: '.$temp_dir.' exists and is writable.<br />';
		}
  		
  	}
  	
}//end of class

?>
