<?php defined( '_JEXEC' ) or die( 'Restricted access' );

class loadRedirectsClass 
{
	//rules = comma seperated list of the ids of all rules that are considered 'valid' for the current page
	//$paramsObj - the parameters from the config screen of the Ninja Site Styler component
	function loadRedirects($rules = array('norules'), $paramsObj)
  	{
  		
  	//first check for valid rules or the no rules setting
		if (count($rules))	
		{
			
			if($rules[0]='norules')
			{
				$where = '';
			} 
			else
			{
				$where = ' AND rule_id IN ('.implode(',',$rules).') ';
			} 
			
		 //load the database object so we can query about what fonts etc to load
	        $database = &JFactory::getDBO();
		
		 //now grab our instances. 
	     	$database->setQuery('SELECT * FROM #__redirectsinstance WHERE published=1 '.$where);
			$instances = $database->loadObjectList();
			
		 //only load scripts if we have at least one rule match
			if (count($instances))
			{
				self::do_redirect($instances);
			}
		}	
  	}//end of loadAddCode
  	
  	function do_redirect($instances)
  	{
  	//really we can only do the first redirect, 
  	//but put the loop in place just in case a redirect is broken in some way and doesn't fire
  		$document =& JFactory::getDocument();
  		global $mainframe;
  			
	//loop through each instance and build the css and js we need to display the sIFR correctly
		foreach ($instances as $instance)
		{
			switch ($instance->redirect_location) {
				case 1:
					$myurl = $instance->redirect_custom_url;   // Redirects to the URL you choose
					break;
				case 2:
					$myurl = "index.php?option=com_user&view=login";   // Login for Core J! Component
					break;
				case 3:
					$myurl = "index.php?option=com_user&task=register";   // Redirect to Joomla Core Registration Page
					break;
				case 4:
					$myurl = "index.php?option=com_comprofiler&task=register";   // Registration Page of Community Builder 
					break;
				case 6:
					//to-do - put in the AEC link for J1.5
					$myurl = JURI::root();   // Redirects to the URL you choose
					break;
				case 5:
				default:
					$myurl = JURI::root();   // Redirect to home page 
					break;			
			}
			

			
			$myurl = JRoute::_($myurl);
  	
			$mainframe->redirect($myurl);
						
		}//end of foreach loop	
  		
  	}//end of generate_scripts
  	
}//end of class

?>