<?php defined( '_JEXEC' ) or die( 'Restricted access' );

# Id: loadscripts.php 1996 2009-10-20 07:40:03Z uwalter Exp $

class loadScriptsClass 
{
	//rules = comma seperated list of the ids of all rules that are considered 'valid' for the current page
	//$paramsObj - the parameters from the config screen of the Ninja Site Styler component
	function loadScripts($rules = array('norules'), $paramsObj)
  	{
  	//first check for valid rules or the no rules setting
		if (count($rules))	
		{
			$where = '';

			if($rules[0] != 'norules')

				$where = ' AND rule_id IN ('.implode(',',$rules).') ';
			

		 //load the database object so we can query about what fonts etc to load
	        $database = &JFactory::getDBO();
		
		 //now grab our instances. 
	     	$database->setQuery('SELECT * FROM #__scriptsinstance WHERE published=1 '.$where);
			$instances = $database->loadObjectList();
			
		 //only load scripts if we have at least one rule match
			if (count($instances))
			{
				self::generate_scripts($instances);
			}
		}	
  	}//end of loadAddCode
  	
  	function generate_scripts($instances)
  	{
  	
  		$document =& JFactory::getDocument();
  			
	//loop through each instance and build the css and js we need to display the sIFR correctly
		foreach ($instances as $instance)
		{
			
		//only allow remote files for JS and CSS, not PHP
			if ($instance->file_url && ($instance->file_type != 'php')){
				
				switch ($instance->file_type){
					case 'js':
						$document->addScript($instance->file_url);
						break;
					case 'css':
						$stylesheetType = 'text/css';
					//TODO - add ability to select the CSS type - screen/print
						$document->addStyleSheet($instance->file_url,$stylesheetType,'screen');
						break;
				}//switch
			
			} elseif ($instance->file_name)	{
						
				switch ($instance->file_type){
					case 'php':
						$file = JPATH_SITE.DS.'administrator'.DS.'components'.DS.'com_ninjasitestyler'.DS.'uploads'.DS.$instance->file_name;
						include_once($file);
						break;
					case 'js':
						$file = JURI::root().'administrator/components/com_ninjasitestyler/uploads/'.$instance->file_name;
						$document->addScript($file);
						break;
					case 'css':
						$stylesheetType = 'text/css';
						$file = JURI::root().'administrator/components/com_ninjasitestyler/uploads/'.$instance->file_name;
						//to-do add ability to select the CSS type - screen/print
						$document->addStyleSheet($file,$stylesheetType,'screen');
						break;
				}//switch	
			}//if ($instance->file_url){
		}//end of foreach loop	
  		
  	}//end of generate_scripts
  	
}//end of class

?>
