<?php defined( '_JEXEC' ) or die( 'Restricted access' );

class loadSifrClass 
{
	//rules = comma seperated list of the ids of all rules that are considered 'valid' for the current page
	//$paramsObj - the parameters from the config screen of the Ninja Site Styler component
	function loadSifr($rules = array('norules'), $paramsObj)
  	{
  	//first check for valid rules or the no rules setting
		if (count($rules))	
		{
			
			if($rules[0]='norules')
			{
				$where = '';
			} 
			else
			{
				$where = ' AND rule_id IN ('.implode(',',$rules).') ';
			} 
			
		 //load the database object so we can query about what fonts etc to load
	        $database = &JFactory::getDBO();
		
		 //first get the list of fonts we need to load based on the active rules, or the norules setting
	        $database->setQuery('SELECT distinct font FROM #__sifrinstance WHERE published=1 '.$where);
	        $fonts = $database->loadResultArray();
	     
	     //now grab our instances. We do this seperately because the fonts may be used more than once in different instances.
	     	$database->setQuery('SELECT * FROM #__sifrinstance WHERE published=1 '.$where);
			$instances = $database->loadObjectList();
			
		 //only load scripts if we have at least one valid font
			if (count($fonts))
			{
			self::generate_fixed_scripts();			
			self::generate_font_files($fonts);
			self::generate_font_calls($instances);
			}
		}	
  	}	
	
	function generate_fixed_scripts()
  	{
	//first load our base sIFR css and js files
	//get the document so we can load into it
        $document =& JFactory::getDocument();
        
        $stylesheetType = 'text/css'; 
                
    //add the sIFR css files
		$file = JURI::root().'administrator'.DS.'components'.DS.'com_ninjasitestyler'.DS.'css'.DS.'sIFR-screen.css';
		$document->addStyleSheet($file,$stylesheetType,'screen');
		
		$file = JURI::root().'administrator'.DS.'components'.DS.'com_ninjasitestyler'.DS.'css'.DS.'sIFR-print.css';
		$document->addStyleSheet($file,$stylesheetType,'print');
        
    //add the sIFR js
		$file = JURI::root().'administrator'.DS.'components'.DS.'com_ninjasitestyler'.DS.'js'.DS.'sifr.js';
		$document->addScript($file);
	
	//to-do - put in a debug mode that allows this script to be loaded on demand
		//$file = JURI::root().'administrator'.DS.'components'.DS.'com_ninjasitestyler'.DS.'js'.DS.'sifr-debug.js';
		//$document->addScript($file);
	
  	}
	
	function generate_font_files($fonts)
  	{
  		
  		$document =& JFactory::getDocument();
  		
	//store our output JS into this variable. Initialise it to avoid errors later on
     	$sIFRJS = '';
     	
    //Build a url to reference our font loading scripts with
     	$urlBase = JURI::root().'administrator'.DS.'components'.DS.'com_ninjasitestyler'.DS.'uploads'.DS;
     	
        for ($i=0, $n=count( $fonts ); $i < $n; $i++) 
        {	
        	$sIFRJS .= ' var '.$fonts[$i].' = { src: \''.$urlBase.$fonts[$i].'.swf\' }; '."\n"; 
        	
        }
        
    //implode our font array into a comma seperated list so we can build the next stop of our js with it
     	$activateList = implode(',',$fonts);
     	
    //write the js to activate our sIFR fonts and append it onto the $sIFRJS variable
     	$sIFRJS .= ' sIFR.activate('.$activateList.'); '; 
        
    //write our activate statement to the head of our page
        $document->addScriptDeclaration($sIFRJS);
  	}//end of generate_font_files
		
	function generate_font_calls($instances)
  	{
  		$document =& JFactory::getDocument();
  		
	//initate the variables we will use to hold the overall data before it's printed
			$styleVar = '';
				
			//loop through each instance and build the css and js we need to display the sIFR correctly
				foreach ($instances as $instance)
				{
				
				//initialise needed variables
					$cssTemp = array();
					$selectorsList ='';
									
				//build the array of selectors first then implode it into a comma separated list.
				//this is the easiest way to make a comma seperated list when any number of selectors 
				//may or may not be included.
				//This is much better than a massive list of nested if statements.
					if ($instance->ctnt_hdng_selector)
					{
						$cssTemp[] = '.contentheading';			
					}
					
					if ($instance->comp_hdng_selector)
					{
						$cssTemp[] = '.componentheading';			
					}
					
					if ($instance->mod_hdng_selector)
					{
						$cssTemp[] = '.module h3, .moduletable h3';			
					}
					
					if ($instance->custom_selector)
					{
						$cssTemp[] = $instance->custom_selector;			
					}
					
				//build a comma seperated list from our aray above
					$selectorsList = implode(', ',$cssTemp);
					$selectorsList2 = implode(', .sIFR-active ',$cssTemp);
					
				//append our css for this instance onto the styleVar so it can be output once the list is complete
					$styleVar .='.sIFR-active '.$selectorsList2.' {
								  visibility: hidden;
								  font-family: Verdana;
								  line-height: 1em !important;';
					
					if ($instance->size)
					{
					//font size is set to important in case the page has css files loaded after our styles are included,
					//or because the font size has a more specific css selector.
					//this was added after a few support issues from exactly this
						$styleVar .='font-size: '.$instance->size.' !important;';
					}
								
					$styleVar .='}';
					
				//write the style to the head
					$document->addStyleDeclaration($styleVar);
								
				//build the js in the same manner
				
				//prebuild our drop shadow filter js if needed, initializing the variable to avoid errors
					$shadowJS = '';
					$shadowTemp = array();
				
					if($instance->use_ds) 
					{
						if ($instance->ds_knockout)
						{
							$shadowTemp[] = ' knockout: true ';			
						}else {
							$shadowTemp[] = ' knockout: false ';
						}
						
						if ($instance->ds_color)
						{
							$shadowTemp[] = ' color: \''.$instance->ds_color.'\' ';			
						}
						
						if ($instance->ds_angle)
						{
							$shadowTemp[] = ' angle: \''.$instance->ds_angle.'\' ';			
						}
						
						if ($instance->ds_distance)
						{
							$shadowTemp[] = ' distance: \''.$instance->ds_distance.'\' ';			
						}
						
						if ($instance->ds_strength)
						{
							$shadowTemp[] = ' strength: \''.$instance->ds_strength.'\' ';			
						} 
						else 
						{
							$shadowTemp[] = ' strength: 1 ';
						}
						
						$shadowList = implode(',',$shadowTemp);
		                               
						$shadowJS .= ',filters: { DropShadow: {'.$shadowList.' }  } ';
		    		}
		    		
		    	//next start the js CSS declarations
		    	
		    	//the seperators are different for the css depending on if it has links or not
		    	//it is because of a quirk in the sifr script that requires different styles of entering the css info
		    		$sp = '\'';
		    		$sp2 = ', ';
		    		$sp3 = ' ';
		    		$sp4 = '';
		    		$sp5 = ':';
		    		$br = '{';
		    		$br2 = '}';
		    		
		    		if ($instance->has_links)
		    		{
		    			$sp = '';	    			
		    			$sp2 = '; ';	    		
		    			$sp3 = '\' ';
		    			$sp4 = ';';
		    			$sp5 = '';
		    			$br = '[';
		    			$br2 = ']';
					}
					
					$mainJS = '';
					$mainJSTemp = array();
					
					if ($instance->align)
					{
						$mainJSTemp[] = $sp.'text-align'.$sp.' : '.$sp.$instance->align.$sp;			
					}
					
					if ($instance->decoration)
					{
						$mainJSTemp[] = $sp.'text-decoration'.$sp.' : '.$sp.$instance->decoration.$sp;			
					}
					
					if ($instance->color)
					{
						$mainJSTemp[] = $sp.'color'.$sp.' : '.$sp.$instance->color.$sp;			
					}
					
					if ($instance->bg_color)
					{
						$mainJSTemp[] = $sp.'background-color'.$sp.' : '.$sp.$instance->bg_color.$sp;			
					}
									
					if ($instance->opacity)
					{
						$mainJSTemp[] = $sp.'opacity'.$sp.' : '.$sp.$instance->opacity.$sp;			
					}
					
					if ($instance->cursor)
					{
						$mainJSTemp[] = $sp.'cursor'.$sp.' : '.$sp.$instance->cursor.$sp;			
					}
					
					if ($instance->font_weight)
					{
						$mainJSTemp[] = $sp.'font-weight'.$sp.' : '.$sp.$instance->font_weight.$sp;			
					}
					
					if ($instance->font_style)
					{
						$mainJSTemp[] = $sp.'font-style'.$sp.' : '.$sp.$instance->font_style.$sp;			
					}
					
					if ($instance->leading)
					{
						$mainJSTemp[] = $sp.'leading'.$sp.' : '.$sp.$instance->leading.$sp;			
					}
					
					if ($instance->kerning)
					{
						$mainJSTemp[] = $sp.'kerning'.$sp.' : '.$sp.$instance->kerning.$sp;			
					}
					
					if ($instance->letter_spacing)
					{
						$mainJSTemp[] = $sp.'letter-spacing'.$sp.' : '.$sp.$instance->letter_spacing.$sp;			
					}
					
					if ($instance->margin_left)
					{
						$mainJSTemp[] = $sp.'margin-left'.$sp.' : '.$sp.$instance->margin_left.$sp;			
					}
					
					if ($instance->margin_right)
					{
						$mainJSTemp[] = $sp.'margin-right'.$sp.' : '.$sp.$instance->margin_right.$sp;			
					}
					
					if ($instance->text_indent)
					{
						$mainJSTemp[] = $sp.'text-indent'.$sp.' : '.$sp.$instance->text_indent.$sp;			
					}
					
					if ($instance->display)
					{
						$mainJSTemp[] = $sp.'display'.$sp.' : '.$sp.$instance->display.$sp;			
					}
					
					$mainJSList = implode($sp2,$mainJSTemp).$sp4;
					
				//pre initialise our linksCSS variable
					$linkCSS = '';
				
				//check to see if our selector has been set to show links, and if so write the link css into our variable
					if ($instance->has_links)
					{
						
						$linkCSS .= ', \'a { text-decoration: none; }\' ';
						
						if ($instance->color)
						{
							$linkCSS .= ', \'a:link { color: '.$instance->color.';} \'';			
						}
						
						if ($instance->hover_color)
						{
							$linkCSS .= ', \'a:hover { color: '.$instance->hover_color.';} \'';			
						}
													
					}
					
						
					$mainJS .=' sIFR.replace('.$instance->font.', { ' .
									' selector: \''.$selectorsList.'\',' .
									' wmode: \'transparent\',' .
									' css: '.$br.'\'.sIFR-root'.$sp.$sp5.' { '.$mainJSList.' } '.$sp3.$linkCSS.$br2.' '.$shadowJS. '}); ';
					    
		                            
		         //write our activate statement to the head of our page
		        	$document->addScriptDeclaration($mainJS);
    
    	}//end of our our foreach instances as instance loop
	
	
  	}//end of generate_font_calls	
}//end of class

?>