<?php
/**
 * plugin_component.php,v 1.7 2010/01/02 12:34:11
 * @copyright (C) Reumer.net
 * @license http://www.gnu.org/copyleft/gpl.html GNU/GPL
 */

// no direct access
defined( '_JEXEC' ) or die( 'Restricted access' );

jimport( 'joomla.plugin.plugin' );

class plgSystemplugin_component extends JPlugin
{
	var $config;
	var $subject;
	var $params;
	/**
	 * Constructor
	 *
	 * For php4 compatability we must not use the __constructor as a constructor for plugins
	 * because func_get_args ( void ) returns a copy of all passed arguments NOT references.
	 * This causes problems with cross-referencing necessary for the observer design pattern.
	 *
	 * @access      protected
	 * @param       object  $subject The object to observe
	 * @param       array   $config  An array that holds the plugin configuration
	 * @since       1.0
	 */
	public function plgSystemplugin_component( &$subject, $config )
	{
			parent::__construct( $subject, $config );

			// Do some extra initialisation in this constructor if required
			$this->subject = $subject;
			$this->config = $config;
			$plugin =& JPluginHelper::getPlugin('system', 'plugin_component');
			$this->params = new JParameter( $plugin->params );
	}	
	
	/**
	 * Do something onAfterInitialise 
	 */
	public function onAfterInitialise()
	{
	}
	
	public function onPrepareContent(&$article)
	{
		$text = &$article->text;
		$plugin =& JPluginHelper::getPlugin('system', 'plugin_component');
		$pluginParams = new JParameter( $plugin->params );
	
		// check whether mambot has been unpublished
		if ( !$pluginParams->get( 'enabled', 1 ) ) {
			$text = preg_replace( $regex, '', $text );
			return true;
		}
	
		// define the regular expression for the bot
		$regex = "#{component}(.*?){/component}#s";
	
		// perform the replacement	
		$text = preg_replace_callback( $regex, 'pluginIncludeComponent_replacer', $text );	
	}
	/**
	 * Do something onAfterRoute 
	 */
	public function onAfterRoute()
	{
	}
	
	/**
	 * Do something onAfterDispatch 
	 */
	public function onAfterDispatch()
	{
		$plugin =& JPluginHelper::getPlugin('system', 'plugin_component');
		$pluginParams = new JParameter( $plugin->params );
		
		// define the regular expression for the bot
		$regex = "#{component}(.*?){/component}#s";

		$doc = & JFactory::getDocument();
		$doctype = $doc->getType();
		
		// FEED
		if ($doctype=='feed'&&isset($doc->items)) {
			foreach($doc->items as $item) {
				$text = &$item->description;
				if ( !$pluginParams->get( 'enabled', 1 ) )
					$text = preg_replace( $regex, '', $text );
				else
					$text = preg_replace_callback( $regex, 'pluginIncludeComponent_replacer', $text );
			}
			
			return true;
		}
		
		// In other components or leftovers
		if (isset($doc->buffer)) {
			$text = $doc->getBuffer("component");
			
			// check whether plugin has been unpublished
			if ( !$pluginParams->get( 'enabled', 1 ) )
				$text = preg_replace( $regex, '', $text );
			else
				$text = preg_replace_callback( $regex, 'pluginIncludeComponent_replacer', $text );	
			
			$doc->setBuffer($text, "component"); 
		}
	}
	
	/**
	 * Do something onAfterRender 
	 */
	public function onAfterRender()
	{
	}
}

function pluginIncludeComponent_replacer( &$matches ) {
	// Clean javascript in pdf/feeds	
	$document =& JFactory::getDocument();
	$doctype = $document->getType();

	$url = $matches[1];

	if (strpos($url, 'index.php')!== false) {
		$sef=false;
		$url = $url.((strpos($url, '?')===false)?'?':'&').'tmpl=component&print=1';
	} else {
		$sef=true;
		$url = $url.((substr($url, -1)!='/')?'/':'').'tmpl,component/print,1';
	}

	$url = JUri::base().$url;
	// Not clear why to replace the &amp;
//	$url = preg_replace('/&amp;/', '&', $url);
	
	$ok = false;
	$post  = '';
	$reg = '/^[a-f0-9]+$/si';
	//get all session parameters
	foreach ($_COOKIE as $key => $value) {
		if (preg_match($reg,$key)>0)
			if ($sef)
				$post.="/$key,$value";
			else
				$post.="&$key=$value";
	}
	
	if (ini_get('allow_url_fopen'))
		if ($response = @file_get_contents($url.((strlen($post)>0)?$post:'')))
			$ok = true;

	if (!$ok) {
		if (function_exists('curl_init')) {
			$ch = curl_init( $url );
		
			$timeout = 5; // set to zero for no timeout
			curl_setopt ($ch, CURLOPT_RETURNTRANSFER, 1);
			curl_setopt ($ch, CURLOPT_CONNECTTIMEOUT, $timeout);
			if ( strlen($post)>0 ){
				curl_setopt($ch, CURLOPT_POSTFIELDS, $post);
			}
			
			$response = curl_exec($ch);    
			if (curl_errno($ch)) {
				$response = "<!-- url not received: #".curl_errno($ch)." \"".curl_error($ch)."\" -->";
			} else {
				$ok = true;
			}
			curl_close($ch);
		} else 
			$response = "<!-- curl not available as PHP library -->";
	}

	if ($ok) {
		// Clean the returned page of all html tags

		// get head and remove it
		// to do move meta tags, scripts and links to header?
		$reg = "/(<HEAD[^>]*>)(.*?)(<\/HEAD>)(.*)/si";
		$count = preg_match_all($reg,$response,$html);	
		if ($count>0) {
			$head=$html[2][0];
			$response= $html[4][0];
		} else {
			$head='';
		}

		if ($doctype!="feed"&&$doctype!="pdf") {
			// Find stylesheets and javascripts and add them to this document
			// javascript scripts
			$reg = '/<script.*src=[\'\"](.*?)[\'\"][^>]*[^<]*(<\/script>)?/i';
			$count = preg_match_all($reg,$head,$scripts);	
			if ($count>0)
				foreach ($scripts[1] as $script) {
					$document->addScript($script);
				}
			
			// javascript embedded
			$reg = '/<script[^>]*>(.*?)<\/script>/si';
			$scripts= array();
			$count = preg_match_all($reg,$head,$scripts);	
			if ($count>0)
				foreach ($scripts[1] as $script) {
					if (trim($script)!='')
						$document->addScriptDeclaration($script);
				}
		}

		if ($doctype!="feed") {
			// stylesheet links
			$reg = '/<link.*href=[\'\"](.*?)[\'\"][^>]*[^<]*(<\/link>)?/i';
			$count = preg_match_all($reg,$head,$styles);	
			if ($count>0)
				for ($x=0;$x<$count;$x++) {
					if ((preg_match('/type=[\'"]text\/css[\'"]/i', $styles[0][$x])>0)||(preg_match('/rel=[\'"]stylesheet[\'"]/i', $styles[0][$x])>0))
						$document->addStyleSheet($styles[1][$x]);
				}
			
			// Embedded styles
			$reg = '/<style[^>]*>(.*?)<\/style>/si';
			$styles = array();
			$count = preg_match_all($reg,$head,$styles);	
			if ($count>0)
				foreach ($styles[1] as $style) {
					if (trim($style)!='')
						$document->addStyleDeclaration($style);
				}
		}
		
		// get body and remove it
		// to do attributes of body onload and other move to the real page?
		$reg = '/(<BODY[^>]*>)(.*)(<\/BODY>)/si';
		$count = preg_match_all($reg,$response,$html);	
		if ($count>0)
			$response=$html[2][0];

		$reg = array();
		$repl = array();
		
		// clean javascript for feeds and pdf
		if ($doctype=="feed"||$doctype=="pdf") {
			// Find stylesheets and javascripts and remove them
			// javascript scripts
			$reg[] = '/<script.*src=[\'\"](.*?)[\'\"][^>]*[^<]*(<\/script>)?/i';
			$repl[] = '';
			// javascript embedded
			$reg[] = '/<script[^>]*>(.*?)<\/script>/si';
			$repl[] = '';
		}

		if ($doctype=="feed") {
			// stylesheet links
			$reg[] = '/<link.*href=[\'\"](.*?)[\'\"][^>]*[^<]*(<\/link>)?/i';
			$repl[] = '';
			// Embedded styles
			$reg[] = '/<style[^>]*>(.*?)<\/style>/si';
			$repl[] = '';
		}

		// Replace links
		$reg[] = "/&amp;print=1/";
		$repl[] = '';
		$reg[] = "/&print=1/";
		$repl[] = '';
		$reg[] = "/&amp;tmpl=component/";
		$repl[] = '';
		$reg[] = "/&tmpl=component/";
		$repl[] = '';
		$reg[] = "/index2.php/";
		$repl[] = 'index.php';
		$response = preg_replace( $reg, $repl, $response );
		
		// Replace tokes
		$reg = '/<input type=["\']hidden["\'] name=["\'][a-f0-9]+["\'] value=["\']1["\'] \/>/si';
		$tokens = array();
		$count = preg_match_all($reg,$response,$tokens);
		if ($count>0)
			foreach ($tokens[0] as $token) {
				$response = str_replace ($token, JHTML::_( 'form.token' ), $response);
			}
			
	}
	
	$content = "\n<!-- Plugin Include component version 1.7 by Mike Reumer";
	$content .= "\n     for: ".$url." -->";
	$content .= "\n".$response;
	$content .= "\n<!-- End Plugin Include component -->";
	
	return $content;	
}

?>