<?php
/**
 * @package   Kinetic Template - RocketTheme
 * @version   1.5.2 February 12, 2010
 * @author    RocketTheme http://www.rockettheme.com
 * @copyright Copyright (C) 2007 - 2010 RocketTheme, LLC
 * @license   http://www.gnu.org/licenses/gpl-2.0.html GNU/GPLv2 only
 *
 * Rockettheme Kinetic Template uses the Joomla Framework (http://www.joomla.org), a GNU/GPLv2 content management system
 *
 */

// no direct access
defined('_JEXEC') or die('Restricted access');

/**
 * This is a file to add template specific chrome to pagination rendering.
 *
 * pagination_list_footer
 *	 Input variable $list is an array with offsets:
 *		 $list[limit]		: int
 *		 $list[limitstart]	: int
 *		 $list[total]		: int
 *		 $list[limitfield]	: string
 *		 $list[pagescounter]	: string
 *		 $list[pageslinks]	: string
 *
 * pagination_list_render
 *	 Input variable $list is an array with offsets:
 *		 $list[all]
 *			 [data]		: string
 *			 [active]	: boolean
 *		 $list[start]
 *			 [data]		: string
 *			 [active]	: boolean
 *		 $list[previous]
 *			 [data]		: string
 *			 [active]	: boolean
 *		 $list[next]
 *			 [data]		: string
 *			 [active]	: boolean
 *		 $list[end]
 *			 [data]		: string
 *			 [active]	: boolean
 *		 $list[pages]
 *			 [{PAGE}][data]		: string
 *			 [{PAGE}][active]	: boolean
 *
 * pagination_item_active
 *	 Input variable $item is an object with fields:
 *		 $item->base	: integer
 *		 $item->link	: string
 *		 $item->text	: string
 *
 * pagination_item_inactive
 *	 Input variable $item is an object with fields:
 *		 $item->base	: integer
 *		 $item->link	: string
 *		 $item->text	: string
 *
 * This gives template designers ultimate control over how pagination is rendered.
 *
 * NOTE: If you override pagination_item_active OR pagination_item_inactive you MUST override them both
 */

function pagination_list_footer($list)
{
	// Initialize variables
	$lang =& JFactory::getLanguage();
	$html = "<div class=\"list-footer\">\n";

	$html .= "\n<div class=\"limit\">".JText::_('Display Num').$list['limitfield']."</div>";
	$html .= $list['pageslinks'];
	$html .= "\n<div class=\"counter\">".$list['pagescounter']."</div>";

	$html .= "\n<input type=\"hidden\" name=\"limitstart\" value=\"".$list['limitstart']."\" />";
	$html .= "\n</div>";

	return $html;
}

function pagination_list_render($list)
{
	// Initialize variables
	$lang =& JFactory::getLanguage();

	$html = "\n<div class=\"tab\">"."\n<div class=\"tab2\">".$list['start']['data']."</div>"."</div>";
	$html .= "\n<div class=\"tab\">"."\n<div class=\"tab2\">".$list['previous']['data']."</div>"."</div>";

	foreach( $list['pages'] as $page )
	{
		if($page['data']['active']) {
			//$html .= '<strong>';
		}

		$html .= "\n<div class=\"page-block\">".$page['data']."</div>";

		if($page['data']['active']) {
			//  $html .= '</strong>';
		}
	}

	$html .= "\n<div class=\"tab\">"."\n<div class=\"tab2\">".$list['next']['data']."</div>"."</div>";
	$html .= "\n<div class=\"tab\">"."\n<div class=\"tab2\">".$list['end']['data']."</div>"."</div>";
	// $html .= '&#171;';

	return $html;
}

function pagination_item_active(&$item) {
	return "<div class=\"page-inactive\"><a href=\"".$item->link."\" title=\"".$item->text."\">".$item->text."</a></div>";
}

function pagination_item_inactive(&$item) {
	return "<div class=\"page-active\">".$item->text."</div>";
}
?>