<?php
/**
 * Plugin Helper File
 *
 * @package    Articles Anywhere
 * @version    0.2.0
 * @since      File available since Release v0.1.0
 *
 * @author     Peter van Westen <peter@nonumber.nl>
 * @link       http://www.nonumber.nl/articlesanywhere
 * @copyright  Copyright (C) 2009 NoNumber! All Rights Reserved
 * @license    http://www.gnu.org/licenses/gpl-2.0.html GNU/GPL
 */

// Ensure this file is being included by a parent file
defined( '_JEXEC' ) or die( 'Restricted access' );

// Import library dependencies
jimport( 'joomla.event.plugin' );

/**
* Plugin that places articles
*/
class plgSystemArticlesAnywhereHelper
{
	function init( &$params ) {
		$this->params = plgSystemArticlesAnywhereHelper::getParamValues( $params );
		//plgSystemArticlesAnywhereHelper::setExtraParams();
		$break_tags_start =			'(?:<p(?: [^>]*)?>\s*)?';
		$break_tags_end =			'(?:\s*</p>)?';
		$this->params->regex =		'#'.$break_tags_start.'\{'.preg_quote( $this->params->article_tag ).'(?: ([^\}]*))?\}(.*?)\{/'.preg_quote( $this->params->article_tag ).'\}'.$break_tags_end.'#s';
	}

////////////////////////////////////////////////////////////////////
// ARTICLES
////////////////////////////////////////////////////////////////////

	function replaceInArticles ( &$article ) {
		$message = '';

		if ( isset( $article->created_by ) ) {
			// Lookup group level of creator
			$acl =& JFactory::getACL();
			$article_group = $acl->getAroGroup( $article->created_by );

			if ( !isset( $article_group->lft ) ) {
				$article_group->lft = 0;
			}

			$security_group = $acl->get_group_data( $this->params->articles_security_level );

			// Set if security is passed
			// passed = creator is equal or higher than security group level
			if ( $security_group['4'] > $article_group->lft ) {
				$message = JText::_( 'REMOVED, SECURITY' );
			}
		}

		if ( isset( $article->text ) ) {
			$this->processArticles( $article->text, 'articles', $message );
		}
		if ( isset( $article->description ) ) {
			$this->processArticles( $article->description, 'articles', $message );
		}
		if ( isset( $article->title ) ) {
			$this->processArticles( $article->title, 'articles', $message );
		}
		if ( isset( $article->author ) ) {
			if ( isset( $article->author->name ) ) {
				$this->processArticles( $article->author->name, 'articles', $message );
			} else {
				$this->processArticles( $article->author, 'articles', $message );
			}
		}
	}

////////////////////////////////////////////////////////////////////
// COMPONENTS
////////////////////////////////////////////////////////////////////

	function replaceInComponents()
	{
		$document	=& JFactory::getDocument();
		$docType = $document->getType();

		if ( $docType == 'feed' && isset( $document->items ) ) {
			for ( $i = 0; $i < count( $document->items ); $i++ ) {
				$this->replaceInArticles( $document->items[$i] );
			}
		}

		if ( isset( $document->_buffer ) ) {
			$this->tagArea( $document->_buffer, 'component' );
		}

		// PDF
		if ( $docType == 'pdf' ) {
			if ( isset( $document->_header ) ) {
				$this->replaceInTheRest( $document->_header );
				$this->cleanLeftoverJunk( $document->_header );
			}
			if ( isset( $document->title ) ) {
				$this->replaceInTheRest( $document->title );
				$this->cleanLeftoverJunk( $document->title );
			}
			if ( isset( $document->_buffer ) ) {
				$this->replaceInTheRest( $document->_buffer );
				$this->cleanLeftoverJunk( $document->_buffer );
			}
		}
	}

////////////////////////////////////////////////////////////////////
// OTHER AREAS
////////////////////////////////////////////////////////////////////
	function replaceInOtherAreas()
	{
		$document	=& JFactory::getDocument();
		$docType = $document->getType();

		// not in pdf's
		if ( $docType == 'pdf' ) { return; }

		$html = JResponse::getBody();

		$this->protect( $html );
		$this->replaceInTheRest( $html );

		// only do the handling inside the body
		if ( !( strpos( $html, '<body' ) === false ) && !( strpos( $html, '</body>' ) === false ) ) {
			$html_split = explode( '<body', $html );
			$body_split = explode( '</body>', $html_split['1'] );

			// remove generated articles outside the body
			$this->removeGeneratedArticles( $html_split['0'] );
			$this->removeGeneratedArticles( $body_split['1'] );

			$html_split['1'] = implode( '</body>', $body_split );
			$html = implode( '<body', $html_split );
		}

		$this->cleanLeftoverJunk( $html );
		$this->unprotect( $html );

		JResponse::setBody( $html );
	}

	function replaceInTheRest( &$str, $docType = 'html' )
	{
		global $option;

		if ( $str == '' ) { return; }

		$document	=& JFactory::getDocument();
		$docType = $document->getType();

		// COMPONENT
		if ( $docType == 'feed' ) {
			$search_regex = '#(<item[^>]*>.*</item>)#si';
			$str = preg_replace( $search_regex, '<!-- START: ARTA_COMPONENT -->\1<!-- END: ARTA_COMPONENT -->', $str );
		}
		if ( strpos( $str, '<!-- START: ARTA_COMPONENT -->' ) === false ) {
			$this->tagArea( $str, 'component' );
		}

		$components = $this->params->components;
		if ( !is_array( $components ) ) {
			$components = explode( ',', $components );
		}

		$message = '';
		if ( in_array( $option, $components ) ) {
			// For all components that are selected, set the meassage
			$message = JText::_( 'REMOVED, NOT ENABLED' );
		}

		$components = $this->getTagArea( $str, 'component' );

		foreach ( $components as $component ) {
			$this->processArticles( $component[1], 'components', $message );
			$str = str_replace( $component[0], $component[1], $str );
		}

		// EVERYWHERE
		$this->processArticles( $str, 'other' );
	}

	function tagArea( &$str, $area = '' )
	{
		if ( $area ) {
			if ( is_array( $str ) ) {
				foreach ( $str as $key => $val ) {
					$this->tagArea( $val, $area );
					$str[ $key ] = $val;
				}
			} else if ( $str ) {
				$str = '<!-- START: ARTA_'.strtoupper( $area ).' -->'.$str.'<!-- END: ARTA_'.strtoupper( $area ).' -->';
			}
		}
	}
	function getTagArea( $str, $area = '' )
	{
		$matches = array( '', '' );

		if ( $str && $area ) {
			preg_match_all( '#<\!-- START: ARTA_'.strtoupper( $area ).' -->(.*?)<\!-- END: ARTA_'.strtoupper( $area ).' -->#s', $str, $matches, PREG_SET_ORDER );
		}

		return $matches;
	}

	function processArticles( &$string, $area = 'articles', $message = '' )
	{
		if ( preg_match_all( $this->params->regex, $string, $matches, PREG_SET_ORDER ) > 0 ) {
			if (
				$area == 'articles' && !$this->params->articles_enable ||
				$area == 'components' && !$this->params->components_enable ||
				$area == 'other' && !$this->params->other_enable
			) {
				$message = JText::_( 'REMOVED, NOT ENABLED' );
			}
			foreach ( $matches as $match ) {
				$article = trim( $match['1'] );
				$text = trim( $match['2'] );

				if ( $message != '' ) {
					$article_html = '<!-- '.JText::_( 'Comment - Articles Anywhere' ).': '.$message.' -->';
				} else {
					$article_html = $this->processArticle( $article, $text );
					$article_html = '<!-- >>> Articles Anywhere >>> -->'.$article_html.'<!-- <<< Articles Anywhere <<< -->';
				}
				$string = str_replace( $match['0'], $article_html, $string );
			}
		}
	}

	function processArticle( $article, $text = '' )
	{
		$mainframe = &JFactory::getApplication();

		$regex = '#\{([^\}]+)\}#si';
		if ( preg_match_all( $regex, $text, $matches, PREG_SET_ORDER ) > 0 ) {
			$database	=& JFactory::getDBO();
			$user		=& JFactory::getUser();
			$aid		= $user->get( 'aid', 0 );

			$text_selects = array();
			foreach ( $matches as $match ) {
				$data = trim( $match['1'] );
				if ( !( strpos( $data, 'intro' ) === false ) ) {
					$text_selects[] = 'introtext';
				} else if ( !( strpos( $data, 'full' ) === false ) ) {
					$text_selects[] = 'fulltext';
				} else if ( !( strpos( $data, 'text' ) === false ) ) {
					$text_selects[] = 'introtext';
					$text_selects[] = 'fulltext';
				}
			}
			if ( !empty( $text_selects ) ) {
				$text_selects = array_unique($text_selects);
				$text_selects = ', `'.implode( '`, `', $text_selects ).'`';
			} else {
				$text_selects = '';
			}

			$where = ' AND ( title = '.$database->Quote( html_entity_decode( $article ) );
			$where .= ' OR  alias = '.$database->Quote( html_entity_decode( $article ) );
			if ( is_numeric( $article ) ) {
				$where .= ' OR id = '.$article;
			}
			$where .=  ' ) ';

			$query = 'SELECT'
					.' `id`, `title`, `alias`, `title_alias`, `state`,'
					.'`sectionid`, `mask`, `catid`,'
					.'`created`, `created_by`, `created_by_alias`,'
					.'`modified`, `modified_by`,'
					.'`checked_out`, `checked_out_time`, `publish_up`, `publish_down`,'
					.'`images`, `urls`, `attribs`, `version`, `parentid`,'
					.'`ordering`, `metakey`, `metadesc`, `access`, `hits`, `metadata`'
					.$text_selects
				.' FROM #__content'
				.' WHERE access <= '.(int) $aid
				.' AND state = 1'
				.$where
				.' ORDER BY ordering'
				.' LIMIT 1';

			$database->setQuery( $query );
			$row = $database->loadObject();
			
			if ( !$row ) {
				$message = 'Access to article denied';
				return '<!-- '.JText::_( 'Comment - Articles Anywhere' ).': '.$message.' -->';
			}
			foreach ( $matches as $match ) {
				$data = trim( $match['1'] );
				$ok = 0;
				$str = '';
				if (
						( $data == 'link' || $data == 'url' )
					||	!( strpos( $data, 'readmore' ) === false )
				) {
					if ( isset( $row->id ) ) {
						$link = 'index.php?option=com_content&view=article&id='.$row->id;
						if ( $row->catid ) {
							$link .= '&catid='.$row->catid;
						}

						$component	=& JComponentHelper::getComponent( 'com_content' );
						$menus		= &JApplication::getMenu( 'site', array() );
						$menuitems	= $menus->getItems( 'componentid', $component->id );
						$id = 0;
						foreach( $menuitems as $item ) {
							if ( ( @$item->query['view'] == 'article' ) && ( @$item->query['id'] == $row->id )) {
								$id = $item->id;
								break;
							}
						}
						if ( $id ) {
							$link .= '&Itemid='.$id;
						}

						if ( $data == 'link' || $data == 'url' ) {
							$str = $link;
						} else {
							$readmore = JText::sprintf( 'Read more...' );

							if ( !( strpos( $data, ':' ) === false ) ) {
								$rm = explode( ':', $data );
								$rm = trim( $rm['1'] );
								if ( strlen ( $rm ) ) {
									$readmore = JText::_( $rm );
								}
							}

							$str = '<a href="'.JRoute::_( $link ).'">'.$readmore.'</a>';
						}
						$ok = 1;
					}
				} else if (
						!( strpos( $data, 'text' ) === false )
					||	!( strpos( $data, 'intro' ) === false )
					||	!( strpos( $data, 'full' ) === false )
				) {
					// TEXT data

					if ( !( strpos( $data, 'intro' ) === false ) ) {
						if ( isset( $row->introtext ) ) {
							$str = $row->introtext;
							$ok = 1;
						}
					} else if ( !( strpos( $data, 'full' ) === false ) ) {
						if ( isset( $row->fulltext ) ) {
							$str = $row->fulltext;
							$ok = 1;
						}
					} else if ( !( strpos( $data, 'text' ) === false ) ) {
						if ( isset( $row->introtext ) && isset( $row->fulltext ) ) {
							$str = $row->introtext.$row->fulltext;
							$ok = 1;
						}
					}

					if ( $str && !( strpos( $data, ':' ) === false ) ) {
						$max = explode( ':', $data );
						$max = (int) $max['1'];
						if ( $max ) {
							// add explode helper strings around tags
							$explode_str = '<!-- ARTA_TAG -->';
							$str = preg_replace( '#(<.*?>)#', $explode_str.'\1'.$explode_str, $str );
							$str_array = explode( $explode_str, $str );

							$str = array();
							$opentags = array();
							$count = 0;
							foreach ( $str_array as $i => $str_part ) {
								if ( fmod( $i, 2 ) ) {
									// is tag
									$str[] = $str_part;
									preg_match( '#^<((?:\/)?)([a-z]+)#i', $str_part, $tag );
									// only is tag is not a single html tag
									if (	!empty( $tag )
										&&	( strpos( $str_part, '/>' ) === false )
											// just in case single html tag has no closing character
										&& 	!in_array( $tag['2'], array( 'area', 'br', 'hr', 'img', 'input', 'param' ) )
									) {
										if ( $tag['1'] ) {
											// is close tag
											if ( $opentags[count($opentags)-1] == $tag['2'] ) {
												unset( $opentags[count($opentags)-1] );
											}
										} else {
											$opentags[] = $tag['2'];
										}
									}
								} else {
									if ( $max < ( $count + strlen( $str_part ) ) ) {
										// strpart has to be cut off
										$maxlen = $max-$count;
										if ( $maxlen < 3 ) {
											$str[] = '...';
										} else {
											$str[] = rtrim( substr( $str_part, 0, ( $maxlen-3 ) ) ).'...';
										}
										break;
									} else {
										$count += strlen( $str_part );
										$str[] = $str_part;
									}
								}
							}
							// revers sort open tags
							krsort( $opentags );
							foreach ( $opentags as $tag ) {
								// add closing tag to end of string
								$str[] = '</'.$tag.'>';
							}
							$str = implode( '', $str );
						}
					}
				} else {
					if ( isset( $row->$data ) ) {
						$str = $row->$data;
						$ok = 1;
					}
				}
				if ( $ok ) {
					$text = str_replace( $match['0'], $str, $text );
				}
			}
		}

		return $text;
	}

		/*
	 * Protect input and text area's
	 */
	function protect( &$string )
	{
		$mainframe = &JFactory::getApplication();
		$option = JRequest::getCmd( 'option' );
		$task = JRequest::getCmd( 'task' );

		// Protect complete adminForm (to prevent articles from being created when editing articles and such)
		$regex = '#<form [^>]*name="adminForm".*?>.*?<div id="editor-xtd-buttons".*?</form>#si';
		if ( preg_match_all( $regex, $string, $matches, PREG_SET_ORDER ) > 0 ) {
			$protected_syntax = $this->protectStr( '{'.$this->params->article_tag );
			foreach ( $matches as $match ) {
				if ( !( strpos( $match[0], '{'.$this->params->article_tag ) === false ) ) {
					$form_string = str_replace( '{'.$this->params->article_tag, $protected_syntax, $match[0] );
					$string = str_replace( $match[0], $form_string, $string );
				}
			}
		}
	}

	function unprotect( &$string )
	{
		$protected_start = $this->protectStr( '{'.$this->params->article_tag );
		$string = str_replace( $protected_start, '{'.$this->params->article_tag, $string );
	}

	function protectStr( $string )
	{
		$string = base64_encode( $string );
		return $string;
	}

	function cleanLeftoverJunk( &$str )
	{
		$str = preg_replace( $this->params->regex, '', $str );
		$str = preg_replace( '#<\!-- (START|END): ARTA_[^>]* -->#', '', $str );
	}

	function removeGeneratedArticles( &$str )
	{
		$start_comment = '<!-- >>> Articles Anywhere >>> -->';
		$end_comment = '<!-- <<< Articles Anywhere <<< -->';
		$str = preg_replace( '#'.preg_quote( $start_comment, '#' ).'.*?'.preg_quote( $end_comment, '#' ).'\s*#s', '', $str );
		$str = preg_replace( '#'.preg_quote( htmlentities( $start_comment ), '#' ).'.*?'.preg_quote( htmlentities( $end_comment ), '#' ).'\s*#s', '', $str );
	}
	
	function getParamValues( &$params ) {
		$values = '';
		if ( isset( $params->_xml ) ) {
			foreach ( $params->_xml as $xml_group ) {
				foreach ( $xml_group->children() as $xml_child ) {
					$key = $xml_child->attributes('name');
					if ( !empty( $key ) && $key['0'] != '@' ) {
						$val = $params->get( $key );
						if ( !is_array( $val ) && !strlen( $val ) ) {
							$val = $xml_child->attributes('default');
							if ( $xml_child->attributes('type') == 'textarea' ) {
								$val = str_replace( '<br />', "\n", $val );
							}
						}
						$values->$key = $val;
					}
				}
			}
		}

		return $values;
	}
}

if ( !function_exists( 'html_entity_decoder' ) ) {
	function html_entity_decoder( $given_html, $quote_style = ENT_QUOTES, $charset = 'UTF-8' ) {
		if ( phpversion() < '5.0.0' ) {
			$trans_table = array_flip( get_html_translation_table( HTML_SPECIALCHARS, $quote_style ) );
			$trans_table['&#39;'] = "'";
			return ( strtr( $given_html, $trans_table ) );
		}else {
			return html_entity_decode( $given_html, $quote_style, $charset );
		}
	}
}