<?php
/**
 * Element: Slide
 * Element to create a new slide pane
 *
 * @package    NoNumber! Elements
 * @version    v1.0.6
 *
 * @author     Peter van Westen <peter@nonumber.nl>
 * @link       http://www.nonumber.nl
 * @copyright  Copyright (C) 2009 NoNumber! All Rights Reserved
 * @license    http://www.gnu.org/licenses/gpl-2.0.html GNU/GPL
 */

// Ensure this file is being included by a parent file
defined( '_JEXEC' ) or die( 'Restricted access' );

/**
 * Slide Element
 */
class JElementSlide extends JElement
{
	/**
	 * Element name
	 *
	 * @access	protected
	 * @var		string
	 */
	var	$_name = 'Slide';

	function fetchTooltip( $label, $description, &$node, $control_name, $name )
	{
		return;
	}

	function fetchElement( $name, $value, &$node, $control_name )
	{
		$label =		$node->attributes( 'label' );
		$description =	$node->attributes( 'description' );
		$show_apply =	$node->attributes( 'show_apply' );

		$html = '</td></tr></table></div></div>';
		$html .= '<div class="panel"><h3 class="jpane-toggler title" id="advanced-page"><span>';
		$html .= html_entity_decoder( JText::_( $label ) );
		$html .= '</span></h3>';
		$html .= '<div class="jpane-slider content"><table width="100%" class="paramlist admintable" cellspacing="1"><tr><td class="paramlist_value" colspan="2">';

		if ( $description ) { $description = html_entity_decoder( JText::_( $description ) ); }

		// Include extra language file
		$lang = JFactory::getLanguage();
		$lang = str_replace( '_', '-', $lang->_lang );

		$include_file = 'language.'.$lang.'.inc.php';
		if ( !file_exists( dirname( __FILE__ ).DS.$include_file ) ) {
			$include_file = 'language.en-GB.inc.php';
		}
		if ( file_exists( dirname( __FILE__ ).DS.$include_file ) ) {
			include dirname( __FILE__ ).DS.$include_file;
		}

		if ( $description ) {
			$html .= '<div class="panel"><div style="padding: 2px 5px;">';
			if ( $show_apply ) {
				$apply_button = '<a href="#" onclick="submitbutton( \'apply\' );" title="'.JText::_( 'Apply' ).'"><img align="right" border="0" alt="'.JText::_( 'Apply' ).'" src="images/tick.png"/></a>';
				$html .= $apply_button;
			}
			$html .= $description;
			$html .= '<div style="clear: both;"></div></div></div>';
		}

		return $html;
	}

	function def( $val, $default )
	{
		return ( $val == '' ) ? $default : $val;
	}
}

if( !function_exists( 'html_entity_decoder' ) )
{
	function html_entity_decoder( $given_html, $quote_style = ENT_QUOTES, $charset = 'UTF-8' ) {
		if( phpversion() < '5.0.0' ) {
			$trans_table = array_flip( get_html_translation_table( HTML_SPECIALCHARS, $quote_style ) );
			$trans_table['&#39;'] = "'";
			return ( strtr( $given_html, $trans_table ) );
		}else {
			return html_entity_decode( $given_html, $quote_style, $charset );
		}
	}
}