<?php
/**
 * Element: Text Area Plus
 * Displays a text area with extra options
 *
 * @package    NoNumber! Elements
 * @version    v1.0.8
 *
 * @author     Peter van Westen <peter@nonumber.nl>
 * @link       http://www.nonumber.nl
 * @copyright  Copyright (C) 2009 NoNumber! All Rights Reserved
 * @license    http://www.gnu.org/licenses/gpl-2.0.html GNU/GPL
 */

// Ensure this file is being included by a parent file
defined( '_JEXEC' ) or die( 'Restricted access' );

/**
 * Text Area Plus Element
 */
class JElementTextAreaPlus extends JElement
{
	/**
	 * Element name
	 *
	 * @access	protected
	 * @var		string
	 */
	var	$_name = 'TextAreaPlus';

	function fetchTooltip( $label, $description, &$node, $control_name, $name )
	{

		$rows =		$this->def( $node->attributes( 'rows' ), 4 );
		$example =	$node->attributes( 'example' );

		$html = '<label id="'.$control_name.$name.'-lbl" for="'.$control_name.$name.'"';
		if ( $description ) {
			$html .= ' class="hasTip" title="'.JText::_( $label).'::'.JText::_( $description).'">';
		} else {
			$html .= '>';
		}
		$html .= JText::_( $label ).'</label>';

		if( $example ) {
			$el = 'document.getElementById( \''.$control_name.$name.'\' )';
			$onclick = $el.'.value = \''.str_replace( "'", "\'", $example ).'\n\'+'.$el.'.value;'
				.'this.blur();return false;';
			$html .= '<br clear="all" />';
			$html .= '<div class="button2-left" style="float:right;margin-top:5px;"><div class="blank"><a href="javascript://;" onclick="'.$onclick.'">'.JText::_( 'Example' ).'</a></div></div>'."\n";
		}

		return $html;
	}

	function fetchElement( $name, $value, &$node, $control_name )
	{
		$resize =	$node->attributes( 'resize' );
		$width =	$this->def( $node->attributes( 'width' ), 400 );
		$height =	$this->def( $node->attributes( 'height' ), 80 );
		$class =	$this->def( $node->attributes( 'class' ), 'text_area' );
		$class =	'class="'.$class.'"';
		$type =		$node->attributes( 'texttype' );

		if( $resize ) {
			$file_root =	str_replace( array( '\\', '/' ), DS, dirname( __FILE__ ) );
			$file_root = explode( DS, $file_root );
			foreach ( $file_root as $folder ) {
				if ( !in_array( $folder, array( 'administrator', 'components', 'modules', 'plugins', 'templates' ) ) ) {
					array_shift ( $file_root );
				} else {
					break;
				}
			}
			$file_root = implode( '/', $file_root );

			$document	=& JFactory::getDocument();
			$document->addScript( JURI::root(true).'/'.$file_root.'/textareaplus/textareaplus.js' );
			$document->addStyleSheet( JURI::root(true).'/'.$file_root.'/textareaplus/textareaplus.css' );
			$script = "
				window.addEvent( 'domready', function() {
					// not for Safari (and other webkit browsers) because it has its own resize option
					if ( !window.webkit ) {
						new TextAreaResizer( '".$control_name.$name."', { 'min_x':160, 'max_x':800, 'min_y':80, 'max_y':400 } );
					}
				});

			";
			$document->addScriptDeclaration( $script );
		}

		if ( $type == 'html' ) {
			// Convert <br /> tags so they are not visible when editing
			$value = str_replace( '<br />', "\n", $value );
		} else if ( $type == 'regex' ) {
			// Protects the special characters
			$value = str_replace( '[:REGEX_ENTER:]', '\n', $value );
			$value = htmlspecialchars( $value );
		}

		return '<textarea name="'.$control_name.'['.$name.']" style="width:'.$width.'px;height:'.$height.'px" '.$class.' id="'.$control_name.$name.'" >'.$value.'</textarea>';
	}

	function def( $val, $default )
	{
		return ( $val == '' ) ? $default : $val;
	}
}