<?php
/**
* @version		$Id: flexicontent.php 2009-11-14 vistamedia $
* @package      JCE Advlink
* @copyright    Copyright (C) 2008 - 2009 Ryan Demmer. All rights reserved.
* @author		Ryan Demmer
* @author		Emmanuel Danan
* @license      GNU/GPL
* JCE is free software. This version may have been modified pursuant
* to the GNU General Public License, and as distributed it includes or
* is derivative of works licensed under the GNU General Public License or
* other free or open source software licenses.
*/
// no direct access
defined('_JCE_EXT') or die('Restricted access');

$fparams =& JComponentHelper::getParams('com_flexicontent');
if (!defined('FLEXI_SECTION')) define('FLEXI_SECTION', $fparams->get('flexi_section'));
if (!defined('FLEXI_ACCESS')) define('FLEXI_ACCESS', (JPluginHelper::isEnabled('system', 'flexiaccess') && version_compare(PHP_VERSION, '5.0.0', '>')) ? 1 : 0);

class AdvlinkFlexicontent 
{
	function getOptions()
	{
		$advlink =& AdvLink::getInstance();
		$list = '';
//		this function seems to be a little buggish, here's a workaround ;-)
//		if ($advlink->checkAccess('advlink_flexicontent', '1')) {
		if ($advlink->plugin->params->get('advlink_flexicontent', '1')) {
			$list = '<li id="index.php?option=com_flexicontent"><div class="tree-row"><div class="tree-image"></div><span class="folder flexicontent nolink"><a href="javascript:;">' . JText::_('FLEXIcontent') . '</a></span></div></li>';
		}
		return $list;	
	}
	
	function getItems($args)
	{		
		$advlink =& AdvLink::getInstance();
		
		require_once(JPATH_SITE .DS. 'components' .DS. 'com_flexicontent' .DS. 'helpers' .DS. 'route.php');

		$items 		= array();
		$view		= isset($args->view) ? $args->view : '';
		
		switch ($view)
		{
			default:
				$categories	= AdvlinkFlexicontent::_Categories();
				foreach ($categories as $category) {
					$items[] = array(
						'id'		=>	FlexicontentHelperRoute::getCategoryRoute($category->slug),
						'name'		=>	$category->title,
						'class'		=>	'folder flexicontent'
					);
				}
				break;
	
			case 'tags':
				$tags	= AdvlinkFlexicontent::_Tags();
				if (isset($args->id)) {
					break;
				}
				foreach ($tags as $tag) {
					$items[] = array(
						'id'		=>	FlexicontentHelperRoute::getTagRoute($tag->slug),
						'name'		=>	$tag->name,
						'class'		=>	'file flexitags'
					);
				}
				break;

			case 'category':
				$categories	= AdvlinkFlexicontent::_Categories($args->cid);
				$contents 	= AdvlinkFlexicontent::_Items($args->cid);
				foreach ($categories as $category) {
					$items[] = array(
						'id'		=>	FlexicontentHelperRoute::getCategoryRoute($category->slug),
						'name'		=>	$category->title,
						'class'		=>	'folder flexicontent'
					);
				}
				foreach ($contents as $content) {
					$items[] = array(
						'id'		=>	FlexicontentHelperRoute::getItemRoute($content->slug, $content->categoryslug),
						'name'		=>	$content->title,
						'class'		=>	($content->icatid == (int)$args->cid) ? 'file' : 'seclink'
					);
				}
				break;
				
			case 'items':
				break;
		}
		return $items;
	}

	function _Categories($parent = 0)
	{
		$db		=& JFactory::getDBO();
		$user	=& JFactory::getUser();
		$aid	= (int)$user->get('aid');

		// Will create the advanced acl authorisations later
		$and   = FLEXI_ACCESS ? '' : ' AND access <= ' . $aid;

		$query 	= 'SELECT id, title, alias,'
				. ' CASE WHEN CHAR_LENGTH(alias) THEN CONCAT_WS(\':\', id, alias) ELSE id END as slug'
				. ' FROM #__categories'
				. ' WHERE published = 1'
				. ' AND section = ' . FLEXI_SECTION
				. ' AND parent_id = ' . $db->Quote($parent)
				. $and
				. ' ORDER BY ordering ASC'
				;

		$db->setQuery($query);
		return $db->loadObjectList();
	}
	
	function _Items($cid = 0)
	{
		$db		=& JFactory::getDBO();
		$user	=& JFactory::getUser();
		$aid	= (int)$user->get('aid');
		
		// Will create the advanced acl authorisations later
		$and   = FLEXI_ACCESS ? '' : ' AND c.access <= ' . $aid;
		$and  .= FLEXI_ACCESS ? '' : ' AND i.access <= ' . $aid;
		
		// Check if it's usefull to implement authorisations here as authors can theoritically
		// create links even if they can't access to them
		$query	= 'SELECT i.*, i.title AS ititle, i.catid AS icatid, c.access AS cataccess, c.id AS catid, c.published AS catpublished,'
				. ' CASE WHEN CHAR_LENGTH(i.alias) THEN CONCAT_WS(\':\', i.id, i.alias) ELSE i.id END as slug,'
				. ' CASE WHEN CHAR_LENGTH(c.alias) THEN CONCAT_WS(\':\', c.id, c.alias) ELSE c.id END as categoryslug'
				. ' FROM #__content AS i'
				. ' LEFT JOIN #__flexicontent_cats_item_relations AS rel ON rel.itemid = i.id'
				. ' LEFT JOIN #__categories AS c ON c.id = rel.catid'
				. ' WHERE c.id = ' . $db->Quote($cid)
				. $and
				. ' ORDER BY i.title, rel.ordering, i.ordering ASC'
//				. ' ORDER BY rel.ordering, i.ordering ASC'
				;

		$db->setQuery($query);
		return $db->loadObjectList();
	}

	function _Tags()
	{
		$db		=& JFactory::getDBO();
		
		$query = 'SELECT t.name, t.id,'
				. ' CASE WHEN CHAR_LENGTH(t.alias) THEN CONCAT_WS(\':\', t.id, t.alias) ELSE t.id END as slug'
				. ' FROM #__flexicontent_tags AS t'
				. ' WHERE t.published = 1'
				. ' ORDER BY t.name ASC'
				;

		$db->setQuery($query);
		return $db->loadObjectList();
	}
	
}
?>