<?php
/**
 * @version 1.0.0 $Id: com_flexicontent.php 166 2009-11-15 17:38:31Z vistamedia $
 * @package Joomla
 * @subpackage Xmap plugin for FLEXIcontent
 * @copyright (C) 2009 Emmanuel Danan - www.vistamedia.fr
 * @license GNU/GPL v2
 * 
 * FLEXIcontent is a derivative work of the excellent QuickFAQ component
 * @copyright (C) 2008 Christoph Lukes
 * see www.schlu.net for more information
 *
 * FLEXIcontent is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 */

// no direct access
defined( '_JEXEC' ) or die( 'Restricted access' );

require_once (JPATH_SITE.DS.'components'.DS.'com_flexicontent'.DS.'helpers'.DS.'route.php');

class xmap_com_flexicontent {

	/*
	 * Base entry
	 */
	function getTree( &$xmap, &$parent, &$params) {
	
		if ( strpos($parent->link, 'view=favourites') || strpos($parent->link, 'view=items') ) {
			return;	
		}

		$link_query = parse_url( $parent->link );
		parse_str( html_entity_decode( $link_query['query']), $link_vars );
		$catid = JArrayHelper::getValue( $link_vars, 'cid', 0 );
		$tid = JArrayHelper::getValue( $link_vars, 'id', 0 );

		$include_items = JArrayHelper::getValue( $params, 'include_items',1,'' );
		$include_items = ( $include_items == 1
						|| ( $include_items == 2 && $xmap->view == 'xml') 
						|| ( $include_items == 3 && $xmap->view == 'html'));
		$params['include_items'] = $include_items;

		//Category settings
		$priority 	= JArrayHelper::getValue( $params, 'cat_priority', $parent->priority, '' );
		$changefreq = JArrayHelper::getValue( $params, 'cat_changefreq', $parent->changefreq, '' );
		
		if ($priority  == '-1') {
			$priority = $parent->priority;
		}
		
		if ($changefreq  == '-1') {
			$changefreq = $parent->changefreq;
		}

		$params['cat_priority'] 	= $priority;
		$params['cat_changefreq'] 	= $changefreq;

		//Item settings
		$priority 	= JArrayHelper::getValue( $params, 'item_priority', $parent->priority, '' );
		$changefreq = JArrayHelper::getValue( $params, 'item_changefreq', $parent->changefreq, '' );
		
		if ($priority  == '-1') {
			$priority = $parent->priority;
		}

		if ($changefreq  == '-1') {
			$changefreq = $parent->changefreq;
		}

		$params['item_priority'] 	= $priority;
		$params['item_changefreq'] 	= $changefreq;

		if ( $include_items ) {
			$params['limit'] 	= '';
			$params['days'] 	= '';
			$limit 				= JArrayHelper::getValue( $params, 'max_items', '', '' );

			if ( intval($limit) ) {
				$params['limit'] = ' LIMIT '.(int)$limit;
			}
			
			$days = JArrayHelper::getValue( $params, 'max_age', '', '' );
			
			if ( intval($days) ) {
				$params['days'] = ' AND i.created >= \''.date('Y-m-d H:m:s', ($xmap->now - ($days*86400)) ) ."' ";
			}
		}
		
		//Get the data
		if (strpos($parent->link, 'view=tags')) {
			xmap_com_flexicontent::getFlexicontentTagTree( $xmap, $parent, $params, $tid );
		} else {
			xmap_com_flexicontent::getFlexicontentCatTree( $xmap, $parent, $params, $catid );
		}
	}

	/*
	 * Get the Categories with with their items
	 */
	function getFlexicontentCatTree ( &$xmap, &$parent, &$params, &$catid ) {
		
		$db 		= &JFactory::getDBO();
		$user 		= &JFactory::getUser();
		$gid		= (int) $user->get('aid');
		$nullDate	= $db->getNullDate();
		$date 		= & JFactory::getDate();
		$now  		= $date->toMySQL();
		
		$xmap->changeLevel(1);
		
		// Exclude parents when parsing a category menu item
		if (!strpos($parent->link, 'view=category')) {
		
			$query 	= 'SELECT c.id, c.title, c.parent_id,'
					. ' CASE WHEN CHAR_LENGTH( c.alias ) THEN CONCAT_WS( \':\', c.id, c.alias ) ELSE c.id END AS slug'
					. ' FROM #__categories AS c'
					. ' WHERE c.published = 1'
					. ' AND c.parent_id = '.(int)$catid
					. ' AND c.access <= '.$gid
					. ' ORDER BY c.ordering'
					;
			$db->setQuery( $query );
			$cats = $db->loadObjectList();
		
			foreach($cats as $cat) {
				$node = new stdclass;
				$node->id   		= $parent->id;
				$node->uid  		= $parent->uid.'c'.$cat->id;
				$node->pid  		= $cat->parent_id;
				$node->name 		= $cat->title;
				$node->priority   	= $params['cat_priority'];
				$node->changefreq 	= $params['cat_changefreq'];
				$node->link 		= FlexicontentHelperRoute::getCategoryRoute( $cat->slug );
				$node->tree 		= array();

				// parents
				if ($xmap->printNode($node) !== FALSE) {
					xmap_com_flexicontent::getFlexicontentCatTree($xmap, $parent, $params, $cat->id);
				}
			}
		}
		
		if ($params['include_items']) {
		
			// First thing we need to do is to select only the requested items
			$where = ' WHERE rel.catid = '.(int)$catid;

			// Second is to only select items the user has access to
			// @todo : Must be adapted to FLEXIaccess later
			$states = '1, -5';
			if ($gid > 2) {
				$states .= ', 0 , -3, -4';
			}
			$where .= ' AND i.state IN ('.$states.')';
			$where .= ' AND i.access <= '.$gid;
			$where .= ' AND ( i.publish_up = '.$db->Quote($nullDate).' OR i.publish_up <= '.$db->Quote($now).' )';
			$where .= ' AND ( i.publish_down = '.$db->Quote($nullDate).' OR i.publish_down >= '.$db->Quote($now).' )';
			$where .= ' AND c.published = 1';
			$where .= ' AND c.access <= '.$gid;
			
			$where .= $params['days'];
			
			$query = 'SELECT DISTINCT i.id, i.title, c.id AS cid,'
					. ' CASE WHEN CHAR_LENGTH(i.alias) THEN CONCAT_WS(\':\', i.id, i.alias) ELSE i.id END as slug,'
					. ' CASE WHEN CHAR_LENGTH( c.alias ) THEN CONCAT_WS( \':\', c.id, c.alias ) ELSE c.id END AS catslug'
					. ' FROM #__content AS i'
					. ' LEFT JOIN #__flexicontent_cats_item_relations AS rel ON rel.itemid = i.id'
					. ' LEFT JOIN #__categories AS c ON c.id = '. (int)$catid
					. $where
					. ' ORDER BY i.title'
					. $params['limit']
					;

			$db->setQuery ( $query );
			$items = $db->loadObjectList();
			
			foreach($items as $item) {
				$node = new stdclass;
				$node->id   		= $parent->id;
				$node->uid  		= $parent->uid .'d'.$item->id;
				$node->name 		= $item->title;
				$node->link 		= FlexicontentHelperRoute::getItemRoute( $item->slug, $item->catslug );
				$node->priority   	= $params['item_priority'];
				$node->changefreq 	= $params['item_changefreq'];
				$node->tree 		= array();
				$xmap->printNode($node);
			}
			
			$xmap->changeLevel(-1);
		} else {
			$xmap->changeLevel(-1);
		}
	}
	
	/*
	 * When tag is used a menu item, get the items tagged
	 */
	function getFlexicontentTagTree ( &$xmap, &$parent, &$params, &$tid ) {
		
		$db 		= &JFactory::getDBO();
		$user 		= &JFactory::getUser();
		$gid		= (int) $user->get('aid');
		$nullDate	= $db->getNullDate();
		$date 		= & JFactory::getDate();
		$now  		= $date->toMySQL();
		
		$xmap->changeLevel(1);
				
		if ($params['include_items']) {
		
			// First thing we need to do is to select only the requested items
			$where = ' WHERE t.tid = '.(int)$tid;

			// Second is to only select items the user has access to
			$states = '1, -5';
			if ($gid > 2) {
				$states .= ', 0 , -3, -4';
			}
			$where .= ' AND i.state IN ('.$states.')';
			$where .= ' AND i.access <= '.$gid;
			$where .= ' AND ( i.publish_up = '.$db->Quote($nullDate).' OR i.publish_up <= '.$db->Quote($now).' )';
			$where .= ' AND ( i.publish_down = '.$db->Quote($nullDate).' OR i.publish_down >= '.$db->Quote($now).' )';
			$where .= ' AND c.published = 1';
			$where .= ' AND c.access <= '.$gid;
			
			$where .= $params['days'];
			
			$query 	= 'SELECT DISTINCT i.id, i.title, c.id AS cid,'
					. ' CASE WHEN CHAR_LENGTH(i.alias) THEN CONCAT_WS(\':\', i.id, i.alias) ELSE i.id END as slug,'
					. ' CASE WHEN CHAR_LENGTH( c.alias ) THEN CONCAT_WS( \':\', c.id, c.alias ) ELSE c.id END AS catslug'
					. ' FROM #__content AS i'
					. ' INNER JOIN #__flexicontent_tags_item_relations AS t ON t.itemid = i.id'
					. ' LEFT JOIN #__flexicontent_cats_item_relations AS rel ON rel.itemid = i.id'
					. ' LEFT JOIN #__categories AS c ON c.id = rel.catid'
					. $where
					. ' ORDER BY i.title'
					. $params['limit']
					;

			$db->setQuery ( $query );
			$items = $db->loadObjectList();
			
			foreach($items as $item) {
				$node = new stdclass;
				$node->id   		= $parent->id;
				$node->uid  		= $parent->uid .'d'.$item->id;
				$node->name 		= $item->title;
				$node->link 		= FlexicontentHelperRoute::getItemRoute( $item->slug, $item->catslug );
				$node->priority   	= $params['item_priority'];
				$node->changefreq 	= $params['item_changefreq'];
				$node->tree 		= array();
				$xmap->printNode($node);
			}
			
			$xmap->changeLevel(-1);
			
		//if items shouldn't shown, switch one level back here
		} else {
			$xmap->changeLevel(-1);
		}
	}
}
?>