<?php
/**
 * Module Helper File
 *
 * @package     Add to Menu
 * @version     1.2.1
 *
 * @author      Peter van Westen <peter@nonumber.nl>
 * @link        http://www.nonumber.nl
 * @copyright   Copyright (C) 2010 NoNumber! All Rights Reserved
 * @license     http://www.gnu.org/licenses/gpl-2.0.html GNU/GPL
 */

// No direct access
defined( '_JEXEC' ) or die( 'Restricted access' );

class modAddToMenu
{
	function render( $params )
	{
		$option = JRequest::getCmd( 'option' );

		$this->vars = array();

		jimport( 'joomla.filesystem.folder' );
		jimport( 'joomla.filesystem.file' );

		$folder = dirname(__FILE__).DS.'components'.DS.$option;
		$comp_file = '';
		foreach ( JFolder::files( $folder, '.php' ) as $filename ) {
			$file = $folder.DS.$filename;
			if ( JFile::exists( $file ) ) {
				$component = '';
				require_once $file;
				if ( $component ) {
					if ( modAddToMenu::checkRequiredFields( $component ) ) {
						$comp_file = JFile::stripExt( $filename );
						break;
					}
				}
			}
		}

		if ( !$comp_file ) {
			return;
		}

		JHTML::_( 'behavior.modal' );
		
		$document =& JFactory::getDocument();
		$document->addScript( JURI::root( true ).'/administrator/modules/mod_addtomenu/addtomenu/js/addtomenu.js' );
		$document->addStyleSheet( JURI::root( true ).'/administrator/modules/mod_addtomenu/addtomenu/css/addtomenu.css' );

		// set height for popup
		$popup_height = 320;
		if ( isset( $component['adjust_height'] ) ) {
			$popup_height += $component['adjust_height'];
		}
		if ( count( $component['extra'] ) ) {
			// + height of title
			$popup_height += 23 ;
			// + heights of elements
			foreach( $component['extra'] as $element ) {
				switch( $element['type'] ) {
					case 'radio':
						// add height for every line
						$popup_height += 8 + ( 16 * count( $element['value'] ) );
						break;
					case 'textarea':
						$popup_height += 111;
						break;
					case 'hidden':
						// no height
					default:
						$popup_height += 24;
						break;
				}
			}
		}

		$link = 'index.php?nn_qp=1';
		$link .= '&folder=administrator.modules.mod_addtomenu.addtomenu';
		$link .= '&file=addtomenu.inc.php';
		$link .= '&comp='.$comp_file;

		$uri =& JFactory::getURI();
		$url_query = $uri->getQuery( 1 );
		foreach ( $url_query as $key => $val ) {
			$this->vars[$key] = $val;
		}
		foreach ( $this->vars as $key => $val ) {
			if ( is_array( $val ) ) {
				$val = $val['0'];
			}
			$link .= '&vars['.$key.']='.$val;
		}

		$text = JText::_( 'Add to Menu' );
		$class = '';
		if ( $params->get( 'display_link', 'both' ) == 'text' ) {
			$class = 'no_icon';
		} else if ( $params->get( 'display_link', 'both' ) == 'icon' ) {
			$text = '';
			$class = 'no_text';
		} 

		echo '<a href="'.$link.'" onfocus="this.blur();" id="addtomenu" class="modal" title="'.JText::_( 'Add to Menu' ).'" rel="{handler: \'iframe\', size: {x: 400, y: '.$popup_height.'}}"><span class="'.$class.'">'.$text.'</span></a>';
	}

	function getVar( $var ) {
		$url = JRequest::getVar( 'url' );
		$extra = JRequest::getVar( 'extra' );

		if ( $var['0'] == '$' ) {
			$var = substr( $var, 1 );
			$var = modAddToMenu::getVal( $var );
		}
		return $var;
	}

	function getVal( $val ) {
		$url = JRequest::getVar( 'url' );
		$extra = JRequest::getVar( 'extra' );

		if( isset( $url[$val] ) ) {
			$val = $url[$val];
		} else if( isset( $extra[$val] ) ) {
			$val = $extra[$val];
		} else {
			$val = JRequest::getVar( $val );
		}
		if ( is_array( $val ) ) {
			$val = $val['0'];
		}

		return $val;
	}

	function checkRequiredFields( $component ) {
		$pass = 1;
		foreach( $component['required'] as $key => $values ) {
			$keyval = modAddToMenu::getVal( $key );
			if ( !is_array( $values ) ) {
				$values = array ( $values );
			}
			foreach ( $values as $val ) {
				$pass = 0;
				switch ( $val ) {
					case '*':
						if ( strlen( $keyval ) ) {
							$pass = 1;
						}
						break;
					case '+':
						if ( $keyval ) {
							$pass = 1;
						}
						break;
					default:
						if ( $keyval == $val ) {
							$pass = 1;
						}
						break;
				}
				if ( $pass ) {
					break;
				}
			}
			if ( !$pass ) {
				break;
			}
			$this->vars[$key] = $keyval;
		}
		return $pass;
	}
}